/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.dictionary;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.pentaho.dictionary.MetaverseLink;
import org.pentaho.dictionary.MetaverseTransientNode;
import org.pentaho.metaverse.api.IMetaverseNode;

public class DictionaryHelper {
    public static final Set<String> STRUCTURAL_LINK_TYPES = new HashSet<String>();
    public static final Set<String> ENTITY_NODE_TYPES = new HashSet<String>();
    public static final Set<String> DATAFLOW_LINK_TYPES = new HashSet<String>();
    private static Map<String, String> categoryColorMap = new HashMap<String, String>();
    private static Map<String, String> typeCategoryMap = new HashMap<String, String>();
    private static Map<String, Map<String, String>> entityTypeLinks = new HashMap<String, Map<String, String>>();

    protected DictionaryHelper() {
        throw new UnsupportedOperationException();
    }

    public static void registerEntityType(String entityType) {
        DictionaryHelper.registerEntityType(null, entityType, null);
    }

    public static void registerEntityType(String linkType, String entityType, String parentEntityType) {
        if (linkType != null) {
            Map<String, String> links = entityTypeLinks.get(linkType);
            if (links == null) {
                links = new HashMap<String, String>();
                entityTypeLinks.put(linkType, links);
            }
            links.put(entityType, parentEntityType);
        }
        if (!StringUtils.isBlank((String)entityType)) {
            ENTITY_NODE_TYPES.add(entityType);
        }
    }

    public static void registerStructuralLinkType(String linkType) {
        STRUCTURAL_LINK_TYPES.add(linkType);
    }

    public static void registerDataFlowLinkType(String linkType) {
        DATAFLOW_LINK_TYPES.add(linkType);
    }

    public static boolean isStructuralLinkType(String linkType) {
        return STRUCTURAL_LINK_TYPES.contains(linkType);
    }

    public static boolean isDataFlowLinkType(String linkType) {
        return DATAFLOW_LINK_TYPES.contains(linkType);
    }

    public static boolean isEntityType(String nodeType) {
        return ENTITY_NODE_TYPES.contains(nodeType);
    }

    public static void registerEntityTypes() {
        DictionaryHelper.registerEntityType("parentconcept", "External Connection", null);
        DictionaryHelper.registerEntityType("parentconcept", "Database Connection", "External Connection");
        DictionaryHelper.registerEntityType("parentconcept", "Database Table", null);
        DictionaryHelper.registerEntityType("parentconcept", "Database Column", null);
        DictionaryHelper.registerEntityType("parentconcept", "MongoDB Connection", "External Connection");
        DictionaryHelper.registerEntityType("parentconcept", "MongoDB Collection", null);
        DictionaryHelper.registerEntityType("parentconcept", "Job", null);
        DictionaryHelper.registerEntityType("containsconcept", "Job Entry", "Job");
        DictionaryHelper.registerEntityType("parentconcept", "Logical Model", null);
        DictionaryHelper.registerEntityType("parentconcept", "Transformation", null);
        DictionaryHelper.registerEntityType("containsconcept", "Transformation Step", "Transformation");
        DictionaryHelper.registerEntityType("containsconcept", "Transformation Stream field", "Transformation Step");
        DictionaryHelper.registerEntityType("parentconcept", "User Content", null);
        DictionaryHelper.registerEntityType("parentconcept", "File", null);
        DictionaryHelper.registerEntityType("containsconcept", "File Field", "File");
        DictionaryHelper.registerEntityType("parentconcept", "JSON File", "File");
        DictionaryHelper.registerEntityType("parentconcept", "JSON Field", "File Field");
        DictionaryHelper.registerEntityType("containsconcept", "JSON Field", "JSON File");
    }

    public static String getNonEntityToEntityLinkType() {
        return "typeconcept";
    }

    public static boolean addNonEntityToEntityLinkTypeLabel() {
        return true;
    }

    public static Set<String> getEntityLinkTypes() {
        return entityTypeLinks.keySet();
    }

    public static String getParentEntityNodeType(String linkType, String nodeName) {
        Map<String, String> parentLinkMap = entityTypeLinks.get(linkType);
        if (parentLinkMap != null) {
            return parentLinkMap.get(nodeName);
        }
        return null;
    }

    public static boolean linksToRoot(String linkType, String nodeName) {
        Map<String, String> parentLinkMap = entityTypeLinks.get(linkType);
        if (parentLinkMap != null) {
            return parentLinkMap.get(nodeName) == null && parentLinkMap.containsKey(nodeName);
        }
        return false;
    }

    public static String getCategoryForType(String type) {
        String category = typeCategoryMap.get(type);
        if (category == null) {
            category = "other";
        }
        return category;
    }

    public static String getColorForCategory(String category) {
        String color = categoryColorMap.get(category);
        if (color == null) {
            color = categoryColorMap.get("other");
        }
        return color;
    }

    public static IMetaverseNode createMetaverseNode(String id, String name, String type, Properties properties) {
        MetaverseTransientNode node = new MetaverseTransientNode();
        node.setStringID(id);
        node.setType(type);
        node.setName(name);
        if (properties != null) {
            Enumeration<?> propertyNames = properties.propertyNames();
            while (propertyNames.hasMoreElements()) {
                Object propertyName = propertyNames.nextElement();
                Object value = properties.get(propertyName);
                node.setProperty(propertyName.toString(), value);
            }
        }
        return node;
    }

    public static IMetaverseNode addChildNode(String id, String name, String type, Properties properties, IMetaverseNode parent, String relationship) {
        MetaverseTransientNode child = (MetaverseTransientNode)DictionaryHelper.createMetaverseNode(id, name, type, properties);
        if (parent instanceof MetaverseTransientNode) {
            MetaverseLink link = new MetaverseLink(parent, relationship, child);
            ((MetaverseTransientNode)parent).addLink(link);
        }
        return child;
    }

    static {
        DictionaryHelper.registerStructuralLinkType("executes");
        DictionaryHelper.registerStructuralLinkType("contains");
        DictionaryHelper.registerStructuralLinkType("defines");
        DictionaryHelper.registerStructuralLinkType("parentconcept");
        DictionaryHelper.registerDataFlowLinkType("populates");
        DictionaryHelper.registerDataFlowLinkType("isreadby");
        DictionaryHelper.registerDataFlowLinkType("writesto");
        DictionaryHelper.registerDataFlowLinkType("derives");
        DictionaryHelper.registerDataFlowLinkType("dependencyof");
        categoryColorMap.put("abstract", "#dddddd");
        categoryColorMap.put("datasource", "#ff6600");
        categoryColorMap.put("document", "#ccffcc");
        categoryColorMap.put("documentelement", "#ccffff");
        categoryColorMap.put("field", "#ffcc99");
        categoryColorMap.put("collection", "#ff9900");
        categoryColorMap.put("repository", "#66aa44");
        categoryColorMap.put("other", "#ffcccc");
        typeCategoryMap.put("Database Connection", "datasource");
        typeCategoryMap.put("Database Table", "collection");
        typeCategoryMap.put("Database Column", "field");
        typeCategoryMap.put("Job", "document");
        typeCategoryMap.put("Job Entry", "documentelement");
        typeCategoryMap.put("Transformation", "document");
        typeCategoryMap.put("Transformation Step", "documentelement");
        typeCategoryMap.put("Transformation Stream field", "field");
        typeCategoryMap.put("Entity", "abstract");
        typeCategoryMap.put("File", "collection");
        typeCategoryMap.put("JSON File", "collection");
        typeCategoryMap.put("File Field", "field");
        typeCategoryMap.put("JSON Field", "field");
        typeCategoryMap.put("Locator", "repository");
        typeCategoryMap.put("Root_Entity", "abstract");
        typeCategoryMap.put("Web Service", "datasource");
    }
}

