/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="md5", value="_FUNC_(str or bin) - Calculates an MD5 128-bit checksum for the string or binary.", extended="The value is returned as a string of 32 hex digits, or NULL if the argument was NULL.\nExample:\n  > SELECT _FUNC_('ABC');\n  '902fbdd2b1df0c4f70b4a5d23525e932'\n  > SELECT _FUNC_(binary('ABC'));\n  '902fbdd2b1df0c4f70b4a5d23525e932'")
public class UDFMd5
extends UDF {
    private final Text result = new Text();

    public Text evaluate(Text n) {
        if (n == null) {
            return null;
        }
        String str = n.toString();
        String md5Hex = DigestUtils.md5Hex((String)str);
        this.result.set(md5Hex);
        return this.result;
    }

    public Text evaluate(BytesWritable b) {
        if (b == null) {
            return null;
        }
        byte[] bytes = this.copyBytes(b);
        String md5Hex = DigestUtils.md5Hex((byte[])bytes);
        this.result.set(md5Hex);
        return this.result;
    }

    protected byte[] copyBytes(BytesWritable b) {
        int size = b.getLength();
        byte[] result = new byte[size];
        System.arraycopy(b.getBytes(), 0, result, 0, size);
        return result;
    }
}

