/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.mapred.JobConf;

public class MergeJoinWork
extends BaseWork {
    private CommonMergeJoinOperator mergeJoinOp = null;
    private final List<BaseWork> mergeWorkList = new ArrayList<BaseWork>();
    private BaseWork bigTableWork;

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public void replaceRoots(Map<Operator<?>, Operator<?>> replacementMap) {
        this.getMainWork().replaceRoots(replacementMap);
    }

    @Override
    public Set<Operator<?>> getAllRootOperators() {
        return this.getMainWork().getAllRootOperators();
    }

    @Override
    public void configureJobConf(JobConf job) {
    }

    public CommonMergeJoinOperator getMergeJoinOperator() {
        return this.mergeJoinOp;
    }

    public void setMergeJoinOperator(CommonMergeJoinOperator mergeJoinOp) {
        this.mergeJoinOp = mergeJoinOp;
    }

    public void addMergedWork(BaseWork work, BaseWork connectWork, Map<Operator<?>, BaseWork> leafOperatorToFollowingWork) {
        if (work != null) {
            if (this.bigTableWork != null && this.bigTableWork != work) assert (false);
            this.bigTableWork = work;
            this.setName(work.getName());
        }
        if (connectWork != null) {
            this.mergeWorkList.add(connectWork);
            if (connectWork instanceof ReduceWork && this.bigTableWork != null) {
                this.setReduceSinkOutputName(connectWork, leafOperatorToFollowingWork, this.bigTableWork.getName());
            }
        }
        if (work != null) {
            for (BaseWork mergeWork : this.mergeWorkList) {
                if (!(mergeWork instanceof ReduceWork)) continue;
                this.setReduceSinkOutputName(mergeWork, leafOperatorToFollowingWork, work.getName());
            }
        }
    }

    private void setReduceSinkOutputName(BaseWork mergeWork, Map<Operator<?>, BaseWork> leafOperatorToFollowingWork, String name) {
        for (Map.Entry<Operator<?>, BaseWork> entry : leafOperatorToFollowingWork.entrySet()) {
            if (entry.getValue() != mergeWork) continue;
            ((ReduceSinkDesc)((ReduceSinkOperator)entry.getKey()).getConf()).setOutputName(name);
        }
    }

    @Explain(skipHeader=true, displayName="Join", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<BaseWork> getBaseWorkList() {
        return this.mergeWorkList;
    }

    public String getBigTableAlias() {
        return ((MapWork)this.bigTableWork).getAliasToWork().keySet().iterator().next();
    }

    @Explain(skipHeader=true, displayName="Main", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public BaseWork getMainWork() {
        return this.bigTableWork;
    }

    @Override
    public void setDummyOps(List<HashTableDummyOperator> dummyOps) {
        this.getMainWork().setDummyOps(dummyOps);
    }

    @Override
    public List<HashTableDummyOperator> getDummyOps() {
        return this.getMainWork().getDummyOps();
    }

    @Override
    public void addDummyOp(HashTableDummyOperator dummyOp) {
        this.getMainWork().addDummyOp(dummyOp);
    }
}

