/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.CommonMergeJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.RecordSource;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorDeserializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinaryDeserializeRead;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.tez.runtime.library.api.KeyValuesReader;

public class ReduceRecordSource
implements RecordSource {
    public static final Log l4j = LogFactory.getLog(ReduceRecordSource.class);
    private static final String CLASS_NAME = ReduceRecordSource.class.getName();
    private byte tag;
    private boolean abort = false;
    private Deserializer inputKeyDeserializer;
    private SerDe inputValueDeserializer;
    private TableDesc keyTableDesc;
    private TableDesc valueTableDesc;
    private ObjectInspector rowObjectInspector;
    private Operator<?> reducer;
    private Object keyObject = null;
    private BytesWritable groupKey;
    private boolean vectorized = false;
    private VectorDeserializeRow keyBinarySortableDeserializeToRow;
    private VectorDeserializeRow valueLazyBinaryDeserializeToRow;
    private VectorizedRowBatch batch;
    private int firstValueColumnOffset;
    private final int BATCH_SIZE = 1024;
    private StructObjectInspector keyStructInspector;
    private StructObjectInspector valueStructInspectors;
    private List<VectorExpressionWriter> valueStringWriters;
    private KeyValuesReader reader;
    private boolean handleGroupKey;
    private ObjectInspector valueObjectInspector;
    private final PerfLogger perfLogger = PerfLogger.getPerfLogger();
    private Iterable<Object> valueWritables;
    private final GroupIterator groupIterator = new GroupIterator();

    void init(JobConf jconf, Operator<?> reducer, boolean vectorized, TableDesc keyTableDesc, TableDesc valueTableDesc, KeyValuesReader reader, boolean handleGroupKey, byte tag, VectorizedRowBatchCtx batchContext) throws Exception {
        this.reducer = reducer;
        this.vectorized = vectorized;
        this.keyTableDesc = keyTableDesc;
        this.reader = reader;
        this.handleGroupKey = handleGroupKey;
        this.tag = tag;
        try {
            this.inputKeyDeserializer = (Deserializer)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
            SerDeUtils.initializeSerDe(this.inputKeyDeserializer, null, keyTableDesc.getProperties(), null);
            ObjectInspector keyObjectInspector = this.inputKeyDeserializer.getObjectInspector();
            if (vectorized) {
                this.keyStructInspector = (StructObjectInspector)keyObjectInspector;
                this.firstValueColumnOffset = this.keyStructInspector.getAllStructFieldRefs().size();
            }
            this.valueTableDesc = valueTableDesc;
            this.inputValueDeserializer = (SerDe)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
            SerDeUtils.initializeSerDe(this.inputValueDeserializer, null, valueTableDesc.getProperties(), null);
            this.valueObjectInspector = this.inputValueDeserializer.getObjectInspector();
            ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
            if (vectorized) {
                this.valueStructInspectors = (StructObjectInspector)this.valueObjectInspector;
                int totalColumns = this.firstValueColumnOffset + this.valueStructInspectors.getAllStructFieldRefs().size();
                this.valueStringWriters = new ArrayList<VectorExpressionWriter>(totalColumns);
                this.valueStringWriters.addAll(Arrays.asList(VectorExpressionWriterFactory.genVectorStructExpressionWritables(this.keyStructInspector)));
                this.valueStringWriters.addAll(Arrays.asList(VectorExpressionWriterFactory.genVectorStructExpressionWritables(this.valueStructInspectors)));
                this.rowObjectInspector = Utilities.constructVectorizedReduceRowOI(this.keyStructInspector, this.valueStructInspectors);
                this.batch = batchContext.createVectorizedRowBatch();
                BinarySortableSerDe binarySortableSerDe = (BinarySortableSerDe)this.inputKeyDeserializer;
                this.keyBinarySortableDeserializeToRow = new VectorDeserializeRow(new BinarySortableDeserializeRead(VectorizedBatchUtil.typeInfosFromStructObjectInspector(this.keyStructInspector), binarySortableSerDe.getSortOrders()));
                this.keyBinarySortableDeserializeToRow.init(0);
                int valuesSize = this.valueStructInspectors.getAllStructFieldRefs().size();
                if (valuesSize > 0) {
                    this.valueLazyBinaryDeserializeToRow = new VectorDeserializeRow(new LazyBinaryDeserializeRead(VectorizedBatchUtil.typeInfosFromStructObjectInspector(this.valueStructInspectors)));
                    this.valueLazyBinaryDeserializeToRow.init(this.firstValueColumnOffset);
                    for (int i = this.firstValueColumnOffset; i < this.batch.numCols; ++i) {
                        ColumnVector colVector = this.batch.cols[i];
                        if (!(colVector instanceof BytesColumnVector)) continue;
                        BytesColumnVector bytesColumnVector = (BytesColumnVector)colVector;
                        bytesColumnVector.initBuffer();
                    }
                }
            } else {
                ois.add(keyObjectInspector);
                ois.add(this.valueObjectInspector);
                this.rowObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector(Utilities.reduceFieldNameList, ois);
            }
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Reduce operator initialization failed", e);
        }
        this.perfLogger.PerfLogEnd(CLASS_NAME, "TezInitializeOperators");
    }

    @Override
    public final boolean isGrouped() {
        return this.vectorized;
    }

    @Override
    public boolean pushRecord() throws HiveException {
        if (this.vectorized) {
            return this.pushRecordVector();
        }
        if (this.groupIterator.hasNext()) {
            this.groupIterator.next();
            return true;
        }
        try {
            if (!this.reader.next()) {
                return false;
            }
            BytesWritable keyWritable = (BytesWritable)this.reader.getCurrentKey();
            this.valueWritables = this.reader.getCurrentValues();
            try {
                this.keyObject = this.inputKeyDeserializer.deserialize((Writable)keyWritable);
            }
            catch (Exception e) {
                throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input key from " + Utilities.formatBinaryString(keyWritable.getBytes(), 0, keyWritable.getLength()) + " with properties " + this.keyTableDesc.getProperties(), e);
            }
            if (this.handleGroupKey && !keyWritable.equals((Object)this.groupKey)) {
                if (this.groupKey == null) {
                    this.groupKey = new BytesWritable();
                } else {
                    this.reducer.endGroup();
                }
                this.groupKey.set(keyWritable.getBytes(), 0, keyWritable.getLength());
                this.reducer.startGroup();
                this.reducer.setGroupKeyObject(this.keyObject);
            }
            this.groupIterator.initialize(this.valueWritables, this.keyObject, this.tag);
            if (this.groupIterator.hasNext()) {
                this.groupIterator.next();
            }
            return true;
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            l4j.fatal((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private Object deserializeValue(BytesWritable valueWritable, byte tag) throws HiveException {
        try {
            return this.inputValueDeserializer.deserialize((Writable)valueWritable);
        }
        catch (SerDeException e) {
            throw new HiveException("Hive Runtime Error: Unable to deserialize reduce input value (tag=" + tag + ") from " + Utilities.formatBinaryString(valueWritable.getBytes(), 0, valueWritable.getLength()) + " with properties " + this.valueTableDesc.getProperties(), e);
        }
    }

    private boolean pushRecordVector() {
        try {
            if (!this.reader.next()) {
                return false;
            }
            BytesWritable keyWritable = (BytesWritable)this.reader.getCurrentKey();
            this.valueWritables = this.reader.getCurrentValues();
            if (this.handleGroupKey && !keyWritable.equals((Object)this.groupKey)) {
                if (this.groupKey == null) {
                    this.groupKey = new BytesWritable();
                } else {
                    this.reducer.endGroup();
                }
                this.groupKey.set(keyWritable.getBytes(), 0, keyWritable.getLength());
                this.reducer.startGroup();
            }
            this.processVectorGroup(keyWritable, this.valueWritables, this.tag);
            return true;
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            l4j.fatal((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private void processVectorGroup(BytesWritable keyWritable, Iterable<Object> values, byte tag) throws HiveException, IOException {
        byte[] keyBytes = keyWritable.getBytes();
        int keyLength = keyWritable.getLength();
        this.keyBinarySortableDeserializeToRow.setBytes(keyBytes, 0, keyLength);
        this.keyBinarySortableDeserializeToRow.deserializeByValue(this.batch, 0);
        for (int i = 0; i < this.firstValueColumnOffset; ++i) {
            VectorizedBatchUtil.setRepeatingColumn(this.batch, i);
        }
        int rowIdx = 0;
        try {
            for (Object value : values) {
                if (this.valueLazyBinaryDeserializeToRow != null) {
                    BytesWritable valueWritable = (BytesWritable)value;
                    byte[] valueBytes = valueWritable.getBytes();
                    int valueLength = valueWritable.getLength();
                    this.valueLazyBinaryDeserializeToRow.setBytes(valueBytes, 0, valueLength);
                    this.valueLazyBinaryDeserializeToRow.deserializeByValue(this.batch, rowIdx);
                }
                if (++rowIdx < 1024) continue;
                VectorizedBatchUtil.setBatchSize(this.batch, rowIdx);
                this.reducer.process(this.batch, tag);
                for (int i = this.firstValueColumnOffset; i < this.batch.numCols; ++i) {
                    this.batch.cols[i].reset();
                }
                rowIdx = 0;
            }
            if (rowIdx > 0) {
                VectorizedBatchUtil.setBatchSize(this.batch, rowIdx);
                this.reducer.process(this.batch, tag);
            }
            this.batch.reset();
        }
        catch (Exception e) {
            String rowString = null;
            try {
                this.batch.setValueWriters(this.valueStringWriters.toArray(new VectorExpressionWriter[0]));
                rowString = this.batch.toString();
            }
            catch (Exception e2) {
                rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
            }
            throw new HiveException("Hive Runtime Error while processing vector batch (tag=" + tag + ") " + rowString, e);
        }
    }

    boolean close() throws Exception {
        block3: {
            try {
                if (this.handleGroupKey && this.groupKey != null) {
                    this.reducer.endGroup();
                }
            }
            catch (Exception e) {
                if (this.abort) break block3;
                throw new RuntimeException("Hive Runtime Error while closing operators: " + e.getMessage(), e);
            }
        }
        return this.abort;
    }

    public ObjectInspector getObjectInspector() {
        return this.rowObjectInspector;
    }

    private class GroupIterator {
        private final List<Object> row = new ArrayList<Object>(Utilities.reduceFieldNameList.size());
        private List<Object> passDownKey = null;
        private Iterator<Object> values;
        private byte tag;
        private Object keyObject;

        private GroupIterator() {
        }

        public void initialize(Iterable<Object> values, Object keyObject, byte tag) {
            this.passDownKey = null;
            this.values = values.iterator();
            this.tag = tag;
            this.keyObject = keyObject;
        }

        public boolean hasNext() {
            return this.values != null && this.values.hasNext();
        }

        public void next() throws HiveException {
            this.row.clear();
            Object value = this.values.next();
            BytesWritable valueWritable = (BytesWritable)value;
            if (this.passDownKey == null) {
                this.row.add(this.keyObject);
            } else {
                this.row.add(this.passDownKey.get(0));
            }
            if (this.passDownKey == null && ReduceRecordSource.this.reducer instanceof CommonMergeJoinOperator) {
                this.passDownKey = (List)ObjectInspectorUtils.copyToStandardObject(this.row, ReduceRecordSource.this.reducer.getInputObjInspectors()[this.tag], ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                this.row.remove(0);
                this.row.add(0, this.passDownKey.get(0));
            }
            this.row.add(ReduceRecordSource.this.deserializeValue(valueWritable, this.tag));
            try {
                ReduceRecordSource.this.reducer.process(this.row, this.tag);
            }
            catch (Exception e) {
                String rowString = null;
                try {
                    rowString = SerDeUtils.getJSONString(this.row, ReduceRecordSource.this.rowObjectInspector);
                }
                catch (Exception e2) {
                    rowString = "[Error getting row data with exception " + StringUtils.stringifyException((Throwable)e2) + " ]";
                }
                throw new HiveException("Hive Runtime Error while processing row (tag=" + this.tag + ") " + rowString, e);
            }
        }
    }
}

