/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.ObjectCache;
import org.apache.hadoop.hive.ql.exec.ObjectCacheFactory;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecMapper;
import org.apache.hadoop.hive.ql.exec.tez.RecordProcessor;
import org.apache.hadoop.hive.ql.exec.tez.ReduceRecordSource;
import org.apache.hadoop.hive.ql.exec.tez.TezContext;
import org.apache.hadoop.hive.ql.exec.tez.TezProcessor;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.tez.mapreduce.processor.MRTaskReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.LogicalOutput;
import org.apache.tez.runtime.api.ProcessorContext;
import org.apache.tez.runtime.library.api.KeyValuesReader;

public class ReduceRecordProcessor
extends RecordProcessor {
    private static final String REDUCE_PLAN_KEY = "__REDUCE_PLAN__";
    private ObjectCache cache;
    private String cacheKey;
    public static final Log l4j = LogFactory.getLog(ReduceRecordProcessor.class);
    private ReduceWork reduceWork;
    List<BaseWork> mergeWorkList = null;
    List<String> cacheKeys;
    private final Map<Integer, DummyStoreOperator> connectOps = new TreeMap<Integer, DummyStoreOperator>();
    private final Map<Integer, ReduceWork> tagToReducerMap = new HashMap<Integer, ReduceWork>();
    private Operator<?> reducer;
    private ReduceRecordSource[] sources;
    private byte bigTablePosition = 0;
    private boolean abort;

    public ReduceRecordProcessor(final JobConf jconf, ProcessorContext context) throws Exception {
        super(jconf, context);
        ObjectCache cache = ObjectCacheFactory.getCache((Configuration)jconf);
        String queryId = HiveConf.getVar((Configuration)jconf, HiveConf.ConfVars.HIVEQUERYID);
        this.cacheKey = queryId + REDUCE_PLAN_KEY;
        this.cacheKeys = new ArrayList<String>();
        this.cacheKeys.add(this.cacheKey);
        this.reduceWork = (ReduceWork)cache.retrieve(this.cacheKey, new Callable<Object>(){

            @Override
            public Object call() {
                return Utilities.getReduceWork((Configuration)jconf);
            }
        });
        Utilities.setReduceWork((Configuration)jconf, this.reduceWork);
        this.mergeWorkList = this.getMergeWorkList(jconf, this.cacheKey, queryId, cache, this.cacheKeys);
    }

    @Override
    void init(MRTaskReporter mrReporter, Map<String, LogicalInput> inputs, Map<String, LogicalOutput> outputs) throws Exception {
        this.perfLogger.PerfLogBegin(this.CLASS_NAME, "TezInitializeOperators");
        super.init(mrReporter, inputs, outputs);
        MapredContext.init(false, new JobConf((Configuration)this.jconf));
        List<LogicalInput> shuffleInputs = this.getShuffleInputs(inputs);
        if (shuffleInputs != null) {
            l4j.info((Object)"Waiting for ShuffleInputs to become ready");
            this.processorContext.waitForAllInputsReady(new ArrayList<LogicalInput>(shuffleInputs));
        }
        this.connectOps.clear();
        ReduceWork redWork = this.reduceWork;
        l4j.info((Object)("Main work is " + this.reduceWork.getName()));
        List<HashTableDummyOperator> workOps = this.reduceWork.getDummyOps();
        HashSet<HashTableDummyOperator> dummyOps = workOps == null ? null : new HashSet<HashTableDummyOperator>(workOps);
        this.tagToReducerMap.put(redWork.getTag(), redWork);
        if (this.mergeWorkList != null) {
            for (BaseWork mergeWork : this.mergeWorkList) {
                if (l4j.isDebugEnabled()) {
                    l4j.debug((Object)("Additional work " + mergeWork.getName()));
                }
                if ((workOps = mergeWork.getDummyOps()) != null) {
                    if (dummyOps == null) {
                        dummyOps = new HashSet<HashTableDummyOperator>(workOps);
                    } else {
                        dummyOps.addAll(workOps);
                    }
                }
                ReduceWork mergeReduceWork = (ReduceWork)mergeWork;
                this.reducer = mergeReduceWork.getReducer();
                DummyStoreOperator dummyStoreOp = this.getJoinParentOp(this.reducer);
                this.connectOps.put(mergeReduceWork.getTag(), dummyStoreOp);
                this.tagToReducerMap.put(mergeReduceWork.getTag(), mergeReduceWork);
            }
            this.bigTablePosition = (byte)this.reduceWork.getTag();
            ((TezContext)MapredContext.get()).setDummyOpsMap(this.connectOps);
        }
        ObjectInspector[] mainWorkOIs = null;
        ((TezContext)MapredContext.get()).setInputs(inputs);
        ((TezContext)MapredContext.get()).setTezProcessorContext(this.processorContext);
        int numTags = this.reduceWork.getTagToValueDesc().size();
        this.reducer = this.reduceWork.getReducer();
        if (numTags > 1) {
            this.sources = new ReduceRecordSource[numTags];
            mainWorkOIs = new ObjectInspector[numTags];
            this.initializeMultipleSources(this.reduceWork, numTags, mainWorkOIs, this.sources);
            ((TezContext)MapredContext.get()).setRecordSources(this.sources);
            this.reducer.initialize((Configuration)this.jconf, mainWorkOIs);
        } else {
            numTags = this.tagToReducerMap.keySet().size();
            this.sources = new ReduceRecordSource[numTags];
            mainWorkOIs = new ObjectInspector[numTags];
            Iterator<Serializable> i$ = this.tagToReducerMap.keySet().iterator();
            while (i$.hasNext()) {
                int i = i$.next();
                redWork = this.tagToReducerMap.get(i);
                this.reducer = redWork.getReducer();
                this.initializeSourceForTag(redWork, i, mainWorkOIs, this.sources, redWork.getTagToValueDesc().get(0), redWork.getTagToInput().get(0));
                this.reducer.initializeLocalWork((Configuration)this.jconf);
            }
            this.reducer = this.reduceWork.getReducer();
            ((TezContext)MapredContext.get()).setRecordSources(this.sources);
            this.reducer.initialize((Configuration)this.jconf, new ObjectInspector[]{mainWorkOIs[this.bigTablePosition]});
            i$ = this.tagToReducerMap.keySet().iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (i == this.bigTablePosition) continue;
                redWork = this.tagToReducerMap.get(i);
                this.reducer = redWork.getReducer();
                this.reducer.initialize((Configuration)this.jconf, new ObjectInspector[]{mainWorkOIs[i]});
            }
        }
        this.reducer = this.reduceWork.getReducer();
        try {
            l4j.info((Object)this.reducer.dump(0));
            if (dummyOps != null) {
                for (HashTableDummyOperator dummyOp : dummyOps) {
                    dummyOp.initialize((Configuration)this.jconf, null);
                }
            }
            LinkedList<Operator<? extends OperatorDesc>> children = new LinkedList<Operator<? extends OperatorDesc>>();
            children.add(this.reducer);
            if (dummyOps != null) {
                children.addAll(dummyOps);
            }
            this.createOutputMap();
            OperatorUtils.setChildrenCollector(children, this.outMap);
            this.reducer.setReporter((Reporter)this.reporter);
            MapredContext.get().setReporter((Reporter)this.reporter);
        }
        catch (Throwable e) {
            this.abort = true;
            if (e instanceof OutOfMemoryError) {
                throw (OutOfMemoryError)e;
            }
            throw new RuntimeException("Reduce operator initialization failed", e);
        }
        this.perfLogger.PerfLogEnd(this.CLASS_NAME, "TezInitializeOperators");
    }

    private void initializeMultipleSources(ReduceWork redWork, int numTags, ObjectInspector[] ois, ReduceRecordSource[] sources) throws Exception {
        for (int tag = 0; tag < redWork.getTagToValueDesc().size(); ++tag) {
            if (redWork.getTagToValueDesc().get(tag) == null) continue;
            this.initializeSourceForTag(redWork, tag, ois, sources, redWork.getTagToValueDesc().get(tag), redWork.getTagToInput().get(tag));
        }
    }

    private void initializeSourceForTag(ReduceWork redWork, int tag, ObjectInspector[] ois, ReduceRecordSource[] sources, TableDesc valueTableDesc, String inputName) throws Exception {
        this.reducer = redWork.getReducer();
        this.reducer.getParentOperators().clear();
        this.reducer.setParentOperators(null);
        TableDesc keyTableDesc = redWork.getKeyDesc();
        KeyValuesReader reader = (KeyValuesReader)((LogicalInput)this.inputs.get(inputName)).getReader();
        sources[tag] = new ReduceRecordSource();
        boolean vectorizedRecordSource = tag == this.bigTablePosition && redWork.getVectorMode();
        sources[tag].init(this.jconf, redWork.getReducer(), vectorizedRecordSource, keyTableDesc, valueTableDesc, reader, tag == this.bigTablePosition, (byte)tag, redWork.getVectorizedRowBatchCtx());
        ois[tag] = sources[tag].getObjectInspector();
    }

    @Override
    void run() throws Exception {
        for (Map.Entry outputEntry : this.outputs.entrySet()) {
            l4j.info((Object)("Starting Output: " + (String)outputEntry.getKey()));
            ((LogicalOutput)outputEntry.getValue()).start();
            ((TezProcessor.TezKVOutputCollector)this.outMap.get(outputEntry.getKey())).initialize();
        }
        while (this.sources[this.bigTablePosition].pushRecord()) {
        }
    }

    private List<LogicalInput> getShuffleInputs(Map<String, LogicalInput> inputs) throws Exception {
        Map<Integer, String> tagToinput = this.reduceWork.getTagToInput();
        ArrayList<LogicalInput> shuffleInputs = new ArrayList<LogicalInput>();
        for (String inpStr : tagToinput.values()) {
            if (inputs.get(inpStr) == null) {
                throw new AssertionError((Object)("Cound not find input: " + inpStr));
            }
            inputs.get(inpStr).start();
            shuffleInputs.add(inputs.get(inpStr));
        }
        return shuffleInputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    void close() {
        if (this.cache != null && this.cacheKeys != null) {
            for (String key : this.cacheKeys) {
                this.cache.release(key);
            }
        }
        try {
            List<HashTableDummyOperator> dummyOps;
            void var3_9;
            ReduceRecordSource[] arr$ = this.sources;
            int len$ = arr$.length;
            boolean bl = false;
            while (var3_9 < len$) {
                ReduceRecordSource rs = arr$[var3_9];
                this.abort = this.abort && rs.close();
                ++var3_9;
            }
            this.reducer.close(this.abort);
            if (this.mergeWorkList != null) {
                for (BaseWork redWork : this.mergeWorkList) {
                    ((ReduceWork)redWork).getReducer().close(this.abort);
                }
            }
            if ((dummyOps = this.reduceWork.getDummyOps()) != null) {
                for (Operator operator : dummyOps) {
                    operator.close(this.abort);
                }
            }
            ExecMapper.ReportStats rps = new ExecMapper.ReportStats((Reporter)this.reporter, (Configuration)this.jconf);
            this.reducer.preorderMap(rps);
        }
        catch (Exception e) {
            if (!this.abort) {
                l4j.error((Object)"Hit error while closing operators - failing tree");
                throw new RuntimeException("Hive Runtime Error while closing operators: " + e.getMessage(), e);
            }
        }
        finally {
            Utilities.clearWorkMap((Configuration)this.jconf);
            MapredContext.close();
        }
    }

    private DummyStoreOperator getJoinParentOp(Operator<?> mergeReduceOp) {
        Iterator<Operator<OperatorDesc>> i$ = mergeReduceOp.getChildOperators().iterator();
        if (i$.hasNext()) {
            Operator<OperatorDesc> childOp = i$.next();
            if (childOp.getChildOperators() == null || childOp.getChildOperators().isEmpty()) {
                if (childOp instanceof DummyStoreOperator) {
                    return (DummyStoreOperator)childOp;
                }
                throw new IllegalStateException("Was expecting dummy store operator but found: " + childOp);
            }
            return this.getJoinParentOp(childOp);
        }
        throw new IllegalStateException("Expecting a DummyStoreOperator found op: " + mergeReduceOp);
    }
}

