/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xmloutput;

import java.io.File;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmloutput.XMLField;
import org.pentaho.di.trans.steps.xmloutput.XMLOutputData;
import org.pentaho.di.trans.steps.xmloutput.XMLOutputMeta;

public class XMLOutput
extends BaseStep
implements StepInterface {
    private static final String EOL = "\n";
    private static final XMLOutputFactory XML_OUT_FACTORY = XMLOutputFactory.newInstance();
    private XMLOutputMeta meta;
    private XMLOutputData data;
    private OutputStream outputStream;

    public XMLOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (XMLOutputMeta)smi;
        this.data = (XMLOutputData)sdi;
        boolean result = true;
        Object[] r = this.getRow();
        if (this.first && this.meta.isDoNotOpenNewFileInit()) {
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.openNewFile()) {
                this.data.OpenedNewFile = true;
            } else {
                this.logError("Couldn't open file " + this.meta.getFileName());
                this.setErrors(1L);
                return false;
            }
        }
        if (r != null && this.getLinesOutput() > 0L && this.meta.getSplitEvery() > 0 && this.getLinesOutput() % (long)this.meta.getSplitEvery() == 0L) {
            this.closeFile();
            if (r != null && !this.openNewFile()) {
                this.logError("Unable to open new file (split #" + this.data.splitnr + "...");
                this.setErrors(1L);
                return false;
            }
        }
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.writeRowToFile(this.getInputRowMeta(), r);
        this.data.outputRowMeta = this.getInputRowMeta().clone();
        this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, (VariableSpace)this, this.repository, this.metaStore);
        this.putRow(this.data.outputRowMeta, r);
        if (this.checkFeedback(this.getLinesOutput())) {
            this.logBasic("linenr " + this.getLinesOutput());
        }
        return result;
    }

    private void writeRowToFile(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        try {
            ValueMetaInterface valueMeta;
            int i;
            if (this.first) {
                this.data.formatRowMeta = rowMeta.clone();
                this.first = false;
                this.data.fieldnrs = new int[this.meta.getOutputFields().length];
                for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                    this.data.fieldnrs[i] = this.data.formatRowMeta.indexOfValue(this.meta.getOutputFields()[i].getFieldName());
                    if (this.data.fieldnrs[i] < 0) {
                        throw new KettleException("Field [" + this.meta.getOutputFields()[i].getFieldName() + "] couldn't be found in the input stream!");
                    }
                    valueMeta = this.data.formatRowMeta.getValueMeta(this.data.fieldnrs[i]);
                    XMLField field = this.meta.getOutputFields()[i];
                    valueMeta.setConversionMask(field.getFormat());
                    valueMeta.setLength(field.getLength(), field.getPrecision());
                    valueMeta.setDecimalSymbol(field.getDecimalSymbol());
                    valueMeta.setGroupingSymbol(field.getGroupingSymbol());
                    valueMeta.setCurrencySymbol(field.getCurrencySymbol());
                }
            }
            if (this.meta.getOutputFields() == null || this.meta.getOutputFields().length == 0) {
                this.data.writer.writeStartElement(this.meta.getRepeatElement());
                for (i = 0; i < this.data.formatRowMeta.size(); ++i) {
                    if (i > 0) {
                        this.data.writer.writeCharacters(" ");
                    }
                    valueMeta = this.data.formatRowMeta.getValueMeta(i);
                    Object valueData = r[i];
                    this.writeField(valueMeta, valueData, valueMeta.getName());
                }
            } else {
                this.data.writer.writeStartElement(this.meta.getRepeatElement());
                this.writeRowAttributes(r);
                for (i = 0; i < this.meta.getOutputFields().length; ++i) {
                    XMLField outputField = this.meta.getOutputFields()[i];
                    if (outputField.getContentType() != XMLField.ContentType.Element) continue;
                    if (i > 0) {
                        this.data.writer.writeCharacters(" ");
                    }
                    ValueMetaInterface valueMeta2 = this.data.formatRowMeta.getValueMeta(this.data.fieldnrs[i]);
                    Object valueData = r[this.data.fieldnrs[i]];
                    String elementName = outputField.getElementName();
                    if (Utils.isEmpty((CharSequence)elementName)) {
                        elementName = outputField.getFieldName();
                    }
                    if (valueMeta2.isNull(valueData) && this.meta.isOmitNullValues()) continue;
                    this.writeField(valueMeta2, valueData, elementName);
                }
            }
            this.data.writer.writeEndElement();
            this.data.writer.writeCharacters(EOL);
        }
        catch (Exception e) {
            throw new KettleException("Error writing XML row :" + e.toString() + Const.CR + "Row: " + this.getInputRowMeta().getString(r), (Throwable)e);
        }
        this.incrementLinesOutput();
    }

    void writeRowAttributes(Object[] r) throws KettleValueException, XMLStreamException {
        for (int i = 0; i < this.meta.getOutputFields().length; ++i) {
            XMLField xmlField = this.meta.getOutputFields()[i];
            if (xmlField.getContentType() != XMLField.ContentType.Attribute) continue;
            ValueMetaInterface valueMeta = this.data.formatRowMeta.getValueMeta(this.data.fieldnrs[i]);
            Object valueData = r[this.data.fieldnrs[i]];
            String elementName = xmlField.getElementName();
            if (Utils.isEmpty((CharSequence)elementName)) {
                elementName = xmlField.getFieldName();
            }
            this.data.writer.writeAttribute(elementName, valueMeta.getString(valueData));
        }
    }

    private void writeField(ValueMetaInterface valueMeta, Object valueData, String element) throws KettleStepException {
        try {
            String value = valueMeta.getString(valueData);
            if (value != null) {
                this.data.writer.writeStartElement(element);
                this.data.writer.writeCharacters(value);
                this.data.writer.writeEndElement();
            } else {
                this.data.writer.writeEmptyElement(element);
            }
        }
        catch (Exception e) {
            throw new KettleStepException("Error writing line :", (Throwable)e);
        }
    }

    public String buildFilename(boolean ziparchive) {
        return this.meta.buildFilename((VariableSpace)this, this.getCopy(), this.data.splitnr, ziparchive);
    }

    public boolean openNewFile() {
        boolean retval = false;
        this.data.writer = null;
        try {
            if (this.meta.isServletOutput()) {
                this.data.writer = XML_OUT_FACTORY.createXMLStreamWriter(this.getTrans().getServletPrintWriter());
                if (this.meta.getEncoding() != null && this.meta.getEncoding().length() > 0) {
                    this.data.writer.writeStartDocument(this.meta.getEncoding(), "1.0");
                } else {
                    this.data.writer.writeStartDocument("UTF-8", "1.0");
                }
                this.data.writer.writeCharacters(EOL);
            } else {
                FileObject file = KettleVFS.getFileObject((String)this.buildFilename(true), (VariableSpace)this.getTransMeta());
                if (this.meta.isAddToResultFiles()) {
                    ResultFile resultFile = new ResultFile(0, file, this.getTransMeta().getName(), this.getStepname());
                    resultFile.setComment("This file was created with a xml output step");
                    this.addResultFile(resultFile);
                }
                if (this.meta.isZipped()) {
                    OutputStream fos = KettleVFS.getOutputStream((FileObject)file, (boolean)false);
                    this.data.zip = new ZipOutputStream(fos);
                    File entry = new File(this.buildFilename(false));
                    ZipEntry zipentry = new ZipEntry(entry.getName());
                    zipentry.setComment("Compressed by Kettle");
                    this.data.zip.putNextEntry(zipentry);
                    this.outputStream = this.data.zip;
                } else {
                    this.outputStream = KettleVFS.getOutputStream((FileObject)file, (boolean)false);
                }
                if (this.meta.getEncoding() != null && this.meta.getEncoding().length() > 0) {
                    this.logBasic("Opening output stream in encoding: " + this.meta.getEncoding());
                    this.data.writer = XML_OUT_FACTORY.createXMLStreamWriter(this.outputStream, this.meta.getEncoding());
                    this.data.writer.writeStartDocument(this.meta.getEncoding(), "1.0");
                } else {
                    this.logBasic("Opening output stream in default encoding : UTF-8");
                    this.data.writer = XML_OUT_FACTORY.createXMLStreamWriter(this.outputStream);
                    this.data.writer.writeStartDocument("UTF-8", "1.0");
                }
                this.data.writer.writeCharacters(EOL);
            }
            this.data.writer.writeStartElement(this.meta.getMainElement());
            if (this.meta.getNameSpace() != null && !"".equals(this.meta.getNameSpace())) {
                this.data.writer.writeDefaultNamespace(this.meta.getNameSpace());
            }
            this.data.writer.writeCharacters(EOL);
            retval = true;
        }
        catch (Exception e) {
            this.logError("Error opening new file : " + e.toString());
        }
        ++this.data.splitnr;
        return retval;
    }

    void closeOutputStream(OutputStream stream) {
        try {
            stream.close();
        }
        catch (Exception e) {
            this.logError("Error closing output stream : " + e.toString());
        }
    }

    private boolean closeFile() {
        boolean retval = false;
        if (this.data.OpenedNewFile) {
            try {
                this.data.writer.writeEndElement();
                this.data.writer.writeCharacters(EOL);
                this.data.writer.writeEndDocument();
                this.data.writer.close();
                if (this.meta.isZipped()) {
                    this.data.zip.closeEntry();
                    this.data.zip.finish();
                    this.data.zip.close();
                }
                this.closeOutputStream(this.outputStream);
                retval = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLOutputMeta)smi;
        this.data = (XMLOutputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.splitnr = 0;
            if (!this.meta.isDoNotOpenNewFileInit()) {
                if (this.openNewFile()) {
                    this.data.OpenedNewFile = true;
                    return true;
                }
                this.logError("Couldn't open file " + this.meta.getFileName());
                this.setErrors(1L);
                this.stopAll();
            } else {
                return true;
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XMLOutputMeta)smi;
        this.data = (XMLOutputData)sdi;
        this.closeFile();
        super.dispose(smi, sdi);
    }
}

