/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.cxf.helpers.LoadingByteArrayOutputStream;
import org.apache.cxf.io.CopyingOutputStream;
import org.apache.cxf.io.Transferable;

public final class IOUtils {
    public static final Charset UTF8_CHARSET = Charset.forName("utf-8");
    public static final int DEFAULT_BUFFER_SIZE = 4096;

    private IOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEmpty(InputStream is) throws IOException {
        byte[] bytes;
        block11: {
            boolean bl;
            if (is == null) {
                return true;
            }
            try {
                if (is.available() > 0) {
                    return false;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            bytes = new byte[1];
            if (!is.markSupported()) break block11;
            is.mark(1);
            try {
                bl = IOUtils.isEof(is.read(bytes));
            }
            catch (Throwable throwable) {
                try {
                    is.reset();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            is.reset();
            return bl;
        }
        if (!(is instanceof PushbackInputStream)) {
            return false;
        }
        PushbackInputStream pbStream = (PushbackInputStream)is;
        boolean isEmpty = IOUtils.isEof(pbStream.read(bytes));
        if (!isEmpty) {
            pbStream.unread(bytes);
        }
        return isEmpty;
    }

    private static boolean isEof(int result) {
        return result == -1;
    }

    public static String newStringFromBytes(byte[] bytes, String charsetName) {
        try {
            return new String(bytes, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"" + charsetName + "\") returns invalid name.");
        }
    }

    public static String newStringFromBytes(byte[] bytes) {
        return IOUtils.newStringFromBytes(bytes, UTF8_CHARSET.name());
    }

    public static String newStringFromBytes(byte[] bytes, String charsetName, int start, int length) {
        try {
            return new String(bytes, start, length, charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"" + charsetName + "\") returns invalid name.");
        }
    }

    public static String newStringFromBytes(byte[] bytes, int start, int length) {
        return IOUtils.newStringFromBytes(bytes, UTF8_CHARSET.name(), start, length);
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        if (input == null) {
            return 0;
        }
        if (output instanceof CopyingOutputStream) {
            return ((CopyingOutputStream)((Object)output)).copyFrom(input);
        }
        return IOUtils.copy(input, output, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyAndCloseInput(InputStream input, OutputStream output) throws IOException {
        try {
            int n = IOUtils.copy(input, output);
            return n;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyAndCloseInput(InputStream input, OutputStream output, int bufferSize) throws IOException {
        try {
            int n = IOUtils.copy(input, output, bufferSize);
            return n;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndCloseInput(Reader input, Writer output) throws IOException {
        try {
            IOUtils.copy(input, output, 4096);
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAndCloseInput(Reader input, Writer output, int bufferSize) throws IOException {
        try {
            IOUtils.copy(input, output, bufferSize);
        }
        finally {
            input.close();
        }
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > 262144) {
            avail = 262144;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = 0;
        n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            if (n == 0) {
                throw new IOException("0 bytes read in violation of InputStream.read(byte[])");
            }
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        return total;
    }

    public static void copyAtLeast(InputStream input, OutputStream output, int atLeast) throws IOException {
        byte[] buffer = new byte[4096];
        int n = atLeast > buffer.length ? buffer.length : atLeast;
        n = input.read(buffer, 0, n);
        while (-1 != n) {
            if (n == 0) {
                throw new IOException("0 bytes read in violation of InputStream.read(byte[])");
            }
            output.write(buffer, 0, n);
            if ((atLeast -= n) <= 0) {
                return;
            }
            n = atLeast > buffer.length ? buffer.length : atLeast;
            n = input.read(buffer, 0, n);
        }
    }

    public static void copyAtLeast(Reader input, Writer output, int atLeast) throws IOException {
        char[] buffer = new char[4096];
        int n = atLeast > buffer.length ? buffer.length : atLeast;
        n = input.read(buffer, 0, n);
        while (-1 != n) {
            if (n == 0) {
                throw new IOException("0 bytes read in violation of Reader.read(char[])");
            }
            output.write(buffer, 0, n);
            if ((atLeast -= n) <= 0) {
                return;
            }
            n = atLeast > buffer.length ? buffer.length : atLeast;
            n = input.read(buffer, 0, n);
        }
    }

    public static void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = input.read(buffer);
        while (-1 != n) {
            output.write(buffer, 0, n);
            n = input.read(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void transferTo(InputStream inputStream, File destinationFile) throws IOException {
        if (Transferable.class.isAssignableFrom(inputStream.getClass())) {
            ((Transferable)((Object)inputStream)).transferTo(destinationFile);
        } else {
            FileOutputStream fout = new FileOutputStream(destinationFile);
            try {
                IOUtils.copyAndCloseInput(inputStream, fout);
            }
            finally {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String toString(InputStream input) throws IOException {
        return IOUtils.toString(input, 4096);
    }

    public static String toString(InputStream input, String charset) throws IOException {
        return IOUtils.toString(input, 4096, charset);
    }

    public static String toString(InputStream input, int bufferSize) throws IOException {
        return IOUtils.toString(input, bufferSize, null);
    }

    public static String toString(InputStream input, int bufferSize, String charset) throws IOException {
        int avail = input.available();
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        InputStreamReader reader = charset == null ? new InputStreamReader(input, UTF8_CHARSET) : new InputStreamReader(input, charset);
        return IOUtils.toString(reader, bufferSize);
    }

    public static String toString(Reader input) throws IOException {
        return IOUtils.toString(input, 4096);
    }

    public static String toString(Reader input, int bufSize) throws IOException {
        StringBuilder buf = new StringBuilder();
        char[] buffer = new char[bufSize];
        int n = 0;
        n = input.read(buffer);
        while (-1 != n) {
            if (n == 0) {
                throw new IOException("0 bytes read in violation of InputStream.read(byte[])");
            }
            buf.append(new String(buffer, 0, n));
            n = input.read(buffer);
        }
        input.close();
        return buf.toString();
    }

    public static String readStringFromStream(InputStream in) throws IOException {
        StringBuilder sb = new StringBuilder(1024);
        int i = in.read();
        while (i != -1) {
            sb.append((char)i);
            i = in.read();
        }
        in.close();
        return sb.toString();
    }

    public static ByteArrayInputStream loadIntoBAIS(InputStream in) throws IOException {
        int i = in.available();
        if (i < 4096) {
            i = 4096;
        }
        LoadingByteArrayOutputStream bout = new LoadingByteArrayOutputStream(i);
        IOUtils.copy(in, bout);
        in.close();
        return bout.createInputStream();
    }

    public static void consume(InputStream in) throws IOException {
        int i = in.available();
        if (i == 0) {
            int i2 = in.read();
            if (i2 == -1) {
                return;
            }
            i = in.available();
        }
        if (i < 4096) {
            i = 4096;
        }
        if (i > 65536) {
            i = 65536;
        }
        byte[] bytes = new byte[i];
        while (in.read(bytes) != -1) {
        }
    }

    public static void consume(InputStream input, int atLeast) throws IOException {
        byte[] buffer = new byte[4096];
        int n = atLeast > buffer.length ? buffer.length : atLeast;
        n = input.read(buffer, 0, n);
        while (-1 != n) {
            if (n == 0) {
                throw new IOException("0 bytes read in violation of InputStream.read(byte[])");
            }
            if ((atLeast -= n) <= 0) {
                return;
            }
            n = atLeast > buffer.length ? buffer.length : atLeast;
            n = input.read(buffer, 0, n);
        }
    }

    public static byte[] readBytesFromStream(InputStream in) throws IOException {
        int i = in.available();
        if (i < 4096) {
            i = 4096;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(i);
        IOUtils.copy(in, bos);
        in.close();
        return bos.toByteArray();
    }
}

