/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.util.List;
import java.util.Map;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.HierarchyMetaData;
import org.pentaho.agilebi.modeler.nodes.LevelMetaData;
import org.pentaho.agilebi.modeler.nodes.annotations.AnalyzerDateFormatAnnotation;
import org.pentaho.agilebi.modeler.nodes.annotations.AnalyzerDateFormatAnnotationFactory;
import org.pentaho.agilebi.modeler.propforms.LevelsPropertiesForm;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.ui.xul.stereotype.Bindable;

public class BaseColumnBackedMetaData<T extends AbstractMetaDataModelNode>
extends AbstractMetaDataModelNode<T>
implements ColumnBackedNode {
    private static final long serialVersionUID = -7342401951588541248L;
    protected String name;
    protected String columnName;
    protected boolean hidden;
    protected transient LogicalColumn logicalColumn;
    protected transient LogicalColumn logicalOrdinalColumn;
    protected transient LogicalColumn logicalCaptionColumn;
    protected boolean uniqueMembers = false;
    protected String timeLevelFormat;
    private static final String IMAGE = "images/sm_level_icon.png";
    private String description = "";
    private static final String CLASSNAME = "pentaho-smalllevelbutton";

    public BaseColumnBackedMetaData() {
        super(CLASSNAME);
    }

    public BaseColumnBackedMetaData(String name) {
        this();
        this.name = name;
        this.columnName = name;
    }

    @Override
    public String getValidImage() {
        return IMAGE;
    }

    @Override
    @Bindable
    public String getName() {
        return this.name;
    }

    @Override
    public IPhysicalTable getTableRestriction() {
        return null;
    }

    @Bindable
    public String getDisplayName() {
        return this.getName();
    }

    @Bindable
    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChange("name", oldName, name);
            this.firePropertyChange("displayName", oldName, name);
            this.validateNode();
        }
    }

    @Bindable
    public String getDescription() {
        if (this.getLogicalColumn() != null && !this.description.equals(this.getLogicalColumn().getId())) {
            return this.description;
        }
        return "";
    }

    @Bindable
    public void setDescription(String description) {
        if (!description.equals(this.description)) {
            String oldDesc = this.description;
            this.description = description;
            this.firePropertyChange("description", oldDesc, description);
            this.validateNode();
        }
    }

    @Bindable
    public String getColumnName() {
        return this.columnName;
    }

    @Bindable
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    @Bindable
    public LogicalColumn getLogicalColumn() {
        return this.logicalColumn;
    }

    @Override
    public void setLogicalColumn(LogicalColumn col) {
        LogicalColumn prevVal = this.logicalColumn;
        this.logicalColumn = col;
        this.validateNode();
        this.firePropertyChange("logicalColumn", prevVal, col);
    }

    @Override
    @Bindable
    public LogicalColumn getLogicalOrdinalColumn() {
        return this.logicalOrdinalColumn;
    }

    @Override
    public void setLogicalOrdinalColumn(LogicalColumn col) {
        LogicalColumn prevVal = this.logicalOrdinalColumn;
        this.logicalOrdinalColumn = col;
        this.validateNode();
        this.firePropertyChange("logicalOrdinalColumn", prevVal, col);
    }

    @Override
    @Bindable
    public LogicalColumn getLogicalCaptionColumn() {
        return this.logicalCaptionColumn;
    }

    @Override
    @Bindable
    public void setLogicalCaptionColumn(LogicalColumn col) {
        LogicalColumn prevVal = this.logicalCaptionColumn;
        this.logicalCaptionColumn = col;
        this.validateNode();
        this.firePropertyChange("logicalCaptionColumn", prevVal, col);
    }

    @Bindable
    public void setUniqueMembers(boolean uniqueMembers) {
        boolean oldUniqueMembers = this.uniqueMembers;
        if (oldUniqueMembers == uniqueMembers) {
            return;
        }
        this.uniqueMembers = uniqueMembers;
        this.firePropertyChange("uniqueMembers", oldUniqueMembers, uniqueMembers);
    }

    @Bindable
    public boolean isUniqueMembers() {
        return this.uniqueMembers;
    }

    public String getFullTimeLevelFormat() {
        String format = null;
        HierarchyMetaData hierarchyMetaData = (HierarchyMetaData)this.getParent();
        List<LevelMetaData> levels = hierarchyMetaData.getLevels();
        for (LevelMetaData ancestorOrSelf : levels) {
            format = (format == null ? "" : format + ".") + AnalyzerDateFormatAnnotation.quoteTimeLevelFormat(ancestorOrSelf.getTimeLevelFormat());
            if (ancestorOrSelf != this) continue;
            break;
        }
        return format;
    }

    public void updateDescendantAnalyzerDateFormatAnnotations() {
        HierarchyMetaData hierarchyMetaData = (HierarchyMetaData)this.getParent();
        List<LevelMetaData> levels = hierarchyMetaData.getLevels();
        String format = null;
        String key = "AnalyzerDateFormat";
        boolean isDescendant = false;
        for (LevelMetaData descendant : levels) {
            String timeLevelFormat = descendant.getTimeLevelFormat();
            format = (format == null ? "" : format + ".") + AnalyzerDateFormatAnnotation.quoteTimeLevelFormat(timeLevelFormat);
            if (!isDescendant) {
                if (descendant != this) continue;
                isDescendant = true;
                continue;
            }
            Map annotations = descendant.annotations;
            if (!annotations.containsKey(key)) continue;
            AnalyzerDateFormatAnnotation annotation = (AnalyzerDateFormatAnnotation)annotations.get(key);
            annotation.setValue(format);
        }
    }

    @Bindable
    public String getTimeLevelFormat() {
        return this.timeLevelFormat;
    }

    @Bindable
    public void setTimeLevelFormat(String timeLevelFormat) {
        if ("".equals(timeLevelFormat)) {
            timeLevelFormat = null;
        }
        String oldTimeLevelFormat = this.timeLevelFormat;
        if (timeLevelFormat == null && oldTimeLevelFormat == null) {
            return;
        }
        if (timeLevelFormat != null && oldTimeLevelFormat != null && timeLevelFormat.equals(oldTimeLevelFormat)) {
            return;
        }
        this.timeLevelFormat = timeLevelFormat;
        String key = "AnalyzerDateFormat";
        AnalyzerDateFormatAnnotation annotation = (AnalyzerDateFormatAnnotation)this.annotations.get(key);
        if (annotation == null && timeLevelFormat == null) {
            return;
        }
        if (annotation == null && timeLevelFormat != null) {
            annotation = (AnalyzerDateFormatAnnotation)AnalyzerDateFormatAnnotationFactory.instance.create((LevelMetaData)this);
            annotation.setValue(timeLevelFormat);
            this.annotations.put(key, annotation);
        } else if (annotation != null && timeLevelFormat == null) {
            this.annotations.remove(key);
            annotation = null;
        } else {
            String newAnalyzerDateFormatValue = this.getFullTimeLevelFormat();
            if (annotation.getValue().equals(newAnalyzerDateFormatValue)) {
                return;
            }
            annotation.setValue(newAnalyzerDateFormatValue);
        }
        this.updateDescendantAnalyzerDateFormatAnnotations();
        this.firePropertyChange("timeLevelFormat", oldTimeLevelFormat, timeLevelFormat);
        this.validateNode();
    }

    public void updateTimeLevelFormat(AnalyzerDateFormatAnnotation annotation) {
        this.timeLevelFormat = annotation.getTimeLevelFormat();
    }

    @Override
    public void validate() {
        this.valid = true;
        this.validationMessages.clear();
        if (this.name == null || "".equals(this.name)) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString(this.getValidationMessageKey("MISSING_NAME"), new String[0]));
            this.valid = false;
        }
        if (this.logicalColumn == null) {
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString(this.getValidationMessageKey("MISSING_BACKING_COLUMN"), this.getName()));
            this.valid = false;
        } else {
            LogicalTable logicalTable = this.logicalColumn.getLogicalTable();
            if (this.logicalOrdinalColumn != null && !this.logicalOrdinalColumn.getLogicalTable().equals((Object)logicalTable)) {
                this.validationMessages.add(ModelerMessagesHolder.getMessages().getString(this.getValidationMessageKey("INVALID_TABLE_FOR_ORDINAL_COLUMN"), this.getName()));
            }
            if (this.logicalCaptionColumn != null && !this.logicalCaptionColumn.getLogicalTable().equals((Object)logicalTable)) {
                this.validationMessages.add(ModelerMessagesHolder.getMessages().getString(this.getValidationMessageKey("INVALID_TABLE_FOR_CAPTION_COLUMN"), this.getName()));
            }
        }
    }

    @Override
    public Class<? extends ModelerNodePropertiesForm> getPropertiesForm() {
        return LevelsPropertiesForm.class;
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Bindable
    public boolean isEditingDisabled() {
        return false;
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        return false;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        return null;
    }

    public String getValidationMessageKey(String key) {
        return "validation.measure." + key;
    }
}

