/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.models.annotations.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.pentaho.agilebi.modeler.models.annotations.data.NameValueProperty;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.metastore.DatabaseMetaStoreUtil;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;

@MetaStoreElementType(name="DataProviderConnection", description="DataProviderConnection")
public class DataProviderConnection
implements Serializable {
    @MetaStoreAttribute
    private String name;
    @MetaStoreAttribute
    private String displayName;
    @MetaStoreAttribute
    private String hostname;
    @MetaStoreAttribute
    private String databaseName;
    @MetaStoreAttribute
    private String username;
    @MetaStoreAttribute
    private String password;
    @MetaStoreAttribute
    private boolean changed;
    @MetaStoreAttribute
    private List<NameValueProperty> attributeList = new ArrayList<NameValueProperty>();
    @Deprecated
    private Properties attributes;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Deprecated
    public Properties getAttributes() {
        return this.attributes;
    }

    @Deprecated
    public void setAttributes(Properties attributes) {
        this.attributes = attributes;
    }

    public List<NameValueProperty> getAttributeList() {
        return this.attributeList;
    }

    public void setAttributeList(List<NameValueProperty> attributeList) {
        this.attributeList = attributeList;
    }

    public DatabaseMeta createDatabaseMeta() {
        try {
            DatabaseMeta databaseMeta = new DatabaseMeta();
            BeanUtils.copyProperties((Object)databaseMeta, (Object)this);
            if (this.getAttributeList() != null && !this.getAttributeList().isEmpty()) {
                Properties properties = new Properties();
                for (NameValueProperty nameValueProperty : this.getAttributeList()) {
                    properties.setProperty(nameValueProperty.getName(), nameValueProperty.getValue());
                }
                databaseMeta.setAttributes(properties);
            }
            return databaseMeta;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void populateFrom(DatabaseMeta databaseMeta) {
        try {
            BeanUtils.copyProperties((Object)this, (Object)databaseMeta);
            if (this.getAttributes() != null) {
                if (this.getAttributeList() == null) {
                    this.setAttributeList(new ArrayList<NameValueProperty>());
                } else {
                    this.getAttributeList().clear();
                }
                Enumeration<?> e = this.getAttributes().propertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    this.getAttributeList().add(new NameValueProperty(key, this.getAttributes().getProperty(key)));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void persistDatabaseMeta(IMetaStore metaStore, DatabaseMeta databaseMeta) {
        if (metaStore == null) {
            return;
        }
        try {
            DatabaseMetaStoreUtil.createDatabaseElement((IMetaStore)metaStore, (DatabaseMeta)databaseMeta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DatabaseMeta load(IMetaStore metaStore) {
        try {
            if (metaStore == null) {
                return null;
            }
            List databaseMetaList = DatabaseMetaStoreUtil.getDatabaseElements((IMetaStore)metaStore);
            for (DatabaseMeta databaseMeta : databaseMetaList) {
                if (databaseMeta.getName() == null || !StringUtils.isNotBlank((String)databaseMeta.getName()) || !StringUtils.equals((String)databaseMeta.getName(), (String)this.getName())) continue;
                this.populateFrom(databaseMeta);
                return databaseMeta;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean equals(Object obj) {
        try {
            if (!EqualsBuilder.reflectionEquals((Object)this, (Object)obj)) {
                return false;
            }
            DataProviderConnection toCompare = (DataProviderConnection)obj;
            List<NameValueProperty> thisAttributeList = this.getAttributeList();
            List<NameValueProperty> toCompareAttributeList = toCompare.getAttributeList();
            if (thisAttributeList != null && toCompareAttributeList != null) {
                if (thisAttributeList.size() != toCompareAttributeList.size()) {
                    return false;
                }
                for (int i = 0; i < thisAttributeList.size(); ++i) {
                    if (thisAttributeList.get(i).equals(toCompareAttributeList.get(i))) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

