/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.js.require;

import com.github.zafarkhaja.semver.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RequireJsDependencyResolver {
    private Map<String, Object> requireConfig;
    final HashMap<String, ModuleRequirements> requirements;
    HashMap<String, HashMap<String, HashMap<String, ?>>> availableModules;

    public static void processMetaInformation(Map<String, Object> result) {
        if (!result.containsKey("requirejs-osgi-meta")) {
            return;
        }
        RequireJsDependencyResolver resolver = new RequireJsDependencyResolver(result);
        resolver.run();
        result.remove("requirejs-osgi-meta");
    }

    private RequireJsDependencyResolver(Map<String, Object> requireConfig) {
        this.requireConfig = requireConfig;
        this.requirements = new HashMap();
    }

    private void run() {
        HashMap meta = (HashMap)this.requireConfig.get("requirejs-osgi-meta");
        this.availableModules = meta.containsKey("modules") ? (HashMap)meta.get("modules") : new HashMap();
        HashMap artifacts = meta.containsKey("artifacts") ? (HashMap)meta.get("artifacts") : new HashMap();
        for (String module : this.availableModules.keySet()) {
            HashMap<String, HashMap<String, ?>> moduleInfo = this.availableModules.get(module);
            for (String version : moduleInfo.keySet()) {
                HashMap<String, ?> versionInfo = moduleInfo.get(version);
                if (!versionInfo.containsKey("dependencies")) continue;
                HashMap dependencies = (HashMap)versionInfo.get("dependencies");
                HashMap<String, String> processedDependencies = new HashMap<String, String>();
                for (String dependencyId : dependencies.keySet()) {
                    String versionRequirement = (String)dependencies.get(dependencyId);
                    if (dependencyId.startsWith("mvn:")) {
                        String dependencyArtifact = dependencyId.substring(4);
                        if (!artifacts.containsKey(dependencyArtifact)) continue;
                        HashMap artifactInfo = (HashMap)artifacts.get(dependencyArtifact);
                        Iterator resolvedArtifacts = this.resolveVersion(versionRequirement, artifactInfo.keySet());
                        Iterator<String> iterator = ((ArrayList)((Object)resolvedArtifacts)).iterator();
                        while (iterator.hasNext()) {
                            String artifactVersion = iterator.next();
                            HashMap dependencyModules = (HashMap)artifactInfo.get(artifactVersion);
                            for (String dependencyModuleId : dependencyModules.keySet()) {
                                String dependencyVersionRequirement = (String)dependencyModules.get(dependencyModuleId);
                                if (processedDependencies.containsKey(dependencyModuleId)) {
                                    dependencyVersionRequirement = dependencyVersionRequirement + " | " + (String)processedDependencies.get(dependencyModuleId);
                                }
                                this.processModuleRequirement(dependencyModuleId, dependencyVersionRequirement);
                                processedDependencies.put(dependencyModuleId, dependencyVersionRequirement);
                            }
                        }
                        continue;
                    }
                    this.processModuleRequirement(dependencyId, versionRequirement);
                    processedDependencies.put(dependencyId, versionRequirement);
                }
                versionInfo.put("processed", processedDependencies);
            }
        }
        for (String moduleId : this.requirements.keySet()) {
            ModuleRequirements moduleRequirement = this.requirements.get(moduleId);
            moduleRequirement.resolve();
        }
        Map map = !this.requireConfig.containsKey("map") ? new HashMap() : (Map)this.requireConfig.get("map");
        for (String module : this.availableModules.keySet()) {
            HashMap<String, HashMap<String, ?>> moduleInfo = this.availableModules.get(module);
            for (String version : moduleInfo.keySet()) {
                HashMap<String, ?> versionInfo = moduleInfo.get(version);
                boolean isAmdModule = versionInfo.containsKey("isAmdPackage") && (Boolean)versionInfo.get("isAmdPackage") != false;
                String exports = null;
                if (!isAmdModule && versionInfo.containsKey("exports")) {
                    exports = (String)versionInfo.get("exports");
                }
                LinkedHashSet<String> moduleShimDependencies = new LinkedHashSet<String>();
                if (versionInfo.containsKey("processed")) {
                    HashMap processedDependencies = (HashMap)versionInfo.get("processed");
                    HashMap<String, String> resolved = new HashMap<String, String>();
                    HashMap moduleMap = !map.containsKey(module + "_" + version) ? new HashMap() : (HashMap)map.get(module + "_" + version);
                    for (String dependencyModuleId : processedDependencies.keySet()) {
                        HashMap<String, ?> dependencyInfo;
                        boolean dependencyIsAmdModule;
                        String dependencyModuleVersion = (String)processedDependencies.get(dependencyModuleId);
                        String dependencyResolvedVersion = this.requirements.get(dependencyModuleId).getResolution(dependencyModuleVersion);
                        if (dependencyResolvedVersion == null) continue;
                        resolved.put(dependencyModuleId, dependencyResolvedVersion);
                        moduleMap.put(dependencyModuleId, dependencyModuleId + "_" + dependencyResolvedVersion);
                        if (isAmdModule || (dependencyIsAmdModule = (dependencyInfo = this.availableModules.get(dependencyModuleId).get(dependencyResolvedVersion)).containsKey("isAmdPackage") && (Boolean)dependencyInfo.get("isAmdPackage") != false)) continue;
                        moduleShimDependencies.add(dependencyModuleId + "_" + dependencyResolvedVersion);
                    }
                    if (!resolved.isEmpty()) {
                        versionInfo.put("resolved", resolved);
                        map.put(module + "_" + version, moduleMap);
                    }
                }
                if (isAmdModule) continue;
                HashMap shim = !this.requireConfig.containsKey("shim") ? new HashMap() : (HashMap)this.requireConfig.get("shim");
                HashMap<String, Object> moduleShim = new HashMap<String, Object>();
                if (shim.containsKey(module + "_" + version)) {
                    Object originalShim = shim.get(module + "_" + version);
                    if (originalShim instanceof List) {
                        moduleShimDependencies.addAll((List)originalShim);
                    } else if (originalShim instanceof Map && ((Map)originalShim).containsKey("deps")) {
                        moduleShimDependencies.addAll((List)((Map)originalShim).get("deps"));
                    }
                }
                if (!moduleShimDependencies.isEmpty()) {
                    moduleShim.put("deps", new ArrayList(moduleShimDependencies));
                }
                if (exports != null && !moduleShim.containsKey("exports")) {
                    moduleShim.put("exports", exports);
                }
                shim.put(module + "_" + version, moduleShim);
                List packages = (List)versionInfo.get("packages");
                if (packages != null) {
                    for (Object pck : packages) {
                        String mainScript;
                        String pckId;
                        if (pck instanceof Map) {
                            pckId = (String)((Map)pck).get("name");
                            mainScript = (String)((Map)pck).get("main");
                        } else {
                            pckId = (String)pck;
                            mainScript = "main";
                        }
                        String convertedName = !pckId.isEmpty() ? module + "_" + version + "/" + pckId : module + "_" + version;
                        shim.put(convertedName + "/" + mainScript, moduleShim);
                    }
                }
                if (shim.isEmpty()) continue;
                this.requireConfig.put("shim", shim);
            }
        }
        for (String artifact : artifacts.keySet()) {
            HashMap artifactInfo = (HashMap)artifacts.get(artifact);
            for (String artifactVersion : artifactInfo.keySet()) {
                HashMap modules = (HashMap)artifactInfo.get(artifactVersion);
                Set moduleIds = modules.keySet();
                for (String moduleId : moduleIds) {
                    HashMap moduleMap;
                    String version = (String)modules.get(moduleId);
                    if (!map.containsKey(moduleId + "_" + version)) {
                        moduleMap = new HashMap();
                        map.put(moduleId + "_" + version, moduleMap);
                    } else {
                        moduleMap = (HashMap)map.get(moduleId + "_" + version);
                    }
                    for (String simblingModuleId : moduleIds) {
                        String simblingVersion = (String)modules.get(simblingModuleId);
                        if (moduleMap.containsKey(simblingModuleId)) continue;
                        moduleMap.put(simblingModuleId, simblingModuleId + "_" + simblingVersion);
                    }
                }
            }
        }
        if (!map.isEmpty()) {
            this.requireConfig.put("map", map);
        }
    }

    private void processModuleRequirement(String moduleId, String moduleVersionRequeriment) {
        ModuleRequirements moduleRequirements;
        if (!this.requirements.containsKey(moduleId)) {
            moduleRequirements = new ModuleRequirements();
            this.requirements.put(moduleId, moduleRequirements);
        } else {
            moduleRequirements = this.requirements.get(moduleId);
        }
        if (!moduleRequirements.groups.containsKey(moduleVersionRequeriment) && this.availableModules.containsKey(moduleId)) {
            ArrayList<String> resolvedVersions = this.resolveVersion(moduleVersionRequeriment, this.availableModules.get(moduleId).keySet());
            GroupDetail g = new GroupDetail(resolvedVersions);
            moduleRequirements.groups.put(moduleVersionRequeriment, g);
            for (String resolvedVersionId : resolvedVersions) {
                VersionDetail resolvedVersion;
                if (!moduleRequirements.versions.containsKey(resolvedVersionId)) {
                    resolvedVersion = new VersionDetail(resolvedVersionId);
                    moduleRequirements.versions.put(resolvedVersionId, resolvedVersion);
                } else {
                    resolvedVersion = moduleRequirements.versions.get(resolvedVersionId);
                }
                resolvedVersion.addGroup(g);
            }
        }
    }

    private ArrayList<String> resolveVersion(String versionFilter, Set<String> availableVersions) {
        ArrayList<Version> validVersions = new ArrayList<Version>();
        ArrayList<String> validVersionsStrings = new ArrayList<String>();
        if (availableVersions.contains(versionFilter)) {
            validVersionsStrings.add(versionFilter);
            return validVersionsStrings;
        }
        for (String availableVersion : availableVersions) {
            try {
                Version parsedAvailableVersion = Version.valueOf((String)availableVersion);
                if (!this.versionSatisfiesFilter(parsedAvailableVersion, versionFilter)) continue;
                validVersions.add(parsedAvailableVersion);
            }
            catch (Exception exception) {}
        }
        if (validVersions.isEmpty()) {
            try {
                Version.valueOf((String)versionFilter);
                return this.resolveVersion("^" + versionFilter, availableVersions);
            }
            catch (Exception exception) {}
        } else {
            Collections.sort(validVersions, new Comparator<Version>(){

                @Override
                public int compare(Version v1, Version v2) {
                    return v1.compareTo(v2);
                }
            });
            for (Version v : validVersions) {
                validVersionsStrings.add(v.toString());
            }
        }
        return validVersionsStrings;
    }

    private boolean versionSatisfiesFilter(Version parsedAvailableVersion, String versionFilter) {
        return versionFilter.equals(parsedAvailableVersion.toString()) || parsedAvailableVersion.satisfies(versionFilter);
    }

    private class GroupDetail {
        private final ArrayList<String> versions;
        private final ArrayList<String> excluded;

        GroupDetail(ArrayList<String> resolvedVersions) {
            this.versions = resolvedVersions;
            this.excluded = new ArrayList();
        }

        int getVersionsCount() {
            return this.versions.size();
        }

        ArrayList<String> getVersions() {
            return this.versions;
        }

        void exclude(String version) {
            if (this.versions.size() - 1 > this.excluded.size()) {
                this.excluded.add(version);
            }
        }

        String getResolvedVersion() {
            for (String v : this.versions) {
                if (this.excluded.contains(v)) continue;
                return v;
            }
            return null;
        }
    }

    private class VersionDetail
    implements Comparable<VersionDetail> {
        private final String version;
        private final HashSet<GroupDetail> groups;

        VersionDetail(String version) {
            this.version = version;
            this.groups = new HashSet();
        }

        @Override
        public int compareTo(VersionDetail v) {
            int totalVersions1;
            int uniqueVersions1;
            int groupsCount1;
            int groupsCount = this.getGroupsCount();
            if (groupsCount != (groupsCount1 = v.getGroupsCount())) {
                return groupsCount > groupsCount1 ? -1 : 1;
            }
            int uniqueVersions = this.getUniqueVersionsCount();
            if (uniqueVersions != (uniqueVersions1 = v.getUniqueVersionsCount())) {
                return uniqueVersions > uniqueVersions1 ? -1 : 1;
            }
            int totalVersions = this.getVersionsCount();
            if (totalVersions != (totalVersions1 = v.getVersionsCount())) {
                return totalVersions > totalVersions1 ? -1 : 1;
            }
            return 0;
        }

        String getVersion() {
            return this.version;
        }

        int getGroupsCount() {
            return this.groups.size();
        }

        int getUniqueVersionsCount() {
            HashSet<String> uniqueVersions = new HashSet<String>();
            for (GroupDetail g : this.groups) {
                uniqueVersions.addAll(g.getVersions());
            }
            return uniqueVersions.size();
        }

        int getVersionsCount() {
            int count = 0;
            for (GroupDetail g : this.groups) {
                count += g.getVersionsCount();
            }
            return count;
        }

        public void excludeYourself() {
            for (GroupDetail g : this.groups) {
                g.exclude(this.version);
            }
        }

        public void addGroup(GroupDetail g) {
            this.groups.add(g);
        }
    }

    private class ModuleRequirements {
        HashMap<String, GroupDetail> groups = new HashMap();
        HashMap<String, VersionDetail> versions = new HashMap();

        ModuleRequirements() {
        }

        public void resolve() {
            ArrayList<VersionDetail> sortedVersions = new ArrayList<VersionDetail>(this.versions.values());
            Collections.sort(sortedVersions);
            for (VersionDetail version : sortedVersions) {
                version.excludeYourself();
            }
        }

        public String getResolution(String versionRequirement) {
            if (this.groups.containsKey(versionRequirement)) {
                return this.groups.get(versionRequirement).getResolvedVersion();
            }
            return null;
        }
    }
}

