/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.js.require;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.json.simple.parser.JSONParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;
import org.pentaho.js.require.RebuildCacheCallable;
import org.pentaho.js.require.RequireJsBundleListener;
import org.pentaho.js.require.RequireJsConfiguration;
import org.pentaho.js.require.RequireJsGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequireJsConfigManager {
    static final String CAPABILITY_NAMESPACE = "org.pentaho.webpackage";
    static final String PACKAGE_JSON_PATH = "META-INF/js/package.json";
    static final String REQUIRE_JSON_PATH = "META-INF/js/require.json";
    static final String EXTERNAL_RESOURCES_JSON_PATH = "META-INF/js/externalResources.json";
    static final String STATIC_RESOURCES_JSON_PATH = "META-INF/js/staticResources.json";
    private static Logger logger = LoggerFactory.getLogger(RequireJsConfigManager.class);
    private static final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(2, r -> {
        Thread thread = Executors.defaultThreadFactory().newThread(r);
        thread.setDaemon(true);
        thread.setName("RequireJSConfigManager pool");
        return thread;
    });
    private final ConcurrentHashMap<Long, List<Map<String, Object>>> configMap = new ConcurrentHashMap();
    private final Map<Long, RequireJsConfiguration> requireConfigMap = new HashMap<Long, RequireJsConfiguration>();
    private final JSONParser parser = new JSONParser();
    private BundleContext bundleContext;
    private volatile ConcurrentHashMap<String, Future<String>> cachedConfigurations;
    private volatile long lastModified = System.currentTimeMillis();
    private RequireJsBundleListener bundleListener;

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() throws Exception {
        if (this.bundleListener != null) {
            throw new Exception("Already initialized.");
        }
        this.cachedConfigurations = new ConcurrentHashMap(3);
        this.bundleListener = new RequireJsBundleListener(this);
        this.bundleContext.addBundleListener((BundleListener)this.bundleListener);
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.updateBundleContext(bundle);
        }
        this.updateBundleContext(this.bundleContext.getBundle());
    }

    public void destroy() {
        this.invalidateCachedConfigurations();
        if (this.bundleListener != null) {
            this.bundleContext.removeBundleListener((BundleListener)this.bundleListener);
        }
        this.bundleListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(Bundle bundle) {
        boolean shouldRefresh = true;
        try {
            shouldRefresh = this.updateBundleContext(bundle);
        }
        catch (Exception exception) {
        }
        finally {
            if (shouldRefresh) {
                this.invalidateCachedConfigurations();
            }
        }
    }

    public String getRequireJsConfig(String baseUrl) {
        String result = null;
        int tries = 3;
        Throwable lastException = null;
        while (tries-- > 0 && result == null) {
            Future<String> cache = this.getCachedConfiguration(baseUrl);
            try {
                result = cache.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                lastException = e;
                this.invalidateCachedConfigurations();
            }
        }
        if (result == null) {
            result = "{}; // Error computing RequireJS Config: ";
            result = lastException != null && lastException.getCause() != null ? result + lastException.getCause().getMessage() : result + "unknown error";
        }
        return result;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    private boolean updateBundleContext(Bundle bundle) {
        switch (bundle.getState()) {
            case 1: 
            case 2: 
            case 4: 
            case 16: {
                return this.updateBundleContextStopped(bundle);
            }
            case 32: {
                return this.updateBundleContextActivated(bundle);
            }
        }
        return true;
    }

    private boolean updateBundleContextStopped(Bundle bundle) {
        List<Map<String, Object>> bundleConfig = this.configMap.remove(bundle.getBundleId());
        RequireJsConfiguration requireJsConfiguration = this.requireConfigMap.remove(bundle.getBundleId());
        return bundleConfig != null || requireJsConfiguration != null;
    }

    private boolean updateBundleContextActivated(Bundle bundle) {
        boolean shouldInvalidate = this.updateBundleContextStopped(bundle);
        URL packageJsonUrl = bundle.getResource(PACKAGE_JSON_PATH);
        URL configFileUrl = bundle.getResource(REQUIRE_JSON_PATH);
        URL externalResourcesUrl = bundle.getResource(EXTERNAL_RESOURCES_JSON_PATH);
        URL staticResourcesUrl = bundle.getResource(STATIC_RESOURCES_JSON_PATH);
        if (configFileUrl != null) {
            Map<String, Object> requireJsonObject = this.loadJsonObject(configFileUrl);
            if (requireJsonObject != null) {
                this.putInConfigMap(bundle.getBundleId(), requireJsonObject);
                shouldInvalidate = true;
            }
        } else if (packageJsonUrl != null) {
            boolean didParsePackageJson = this.parsePackageInformation(bundle, packageJsonUrl);
            shouldInvalidate = shouldInvalidate || didParsePackageJson;
        } else {
            boolean foundPentahoWebPackageCapability = this.processBundleCapabilities(bundle);
            boolean bl = shouldInvalidate = shouldInvalidate || foundPentahoWebPackageCapability;
        }
        if (externalResourcesUrl != null) {
            ArrayList<String> requireJsList;
            Map<String, Object> externalResourceJsonObject = this.loadJsonObject(externalResourcesUrl);
            Map<String, Object> staticResourceJsonObject = this.loadJsonObject(staticResourcesUrl);
            if (externalResourceJsonObject != null && (requireJsList = (ArrayList<String>)externalResourceJsonObject.get("requirejs")) != null) {
                if (staticResourceJsonObject != null) {
                    ArrayList<String> translatedList = new ArrayList<String>(requireJsList.size());
                    for (String element : requireJsList) {
                        boolean found = false;
                        for (String key : staticResourceJsonObject.keySet()) {
                            String strKey = key.toString();
                            if (!element.startsWith(strKey)) continue;
                            String value = staticResourceJsonObject.get(key).toString();
                            translatedList.add(value + element.substring(strKey.length()));
                            found = true;
                            break;
                        }
                        if (found) continue;
                        translatedList.add(element);
                    }
                    requireJsList = translatedList;
                }
                this.putInRequireConfigMap(bundle.getBundleId(), new RequireJsConfiguration(bundle, (List<String>)requireJsList));
                shouldInvalidate = true;
            }
        }
        return shouldInvalidate;
    }

    private boolean processBundleCapabilities(Bundle bundle) {
        List capabilities;
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        boolean foundPentahoWebPackageCapability = false;
        if (wiring != null && (capabilities = wiring.getCapabilities(CAPABILITY_NAMESPACE)) != null) {
            for (BundleCapability bundleCapability : capabilities) {
                Map attributes = bundleCapability.getAttributes();
                String root = attributes.getOrDefault("root", "");
                while (root.endsWith("/")) {
                    root = root.substring(0, root.length() - 1);
                }
                try {
                    URL capabilityPackageJsonUrl = bundle.getResource(root + "/package.json");
                    if (capabilityPackageJsonUrl != null) {
                        boolean didParsePackageJson = this.parsePackageInformation(bundle, capabilityPackageJsonUrl);
                        foundPentahoWebPackageCapability = foundPentahoWebPackageCapability || didParsePackageJson;
                        continue;
                    }
                    logger.warn(bundle.getSymbolicName() + " [" + bundle.getBundleId() + "]: " + root + "/package.json not found.");
                }
                catch (RuntimeException ignored) {
                    logger.error(bundle.getSymbolicName() + " [" + bundle.getBundleId() + "]: Error parsing " + root + "/package.json.");
                }
            }
        }
        return foundPentahoWebPackageCapability;
    }

    private boolean parsePackageInformation(Bundle bundle, URL resourceUrl) {
        try {
            URLConnection urlConnection = resourceUrl.openConnection();
            RequireJsGenerator gen = RequireJsGenerator.parseJsonPackage(urlConnection.getInputStream());
            if (gen != null) {
                RequireJsGenerator.ArtifactInfo artifactInfo = new RequireJsGenerator.ArtifactInfo("osgi-bundles", bundle.getSymbolicName(), bundle.getVersion().toString());
                RequireJsGenerator.ModuleInfo moduleInfo = gen.getConvertedConfig(artifactInfo);
                Map<String, Object> requireJsonObject = moduleInfo.getRequireJs();
                this.putInConfigMap(bundle.getBundleId(), requireJsonObject);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void putInConfigMap(long bundleId, Map<String, Object> config) {
        List bundleConfigurations = this.configMap.computeIfAbsent(bundleId, key -> new ArrayList());
        bundleConfigurations.add(config);
    }

    private void putInRequireConfigMap(long bundleId, RequireJsConfiguration config) {
        this.requireConfigMap.put(bundleId, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> loadJsonObject(URL url) {
        if (url == null) {
            return null;
        }
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            URLConnection urlConnection = url.openConnection();
            inputStream = urlConnection.getInputStream();
            inputStreamReader = new InputStreamReader(urlConnection.getInputStream());
            bufferedReader = new BufferedReader(inputStreamReader);
            Map map = (Map)this.parser.parse((Reader)bufferedReader);
            return map;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    Future<String> getCachedConfiguration(String baseUrl) {
        return this.cachedConfigurations.computeIfAbsent(baseUrl, k -> {
            this.lastModified = System.currentTimeMillis();
            ArrayList<Map<String, Object>> configurations = new ArrayList<Map<String, Object>>();
            this.configMap.values().forEach(configurations::addAll);
            return executorService.schedule(new RebuildCacheCallable(baseUrl, configurations, new ArrayList<RequireJsConfiguration>(this.requireConfigMap.values())), 250L, TimeUnit.MILLISECONDS);
        });
    }

    void invalidateCachedConfigurations() {
        this.lastModified = System.currentTimeMillis();
        this.cachedConfigurations.forEach((s, stringFuture) -> stringFuture.cancel(true));
        this.cachedConfigurations.clear();
    }
}

