/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import org.apache.cxf.ws.rm.MessageCallback;

public class MessageCountingCallback
implements MessageCallback {
    private Object lock = new Object();
    private volatile int countOutstanding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageAccepted(String seqId, long msgNum) {
        Object object = this.lock;
        synchronized (object) {
            ++this.countOutstanding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageAcknowledged(String seqId, long msgNum) {
        Object object = this.lock;
        synchronized (object) {
            --this.countOutstanding;
            if (this.countOutstanding == 0) {
                this.lock.notifyAll();
            }
        }
    }

    public int getCountOutstanding() {
        return this.countOutstanding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean waitComplete(long timeout) {
        long start = System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while (this.countOutstanding > 0) {
                long remain = 0L;
                if (timeout != 0L && (remain = start + timeout - System.currentTimeMillis()) <= 0L) {
                    return false;
                }
                try {
                    this.lock.wait(remain);
                }
                catch (InterruptedException e) {
                }
            }
            return true;
        }
    }
}

