/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.util;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.Arrays;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.style.BorderStyle;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class StrokeUtility {
    public static final int STROKE_SOLID = 0;
    public static final int STROKE_DASHED = 1;
    public static final int STROKE_DOTTED = 2;
    public static final int STROKE_DOT_DASH = 3;
    public static final int STROKE_DOT_DOT_DASH = 4;
    public static final int STROKE_NONE = 5;

    private StrokeUtility() {
    }

    public static Stroke createStroke(int type, float width) {
        Configuration repoConf = ClassicEngineBoot.getInstance().getGlobalConfig();
        boolean useWidthForStrokes = "true".equals(repoConf.getConfigProperty("org.pentaho.reporting.engine.classic.core.DynamicStrokeDashes"));
        float effectiveWidth = useWidthForStrokes ? width : 1.0f;
        switch (type) {
            case 1: {
                return new BasicStroke(width, 2, 0, 10.0f, new float[]{6.0f * effectiveWidth, 6.0f * effectiveWidth}, 0.0f);
            }
            case 2: {
                return new BasicStroke(width, 2, 0, 5.0f, new float[]{0.0f, 2.0f * effectiveWidth}, 0.0f);
            }
            case 3: {
                return new BasicStroke(width, 2, 0, 10.0f, new float[]{0.0f, 2.0f * effectiveWidth, 6.0f * effectiveWidth, 2.0f * effectiveWidth}, 0.0f);
            }
            case 4: {
                return new BasicStroke(width, 2, 0, 10.0f, new float[]{0.0f, 2.0f * effectiveWidth, 0.0f, 2.0f * effectiveWidth, 6.0f * effectiveWidth, 2.0f * effectiveWidth}, 0.0f);
            }
        }
        return new BasicStroke(width);
    }

    public static float getStrokeWidth(Stroke s) {
        if (s instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)s;
            return bs.getLineWidth();
        }
        return 1.0f;
    }

    public static int getStrokeType(Stroke s) {
        if (!(s instanceof BasicStroke)) {
            return 0;
        }
        BasicStroke bs = (BasicStroke)s;
        if (bs.getLineWidth() <= 0.0f) {
            return 5;
        }
        float[] dashes = bs.getDashArray();
        if (dashes == null) {
            return 0;
        }
        if (dashes.length < 2) {
            return 0;
        }
        if (dashes.length == 3 || dashes.length == 5) {
            return 0;
        }
        if (dashes.length == 2) {
            float factor = dashes[0] / dashes[1];
            if ((double)factor > 0.9 && (double)factor < 1.1) {
                return 1;
            }
            if ((double)factor < 0.1) {
                return 2;
            }
            return 0;
        }
        if (dashes.length == 4) {
            float[] copyDashes = (float[])dashes.clone();
            Arrays.sort(copyDashes);
            if ((double)Math.abs(copyDashes[0] / bs.getLineWidth()) > 0.5) {
                return 0;
            }
            float factor1 = 2.0f * bs.getLineWidth() / copyDashes[1];
            float factor2 = 2.0f * bs.getLineWidth() / copyDashes[2];
            float factorBig = 2.0f * bs.getLineWidth() / copyDashes[3];
            if ((double)factor1 < 0.9 || (double)factor1 > 1.1 || (double)factor2 < 0.9 || (double)factor2 > 1.1) {
                return 0;
            }
            if ((double)factorBig < 0.4 || (double)factorBig > 2.5) {
                return 3;
            }
            if ((double)factorBig < 0.9 || (double)factorBig > 1.1) {
                return 2;
            }
            return 1;
        }
        if (dashes.length == 6) {
            float[] copyDashes = (float[])dashes.clone();
            Arrays.sort(copyDashes);
            if ((double)Math.abs(copyDashes[0] / bs.getLineWidth()) > 0.5) {
                return 0;
            }
            if ((double)Math.abs(copyDashes[1] / bs.getLineWidth()) > 0.5) {
                return 0;
            }
            float factor2 = 2.0f * bs.getLineWidth() / copyDashes[2];
            float factor3 = 2.0f * bs.getLineWidth() / copyDashes[3];
            float factor4 = 2.0f * bs.getLineWidth() / copyDashes[4];
            float factorBig = 2.0f * bs.getLineWidth() / copyDashes[5];
            if ((double)factor2 < 0.9 || (double)factor2 > 1.1 || (double)factor3 < 0.9 || (double)factor3 > 1.1 || (double)factor4 < 0.9 || (double)factor4 > 1.1) {
                return 0;
            }
            if ((double)factorBig < 0.4 || (double)factorBig > 2.5) {
                return 4;
            }
            if ((double)factorBig < 0.9 || (double)factorBig > 1.1) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public static BorderStyle translateStrokeStyle(Stroke s) {
        int style = StrokeUtility.getStrokeType(s);
        switch (style) {
            case 5: {
                return BorderStyle.NONE;
            }
            case 1: {
                return BorderStyle.DASHED;
            }
            case 2: {
                return BorderStyle.DOTTED;
            }
            case 3: {
                return BorderStyle.DOT_DASH;
            }
            case 4: {
                return BorderStyle.DOT_DOT_DASH;
            }
        }
        return BorderStyle.SOLID;
    }
}

