/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterMapping;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ReportPreProcessorRegistry;
import org.pentaho.reporting.engine.classic.core.parameters.DefaultParameterContext;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterValidator;
import org.pentaho.reporting.engine.classic.core.parameters.ValidationResult;
import org.pentaho.reporting.engine.classic.core.states.LayoutProcess;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.libraries.base.config.Configuration;

public class StateUtilities {
    private StateUtilities() {
    }

    public static boolean computeLevels(DefaultFlowController report, LayoutProcess lp, HashSet<Integer> levels) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (lp == null) {
            throw new NullPointerException();
        }
        if (levels == null) {
            throw new NullPointerException();
        }
        boolean retval = false;
        StructureFunction[] collectionFunctions = lp.getCollectionFunctions();
        for (int i = 0; i < collectionFunctions.length; ++i) {
            StructureFunction function = collectionFunctions[i];
            if (function.getDependencyLevel() == Integer.MAX_VALUE) continue;
            Integer level = IntegerCache.getInteger(function.getDependencyLevel());
            levels.add(level);
            if (level == -2) continue;
            retval = true;
        }
        levels.add(IntegerCache.getInteger(-2));
        Expression[] expressions = report.getMasterRow().getExpressionDataRow().getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            Expression expression = expressions[i];
            Integer level = IntegerCache.getInteger(expression.getDependencyLevel());
            levels.add(level);
            if (level == -2) continue;
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ValidationResult validate(MasterReport report, ValidationResult result) throws ReportProcessingException {
        ReportParameterDefinition parameters = report.getParameterDefinition();
        try (DefaultParameterContext parameterContext = new DefaultParameterContext(report);){
            ReportParameterValidator reportParameterValidator = parameters.getValidator();
            ValidationResult validationResult = reportParameterValidator.validate(result, parameters, parameterContext);
            return validationResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReportParameterValues computeParameterValueSet(MasterReport report) throws ReportProcessingException {
        ReportParameterDefinition parameters = report.getParameterDefinition();
        try (DefaultParameterContext parameterContext = new DefaultParameterContext(report);){
            ReportParameterValidator reportParameterValidator = parameters.getValidator();
            ValidationResult validationResult = reportParameterValidator.validate(new ValidationResult(), parameters, parameterContext);
            ReportParameterValues parameterValues = validationResult.getParameterValues();
            ReportParameterValues reportParameterValues = StateUtilities.computeParameterValueSet(report, parameterValues);
            return reportParameterValues;
        }
    }

    public static ReportParameterValues computeParameterValueSet(MasterReport report, ReportParameterValues parameterValues) throws ReportProcessingException {
        ReportEnvironment reportEnvironment;
        Object property;
        ReportParameterValues retval = new ReportParameterValues();
        retval.putAll(parameterValues);
        Configuration config = report.getConfiguration();
        if ("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.legacy.ReportNameAsProperty"))) {
            retval.put("report.name", report.getName());
        }
        if (!((property = (reportEnvironment = report.getReportEnvironment()).getEnvironmentProperty("::internal::report.date")) instanceof Date)) {
            retval.put("report.date", new Date());
        } else {
            retval.put("report.date", property);
        }
        return retval;
    }

    public static ReportParameterValues computeParameterValueSet(SubReport report) {
        ReportParameterValues retval = new ReportParameterValues();
        retval.put("report.date", new Date());
        ParameterMapping[] reportParameterValues = report.getInputMappings();
        for (int i = 0; i < reportParameterValues.length; ++i) {
            ParameterMapping mapping = reportParameterValues[i];
            if ("*".equals(mapping.getName())) continue;
            retval.put(mapping.getName(), null);
        }
        return retval;
    }

    public static ReportPreProcessor[] getAllPreProcessors(AbstractReportDefinition reportDefinition, boolean designTime) {
        ReportPreProcessorRegistry registry = ReportPreProcessorRegistry.getInstance();
        ReportPreProcessor[] processors = reportDefinition.getPreProcessors();
        ArrayList<ReportPreProcessor> preProcessors = new ArrayList<ReportPreProcessor>();
        for (int i = 0; i < processors.length; ++i) {
            ReportPreProcessor o = processors[i];
            if (o == null) continue;
            String identifier = o.getClass().getName();
            if (registry.isReportPreProcessorRegistered(identifier)) {
                ReportPreProcessorMetaData metaData = registry.getReportPreProcessorMetaData(identifier);
                if (designTime && !metaData.isExecuteInDesignMode()) continue;
            }
            preProcessors.add(o);
        }
        ReportPreProcessorMetaData[] allProcessors = registry.getAllReportPreProcessorMetaDatas();
        Arrays.sort(allProcessors, new PreProcessorComparator());
        for (int i = 0; i < allProcessors.length; ++i) {
            ReportPreProcessorMetaData processor = allProcessors[i];
            if (designTime && !processor.isExecuteInDesignMode() || !processor.isAutoProcessor()) continue;
            try {
                preProcessors.add(processor.create());
                continue;
            }
            catch (InstantiationException e) {
                throw new InvalidReportStateException("Failed to instantiate automatic-report-pre-processor", e);
            }
        }
        return preProcessors.toArray(new ReportPreProcessor[preProcessors.size()]);
    }

    private static class PreProcessorComparator
    implements Comparator<ReportPreProcessorMetaData> {
        private PreProcessorComparator() {
        }

        @Override
        public int compare(ReportPreProcessorMetaData o1, ReportPreProcessorMetaData o2) {
            return Integer.valueOf(o1.getExecutionPriority()).compareTo(o2.getExecutionPriority());
        }
    }

    public static final class DescendingComparator<T extends Comparable>
    implements Comparator<T>,
    Serializable {
        @Override
        public int compare(T c1, T c2) {
            return -1 * c1.compareTo(c2);
        }
    }
}

