/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.parser;

import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryCore;
import org.pentaho.reporting.engine.classic.core.metadata.DefaultDataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.builder.DataFactoryMetaDataBuilder;
import org.pentaho.reporting.engine.classic.core.metadata.parser.AbstractMetaDataReadHandler;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataFactoryReadHandler
extends AbstractMetaDataReadHandler {
    private DataFactoryMetaDataBuilder builder = new DataFactoryMetaDataBuilder();

    public DataFactoryMetaDataBuilder getBuilder() {
        return this.builder;
    }

    @Override
    protected void startParsing(Attributes attrs) throws SAXException {
        super.startParsing(attrs);
        String editable = attrs.getValue(this.getUri(), "editable");
        this.getBuilder().editable(editable == null || "true".equals(editable));
        this.getBuilder().freeformQuery("true".equals(attrs.getValue(this.getUri(), "freeform-query")));
        this.getBuilder().formattingMetadataSource("true".equals(attrs.getValue(this.getUri(), "metadata-source")));
        this.getBuilder().dataFactoryCore(this.parseDataFactoryCore(attrs));
        this.getBuilder().bundle(this.getBundle(), this.parseKeyPrefix(attrs));
    }

    private String parseKeyPrefix(Attributes attrs) {
        String keyPrefix = attrs.getValue(this.getUri(), "key-prefix");
        if (keyPrefix == null) {
            keyPrefix = "";
        }
        return keyPrefix;
    }

    private DataFactoryCore parseDataFactoryCore(Attributes attrs) throws ParseException {
        String metaDataCoreClass = attrs.getValue(this.getUri(), "impl");
        if (metaDataCoreClass != null) {
            DataFactoryCore dataFactoryCore = (DataFactoryCore)ObjectUtilities.loadAndInstantiate((String)metaDataCoreClass, DataFactoryReadHandler.class, DataFactoryCore.class);
            if (dataFactoryCore == null) {
                throw new ParseException("Attribute 'impl' references a invalid DataFactoryPropertyCore implementation.", this.getLocator());
            }
            return dataFactoryCore;
        }
        return new DefaultDataFactoryCore();
    }

    protected void doneParsing() throws SAXException {
    }

    public Object getObject() throws SAXException {
        return new DefaultDataFactoryMetaData(this.getBuilder());
    }
}

