/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.util;

import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationShiftState;
import org.pentaho.reporting.engine.classic.core.layout.process.util.StackedObjectPool;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class BlockLevelPaginationShiftState
implements PaginationShiftState {
    private PaginationShiftState parent;
    private long shift;
    private long initialShift;
    private boolean breakSuspended;
    private StackedObjectPool<BlockLevelPaginationShiftState> pool;
    private RenderBox box;

    public void reuse(StackedObjectPool<BlockLevelPaginationShiftState> pool, PaginationShiftState parent, RenderBox box) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.pool = pool;
        this.parent = parent;
        this.shift = this.initialShift = parent.getShiftForNextChild();
        this.breakSuspended = parent.isManualBreakSuspendedForChilds();
        this.box = box;
    }

    @Override
    public void suspendManualBreaks() {
        this.breakSuspended = true;
    }

    @Override
    public boolean isManualBreakSuspended() {
        return this.parent.isManualBreakSuspendedForChilds();
    }

    @Override
    public boolean isManualBreakSuspendedForChilds() {
        return this.breakSuspended;
    }

    @Override
    public void updateShiftFromChild(long absoluteValue) {
        this.setShift(absoluteValue);
    }

    @Override
    public void increaseShift(long value) {
        if (value < 0L) {
            throw new IllegalStateException();
        }
        this.shift += value;
    }

    @Override
    public long getShiftForNextChild() {
        return this.shift;
    }

    @Override
    public void setShift(long value) {
        if (value < this.shift) {
            throw new IllegalStateException("Cannot shift backwards");
        }
        this.shift = value;
    }

    @Override
    public PaginationShiftState pop(InstanceID id) {
        if (this.box != null && id != this.box.getInstanceId()) {
            throw new IllegalStateException();
        }
        long effectiveShift = this.shift;
        if (this.box != null && this.box.getParent() != null) {
            long shiftRaw = this.shift - this.initialShift;
            effectiveShift = this.box.getParent().extendHeight(this.box, shiftRaw) + this.initialShift;
            if (effectiveShift != this.initialShift) {
                this.box.getParent().markApplyStateDirty();
            }
        }
        this.parent.updateShiftFromChild(effectiveShift);
        if (this.pool != null) {
            this.pool.free(this);
            this.pool = null;
        }
        this.box = null;
        return this.parent;
    }
}

