/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.io.File;
import org.pentaho.reporting.engine.classic.core.CachingReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DefaultReportEnvironment;
import org.pentaho.reporting.engine.classic.core.DefaultResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportEnvironment;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.output.GenericOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.docbundle.DocumentMetaData;
import org.pentaho.reporting.libraries.docbundle.MemoryDocumentMetaData;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContextFactory;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceKeyCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DefaultProcessingContext
implements ProcessingContext {
    private FormulaContext formulaContext;
    private boolean prepareRun;
    private int processingLevel;
    private OutputProcessorMetaData outputProcessorMetaData;
    private ResourceBundleFactory resourceBundleFactory;
    private Configuration configuration;
    private int progressLevelCount;
    private int progressLevel;
    private ResourceManager resourceManager;
    private ResourceKey contentBase;
    private DocumentMetaData metaData;
    private ReportEnvironment reportEnvironment;
    private long startTime;
    private int compatibilityLevel;

    public DefaultProcessingContext() {
        this.outputProcessorMetaData = new GenericOutputProcessorMetaData();
        this.resourceBundleFactory = new DefaultResourceBundleFactory();
        this.configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        this.resourceManager = new ResourceManager();
        this.reportEnvironment = new CachingReportEnvironment(new DefaultReportEnvironment(this.configuration));
        try {
            this.contentBase = this.resourceManager.createKey((Object)new File("."));
        }
        catch (ResourceKeyCreationException rkce) {
            this.contentBase = null;
        }
        this.formulaContext = DefaultFormulaContextFactory.INSTANCE.create(this.resourceBundleFactory.getLocale(), this.resourceBundleFactory.getTimeZone());
        this.metaData = new MemoryDocumentMetaData();
        this.compatibilityLevel = -1;
    }

    public DefaultProcessingContext(MasterReport report) throws ReportProcessingException {
        this(report, new GenericOutputProcessorMetaData());
    }

    public DefaultProcessingContext(MasterReport report, OutputProcessorMetaData metaData) throws ReportProcessingException {
        this(metaData, report.getResourceBundleFactory(), report.getConfiguration(), report.getResourceManager(), report.getContentBase(), report.getBundle().getMetaData(), report.getReportEnvironment(), -1);
        Integer comLev = report.getCompatibilityLevel();
        if (comLev != null) {
            this.compatibilityLevel = comLev;
        }
    }

    public DefaultProcessingContext(OutputProcessorMetaData outputProcessorMetaData, ResourceBundleFactory resourceBundleFactory, Configuration configuration, ResourceManager resourceManager, ResourceKey contentBase, DocumentMetaData metaData, ReportEnvironment environment, int compatibilityLevel) throws ReportProcessingException {
        if (environment == null) {
            throw new NullPointerException();
        }
        if (configuration == null) {
            throw new NullPointerException();
        }
        if (outputProcessorMetaData == null) {
            throw new NullPointerException();
        }
        if (resourceBundleFactory == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.contentBase = contentBase;
        this.resourceManager = resourceManager;
        this.outputProcessorMetaData = outputProcessorMetaData;
        this.resourceBundleFactory = MasterReport.computeAndInitResourceBundleFactory(resourceBundleFactory, environment);
        this.formulaContext = DefaultFormulaContextFactory.INSTANCE.create(resourceBundleFactory.getLocale(), resourceBundleFactory.getTimeZone());
        this.configuration = configuration;
        this.metaData = metaData == null ? new MemoryDocumentMetaData() : metaData;
        this.reportEnvironment = new CachingReportEnvironment(environment);
        this.startTime = System.currentTimeMillis();
        this.compatibilityLevel = compatibilityLevel;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public ResourceKey getContentBase() {
        return this.contentBase;
    }

    @Override
    public int getProgressLevel() {
        return this.progressLevel;
    }

    public void setProgressLevel(int progressLevel) {
        this.progressLevel = progressLevel;
    }

    @Override
    public int getProgressLevelCount() {
        return this.progressLevelCount;
    }

    public void setProgressLevelCount(int progressLevelCount) {
        this.progressLevelCount = progressLevelCount;
    }

    public void setProcessingLevel(int processingLevel) {
        this.processingLevel = processingLevel;
    }

    @Override
    public int getProcessingLevel() {
        return this.processingLevel;
    }

    @Override
    public FormulaContext getFormulaContext() {
        return this.formulaContext;
    }

    public void setPrepareRun(boolean prepareRun) {
        this.prepareRun = prepareRun;
    }

    @Override
    public boolean isPrepareRun() {
        return this.prepareRun;
    }

    @Override
    public String getExportDescriptor() {
        return this.outputProcessorMetaData.getExportDescriptor();
    }

    @Override
    public OutputProcessorMetaData getOutputProcessorMetaData() {
        return this.outputProcessorMetaData;
    }

    protected void setOutputProcessorMetaData(OutputProcessorMetaData outputProcessorMetaData) {
        if (outputProcessorMetaData == null) {
            throw new NullPointerException();
        }
        this.outputProcessorMetaData = outputProcessorMetaData;
    }

    @Override
    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public DocumentMetaData getDocumentMetaData() {
        return this.metaData;
    }

    @Override
    public ReportEnvironment getEnvironment() {
        return this.reportEnvironment;
    }

    @Override
    public long getReportProcessingStartTime() {
        return this.startTime;
    }

    @Override
    public int getCompatibilityLevel() {
        return this.compatibilityLevel;
    }
}

