/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.output;

import java.util.ArrayList;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.DetailsFooter;
import org.pentaho.reporting.engine.classic.core.DetailsHeader;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupFooter;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.PageHeader;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.OutputFunction;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.InlineSubreportMarker;
import org.pentaho.reporting.engine.classic.core.layout.Renderer;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.DefaultLayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.ElementChangeChecker;
import org.pentaho.reporting.engine.classic.core.layout.output.GroupOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.GroupOutputHandlerFactory;
import org.pentaho.reporting.engine.classic.core.layout.output.LayoutExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.layout.output.LayouterLevel;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RepeatingFooterValidator;
import org.pentaho.reporting.engine.classic.core.layout.output.crosstab.CrosstabRowOutputHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.crosstab.RenderedCrosstabLayout;
import org.pentaho.reporting.engine.classic.core.layout.output.crosstab.RenderedCrosstabOutputHandlerFactory;
import org.pentaho.reporting.engine.classic.core.layout.style.SimpleStyleSheet;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.engine.classic.core.states.datarow.MasterDataRow;
import org.pentaho.reporting.engine.classic.core.states.process.SubReportProcessType;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.FastStack;

public class DefaultOutputFunction
extends AbstractFunction
implements OutputFunction,
PageEventListener {
    private static final Log logger = LogFactory.getLog(DefaultOutputFunction.class);
    private static final LayouterLevel[] EMPTY_LAYOUTER_LEVEL = new LayouterLevel[0];
    public static final InlineSubreportMarker[] EMPTY_INLINE_SUBREPORT_MARKERS = new InlineSubreportMarker[0];
    private ReportEvent currentEvent;
    private Renderer renderer;
    private boolean lastPagebreak;
    private DefaultLayoutPagebreakHandler pagebreakHandler;
    private ArrayList<InlineSubreportMarker> inlineSubreports;
    private FastStack<GroupOutputHandler> outputHandlers;
    private int beginOfRow;
    private FastStack<RenderedCrosstabLayout> renderedCrosstabLayouts;
    private GroupOutputHandlerFactory groupOutputHandlerFactory;
    private ElementChangeChecker elementChangeChecker;
    private int printedFooter;
    private int printedRepeatingFooter;
    private int avoidedFooter;
    private int avoidedRepeatingFooter;
    private RepeatingFooterValidator repeatingFooterValidator;
    private boolean clearedFooter;
    private ArrayList<InstanceID> subReportFooterTracker = new ArrayList();

    public DefaultOutputFunction() {
        this.repeatingFooterValidator = new RepeatingFooterValidator();
        this.pagebreakHandler = new DefaultLayoutPagebreakHandler();
        this.inlineSubreports = new ArrayList();
        this.outputHandlers = new FastStack();
        this.renderedCrosstabLayouts = new FastStack();
        this.groupOutputHandlerFactory = new RenderedCrosstabOutputHandlerFactory();
        this.elementChangeChecker = new ElementChangeChecker();
    }

    protected OutputProcessorMetaData getMetaData() {
        return this.getRenderer().getOutputProcessor().getMetaData();
    }

    @Override
    public Object getValue() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportInitialized(ReportEvent event) {
        block11: {
            if (event.getState().getParentSubReportState() != null) {
                this.clearPendingPageStart(event);
            }
            this.setCurrentEvent(event);
            try {
                ReportDefinition report = event.getReport();
                if (!event.getState().isSubReportEvent()) {
                    this.renderer.startReport(report, this.getRuntime().getProcessingContext(), event.getState().getPerformanceMonitorContext());
                    ReportState reportState = event.getState();
                    ExpressionRuntime runtime = this.getRuntime();
                    try {
                        reportState.firePageStartedEvent(reportState.getEventCode());
                        break block11;
                    }
                    finally {
                        this.setRuntime(runtime);
                        this.setCurrentEvent(event);
                    }
                }
                this.renderer.startSubReport(report, event.getState().getCurrentSubReportMarker().getInsertationPointId());
            }
            catch (InvalidReportStateException fe) {
                throw fe;
            }
            catch (Exception e) {
                throw new InvalidReportStateException("ReportInitialized failed", e);
            }
            finally {
                this.clearCurrentEvent();
            }
        }
    }

    @Override
    public void reportStarted(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            this.updateFooterArea(event);
            ReportDefinition report = event.getReport();
            this.renderer.startSection(Renderer.SectionType.NORMALFLOW);
            this.print(this.getRuntime(), report.getReportHeader());
            this.addSubReportMarkers(this.renderer.endSection());
            this.printDesigntimeHeader(event);
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("ReportStarted failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    protected void printDesigntimeHeader(ReportEvent event) throws ReportProcessingException {
    }

    public void addSubReportMarkers(InlineSubreportMarker[] markers) {
        for (int i = 0; i < markers.length; ++i) {
            InlineSubreportMarker marker = markers[i];
            this.inlineSubreports.add(marker);
        }
    }

    @Override
    public void groupStarted(ReportEvent event) {
        int type = event.getType();
        GroupOutputHandler groupOutputHandler = this.groupOutputHandlerFactory.getOutputHandler(event, this.beginOfRow);
        this.outputHandlers.push((Object)groupOutputHandler);
        if ((type & 0x410000) == 0x410000) {
            this.beginOfRow = event.getState().getCurrentRow();
        }
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.peek();
            handler.groupStarted(this, event);
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("GroupStarted failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    @Override
    public void itemsStarted(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.peek();
            handler.itemsStarted(this, event);
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("ItemsStarted failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.peek();
            handler.itemsAdvanced(this, event);
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("ItemsAdvanced failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    @Override
    public void itemsFinished(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.peek();
            handler.itemsFinished(this, event);
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("ItemsFinished failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    @Override
    public void groupBodyFinished(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.peek();
            handler.groupBodyFinished(this, event);
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("GroupBody failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    @Override
    public void groupFinished(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.pop();
            handler.groupFinished(this, event);
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("GroupFinished failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            if ((event.getType() & 0x1800) == 6144) {
                CrosstabRowOutputHandler handler = new CrosstabRowOutputHandler();
                this.outputHandlers.push((Object)handler);
                handler.summaryRowStart(this, event);
            } else if ((event.getType() & 0x2800) == 10240) {
                GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.pop();
                handler.summaryRowEnd(this, event);
            } else {
                GroupOutputHandler handler = (GroupOutputHandler)this.outputHandlers.peek();
                handler.summaryRow(this, event);
            }
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("Summary Row Selection event failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    @Override
    public void reportFinished(ReportEvent event) {
        this.clearPendingPageStart(event);
        this.setCurrentEvent(event);
        try {
            this.renderer.startSection(Renderer.SectionType.NORMALFLOW);
            this.print(this.getRuntime(), event.getReport().getReportFooter());
            this.addSubReportMarkers(this.renderer.endSection());
            if (!event.isDeepTraversing()) {
                this.lastPagebreak = true;
            }
            this.updateFooterArea(event);
            this.printDesigntimeFooter(event);
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("ReportFinished failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    protected void printDesigntimeFooter(ReportEvent event) throws ReportProcessingException {
    }

    @Override
    public void reportDone(ReportEvent event) {
        if (!event.getState().isSubReportEvent()) {
            this.renderer.endReport();
        } else {
            this.renderer.endSubReport();
        }
        this.printPerformanceStats();
    }

    protected void printPerformanceStats() {
        this.elementChangeChecker.reportCachePerformance();
        logger.info((Object)String.format("Performance: footer-printed=%d footer-avoided=%d repeating-footer-printed=%d repeating-footer-avoided=%d", this.printedFooter, this.avoidedFooter, this.printedRepeatingFooter, this.avoidedRepeatingFooter));
    }

    private static LayoutExpressionRuntime createRuntime(MasterDataRow masterRow, ReportState state, ProcessingContext processingContext) {
        TableModel reportDataModel = masterRow.getReportData();
        return new LayoutExpressionRuntime(masterRow.getGlobalView(), masterRow.getDataSchema(), state, reportDataModel, processingContext);
    }

    private static LayouterLevel[] collectSubReportStates(ReportState state, ProcessingContext processingContext) {
        if (processingContext == null) {
            throw new NullPointerException();
        }
        ReportState parentState = state.getParentSubReportState();
        if (parentState == null) {
            return EMPTY_LAYOUTER_LEVEL;
        }
        MasterDataRow dataRow = state.getFlowController().getMasterRow();
        if ((dataRow = dataRow.getParentDataRow()) == null) {
            throw new IllegalStateException("Parent-DataRow in a subreport-state must be defined.");
        }
        ArrayList<LayouterLevel> stack = new ArrayList<LayouterLevel>();
        while (parentState != null) {
            if (!parentState.isInlineProcess()) {
                LayoutExpressionRuntime runtime = DefaultOutputFunction.createRuntime(dataRow, parentState, processingContext);
                stack.add(new LayouterLevel(parentState.getReport(), parentState.getPresentationGroupIndex(), runtime, parentState.isInItemGroup()));
            }
            parentState = parentState.getParentSubReportState();
            if ((dataRow = dataRow.getParentDataRow()) != null) continue;
            throw new IllegalStateException("Parent-DataRow in a subreport-state must be defined.");
        }
        return stack.toArray(new LayouterLevel[stack.size()]);
    }

    private int computeCurrentPage() {
        return this.renderer.getPageCount() + 1;
    }

    private boolean isPageHeaderPrinting(Band b, boolean testSticky) {
        SimpleStyleSheet resolverStyleSheet = b.getComputedStyle();
        if (resolverStyleSheet == null) {
            throw new InvalidReportStateException("Inv");
        }
        if (this.isDesignTime()) {
            return true;
        }
        if (testSticky && !resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.STICKY)) {
            return false;
        }
        boolean displayOnFirstPage = resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE);
        if (this.computeCurrentPage() == 1 && !displayOnFirstPage) {
            return false;
        }
        boolean displayOnLastPage = resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE);
        return !this.isLastPagebreak() || displayOnLastPage;
    }

    protected boolean isLastPagebreak() {
        return this.lastPagebreak;
    }

    @Override
    public void pageStarted(ReportEvent event) {
        this.setCurrentEvent(event);
        try {
            int mask = 0x8000001;
            if (event.getState().isSubReportEvent() && (event.getType() & 0x8000001) == 0x8000001 && (!this.renderer.isCurrentPageEmpty() || this.renderer.validatePages() == Renderer.LayoutResult.LAYOUT_UNVALIDATABLE)) {
                return;
            }
            this.renderer.newPageStarted();
            this.clearedFooter = true;
            this.updateHeaderArea(event.getState());
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("PageStarted failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    protected void updateHeaderArea(ReportState givenState) throws ReportProcessingException {
        ReportState state;
        for (state = givenState; state != null && state.isInlineProcess(); state = state.getParentSubReportState()) {
        }
        if (state == null) {
            return;
        }
        ProcessingContext processingContext = this.getRuntime().getProcessingContext();
        ReportDefinition report = state.getReport();
        LayouterLevel[] levels = null;
        ExpressionRuntime runtime = null;
        OutputProcessorMetaData metaData = this.renderer.getOutputProcessor().getMetaData();
        if (metaData.isFeatureSupported(OutputProcessorFeature.WATERMARK_SECTION)) {
            this.renderer.startSection(Renderer.SectionType.WATERMARK);
            levels = DefaultOutputFunction.collectSubReportStates(state, processingContext);
            runtime = this.updateWatermark(state, processingContext, report, levels, runtime);
            this.addSubReportMarkers(this.renderer.endSection());
        }
        if (metaData.isFeatureSupported(OutputProcessorFeature.PAGE_SECTIONS)) {
            this.renderer.startSection(Renderer.SectionType.HEADER);
            if (levels == null) {
                levels = DefaultOutputFunction.collectSubReportStates(state, processingContext);
            }
            runtime = this.updatePageHeader(state, processingContext, report, levels, runtime);
            runtime = this.updateRepeatingGroupHeader(state, processingContext, report, levels, runtime);
            this.updateDetailsHeader(state, processingContext, report, runtime);
            this.addSubReportMarkers(this.renderer.endSection());
        }
    }

    protected ExpressionRuntime updateWatermark(ReportState state, ProcessingContext processingContext, ReportDefinition report, LayouterLevel[] levels, ExpressionRuntime runtime) throws ReportProcessingException {
        for (int i = levels.length - 1; i >= 0; --i) {
            LayouterLevel level = levels[i];
            ReportDefinition def = level.getReportDefinition();
            Watermark watermark = def.getWatermark();
            if (!this.isPageHeaderPrinting(watermark, true)) continue;
            this.print(level.getRuntime(), watermark);
        }
        Watermark watermark = report.getWatermark();
        if (this.isPageHeaderPrinting(watermark, false)) {
            runtime = DefaultOutputFunction.createRuntime(state.getFlowController().getMasterRow(), state, processingContext);
            this.print(runtime, watermark);
        }
        return runtime;
    }

    protected ExpressionRuntime updatePageHeader(ReportState state, ProcessingContext processingContext, ReportDefinition report, LayouterLevel[] levels, ExpressionRuntime runtime) throws ReportProcessingException {
        for (int i = levels.length - 1; i >= 0; --i) {
            LayouterLevel level = levels[i];
            ReportDefinition def = level.getReportDefinition();
            PageHeader header = def.getPageHeader();
            if (!this.isPageHeaderPrinting(header, true)) continue;
            this.print(level.getRuntime(), header);
        }
        PageHeader b = report.getPageHeader();
        if (this.isPageHeaderPrinting(b, false)) {
            if (runtime == null) {
                runtime = DefaultOutputFunction.createRuntime(state.getFlowController().getMasterRow(), state, processingContext);
            }
            this.print(runtime, b);
        }
        return runtime;
    }

    protected ExpressionRuntime updateRepeatingGroupHeader(ReportState state, ProcessingContext processingContext, ReportDefinition report, LayouterLevel[] levels, ExpressionRuntime runtime) throws ReportProcessingException {
        if (this.isDesignTime()) {
            return runtime;
        }
        for (int i = levels.length - 1; i >= 0; --i) {
            DetailsHeader detailsHeader;
            LayouterLevel level = levels[i];
            ReportDefinition def = level.getReportDefinition();
            for (int gidx = 0; gidx <= level.getGroupIndex(); ++gidx) {
                RelationalGroup rg;
                GroupHeader header;
                Group g = def.getGroup(gidx);
                if (!(g instanceof RelationalGroup) || !this.isGroupSectionPrintableInternal(header = (rg = (RelationalGroup)g).getHeader(), true, true)) continue;
                this.print(level.getRuntime(), header);
            }
            if (!level.isInItemGroup() || (detailsHeader = def.getDetailsHeader()) == null || !this.isGroupSectionPrintableInternal(detailsHeader, true, true)) continue;
            this.print(level.getRuntime(), detailsHeader);
        }
        int groupsPrinted = state.getPresentationGroupIndex();
        for (int gidx = 0; gidx <= groupsPrinted; ++gidx) {
            RelationalGroup rg;
            GroupHeader header;
            Group g = report.getGroup(gidx);
            if (!(g instanceof RelationalGroup) || !this.isGroupSectionPrintableInternal(header = (rg = (RelationalGroup)g).getHeader(), false, true)) continue;
            if (runtime == null) {
                runtime = DefaultOutputFunction.createRuntime(state.getFlowController().getMasterRow(), state, processingContext);
            }
            this.print(runtime, header);
        }
        return runtime;
    }

    protected ExpressionRuntime updateDetailsHeader(ReportState state, ProcessingContext processingContext, ReportDefinition report, ExpressionRuntime runtime) throws ReportProcessingException {
        DetailsHeader detailsHeader;
        if (this.isDesignTime()) {
            return runtime;
        }
        if (state.isInItemGroup() && (detailsHeader = report.getDetailsHeader()) != null && this.isGroupSectionPrintableInternal(detailsHeader, false, true)) {
            if (runtime == null) {
                runtime = DefaultOutputFunction.createRuntime(state.getFlowController().getMasterRow(), state, processingContext);
            }
            this.print(runtime, detailsHeader);
        }
        return runtime;
    }

    @Override
    public void pageFinished(ReportEvent event) {
        this.setCurrentEvent(event);
        try {
            this.updateFooterArea(event);
        }
        catch (InvalidReportStateException fe) {
            throw fe;
        }
        catch (Exception e) {
            throw new InvalidReportStateException("PageFinished failed", e);
        }
        finally {
            this.clearCurrentEvent();
        }
    }

    public void updateFooterArea(ReportEvent event) throws ReportProcessingException {
        OutputProcessorMetaData metaData = this.renderer.getOutputProcessor().getMetaData();
        if (!metaData.isFeatureSupported(OutputProcessorFeature.PAGE_SECTIONS)) {
            return;
        }
        if (event.getState().isInlineProcess()) {
            return;
        }
        LayouterLevel[] levels = DefaultOutputFunction.collectSubReportStates(event.getState(), this.getRuntime().getProcessingContext());
        if (this.isSubReportConfigurationChanged(levels)) {
            this.clearedFooter = true;
            this.refreshSubReportFooterConfiguration(levels);
        }
        this.updateRepeatingFooters(event, levels);
        this.updatePageFooter(event, levels);
        this.clearedFooter = false;
    }

    private void refreshSubReportFooterConfiguration(LayouterLevel[] levels) {
        this.subReportFooterTracker.clear();
        for (LayouterLevel level : levels) {
            this.subReportFooterTracker.add(level.getReportDefinition().getObjectID());
        }
    }

    private boolean isSubReportConfigurationChanged(LayouterLevel[] levels) {
        if (levels.length != this.subReportFooterTracker.size()) {
            return true;
        }
        for (int i = 0; i < this.subReportFooterTracker.size(); ++i) {
            InstanceID instanceID = this.subReportFooterTracker.get(i);
            if (levels[i].getReportDefinition().getObjectID() == instanceID) continue;
            return true;
        }
        return false;
    }

    protected boolean updatePageFooter(ReportEvent event, LayouterLevel[] levels) throws ReportProcessingException {
        PageFooter pageFooter;
        ReportDefinition report = event.getReport();
        int levelCount = levels.length;
        DataRow dataRow = event.getDataRow();
        boolean needPrinting = this.isPageFooterPrinting(levels, levelCount, dataRow, pageFooter = report.getPageFooter());
        if (!needPrinting) {
            ++this.avoidedFooter;
            return false;
        }
        this.renderer.startSection(Renderer.SectionType.FOOTER);
        if (this.isPageFooterPrintable(pageFooter, false)) {
            this.print(this.getRuntime(), pageFooter);
        } else {
            this.printEmptyRootLevelBand();
        }
        for (int i = 0; i < levelCount; ++i) {
            LayouterLevel level = levels[i];
            ReportDefinition def = level.getReportDefinition();
            PageFooter b = def.getPageFooter();
            if (this.isPageFooterPrintable(b, true)) {
                this.print(level.getRuntime(), b);
                continue;
            }
            this.printEmptyRootLevelBand();
        }
        this.addSubReportMarkers(this.renderer.endSection());
        ++this.printedFooter;
        return true;
    }

    private boolean isPageFooterPrinting(LayouterLevel[] levels, int levelCount, DataRow dataRow, PageFooter pageFooter) {
        if (this.isDesignTime()) {
            return true;
        }
        if (this.clearedFooter) {
            return true;
        }
        if (this.isPageFooterPrintable(pageFooter, false) && this.elementChangeChecker.isBandChanged(pageFooter, dataRow)) {
            return true;
        }
        for (int i = 0; i < levelCount; ++i) {
            LayouterLevel level = levels[i];
            ReportDefinition def = level.getReportDefinition();
            PageFooter b = def.getPageFooter();
            if (!this.isPageFooterPrintable(b, true) || !this.elementChangeChecker.isBandChanged(b, dataRow)) continue;
            return true;
        }
        return false;
    }

    protected boolean updateRepeatingFooters(ReportEvent event, LayouterLevel[] levels) throws ReportProcessingException {
        DetailsFooter footer;
        ReportDefinition report = event.getReport();
        ReportState state = event.getState();
        int groupsPrinted = state.getPresentationGroupIndex();
        int levelCount = levels.length;
        boolean needPrinting = this.isNeedPrintRepeatingFooter(event, levels);
        if (!needPrinting) {
            ++this.avoidedRepeatingFooter;
            return false;
        }
        this.renderer.startSection(Renderer.SectionType.REPEAT_FOOTER);
        if (state.isInItemGroup() && this.isGroupSectionPrintableInternal(footer = report.getDetailsFooter(), false, true)) {
            this.print(this.getRuntime(), footer);
        }
        for (int gidx = groupsPrinted; gidx >= 0; --gidx) {
            RelationalGroup rg;
            GroupFooter footer2;
            Group g = report.getGroup(gidx);
            if (!(g instanceof RelationalGroup) || !this.isGroupSectionPrintableInternal(footer2 = (rg = (RelationalGroup)g).getFooter(), false, true)) continue;
            this.print(this.getRuntime(), footer2);
        }
        for (int i = 0; i < levelCount; ++i) {
            DetailsFooter detailsFooter;
            LayouterLevel level = levels[i];
            ReportDefinition def = level.getReportDefinition();
            if (level.isInItemGroup() && (detailsFooter = def.getDetailsFooter()) != null && this.isGroupSectionPrintableInternal(detailsFooter, true, true)) {
                this.print(level.getRuntime(), detailsFooter);
            }
            for (int gidx = level.getGroupIndex(); gidx >= 0; --gidx) {
                RelationalGroup rg;
                GroupFooter footer3;
                Group g = def.getGroup(gidx);
                if (!(g instanceof RelationalGroup) || !this.isGroupSectionPrintableInternal(footer3 = (rg = (RelationalGroup)g).getFooter(), true, true)) continue;
                this.print(level.getRuntime(), footer3);
            }
        }
        this.addSubReportMarkers(this.renderer.endSection());
        ++this.printedRepeatingFooter;
        return true;
    }

    protected boolean isNeedPrintRepeatingFooter(ReportEvent event, LayouterLevel[] levels) {
        DetailsFooter footer;
        ReportDefinition report = event.getReport();
        ReportState state = event.getState();
        int groupsPrinted = state.getPresentationGroupIndex();
        int levelCount = levels.length;
        DataRow dataRow = event.getDataRow();
        if (!this.repeatingFooterValidator.isRepeatFooterValid(event, levels)) {
            return true;
        }
        boolean needPrinting = this.clearedFooter;
        if (!needPrinting && state.isInItemGroup() && this.isGroupSectionPrintableInternal(footer = report.getDetailsFooter(), false, true) && this.elementChangeChecker.isBandChanged(footer, dataRow)) {
            needPrinting = true;
        }
        if (!needPrinting) {
            for (int gidx = groupsPrinted; gidx >= 0; --gidx) {
                RelationalGroup rg;
                GroupFooter footer2;
                Group g = report.getGroup(gidx);
                if (!(g instanceof RelationalGroup) || !this.isGroupSectionPrintableInternal(footer2 = (rg = (RelationalGroup)g).getFooter(), false, true) || !this.elementChangeChecker.isBandChanged(footer2, dataRow)) continue;
                needPrinting = true;
            }
        }
        if (!needPrinting) {
            for (int i = 0; i < levelCount; ++i) {
                DetailsFooter detailsFooter;
                LayouterLevel level = levels[i];
                ReportDefinition def = level.getReportDefinition();
                if (level.isInItemGroup() && (detailsFooter = def.getDetailsFooter()) != null && this.isGroupSectionPrintableInternal(detailsFooter, true, true) && this.elementChangeChecker.isBandChanged(detailsFooter, dataRow)) {
                    needPrinting = true;
                }
                if (needPrinting) continue;
                for (int gidx = level.getGroupIndex(); gidx >= 0; --gidx) {
                    RelationalGroup rg;
                    GroupFooter footer3;
                    Group g = def.getGroup(gidx);
                    if (!(g instanceof RelationalGroup) || !this.isGroupSectionPrintableInternal(footer3 = (rg = (RelationalGroup)g).getFooter(), true, true) || !this.elementChangeChecker.isBandChanged(footer3, dataRow)) continue;
                    needPrinting = true;
                }
            }
        }
        return needPrinting;
    }

    protected boolean isGroupSectionPrintableInternal(Band b, boolean testSticky, boolean testRepeat) {
        return DefaultOutputFunction.isGroupSectionPrintable(b, testSticky, testRepeat);
    }

    public static boolean isGroupSectionPrintable(Band b, boolean testSticky, boolean testRepeat) {
        SimpleStyleSheet resolverStyleSheet = b.getComputedStyle();
        if (testSticky && !resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.STICKY)) {
            return false;
        }
        return !testRepeat || resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.REPEAT_HEADER);
    }

    protected boolean isPageFooterPrintable(Band b, boolean testSticky) {
        SimpleStyleSheet resolverStyleSheet = b.getComputedStyle();
        if (testSticky && !resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.STICKY)) {
            return false;
        }
        if (this.computeCurrentPage() == 1) {
            return resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_FIRSTPAGE);
        }
        if (this.isLastPagebreak()) {
            return resolverStyleSheet.getBooleanStyleProperty(BandStyleKeys.DISPLAY_ON_LASTPAGE);
        }
        return true;
    }

    protected ReportEvent getCurrentEvent() {
        return this.currentEvent;
    }

    protected void setCurrentEvent(ReportEvent currentEvent) {
        if (currentEvent == null) {
            throw new NullPointerException("Event must not be null.");
        }
        this.currentEvent = currentEvent;
        this.pagebreakHandler.setReportState(currentEvent.getState());
        this.renderer.setStateKey(currentEvent.getState().getProcessKey());
    }

    protected void clearCurrentEvent() {
        if (this.currentEvent == null) {
            throw new IllegalStateException("ClearCurrentEvent called without Event set:");
        }
        this.currentEvent = null;
        this.pagebreakHandler.setReportState(null);
        this.renderer.setStateKey(null);
    }

    @Override
    public final Object clone() throws CloneNotSupportedException {
        DefaultOutputFunction sl = (DefaultOutputFunction)super.clone();
        sl.repeatingFooterValidator = this.repeatingFooterValidator.clone();
        sl.currentEvent = null;
        sl.inlineSubreports = (ArrayList)this.inlineSubreports.clone();
        sl.outputHandlers = this.outputHandlers.clone();
        sl.renderedCrosstabLayouts = this.renderedCrosstabLayouts.clone();
        sl.renderedCrosstabLayouts.clear();
        int rSize = this.renderedCrosstabLayouts.size();
        for (int i = 0; i < rSize; ++i) {
            RenderedCrosstabLayout o = (RenderedCrosstabLayout)this.renderedCrosstabLayouts.get(i);
            sl.renderedCrosstabLayouts.push((Object)((RenderedCrosstabLayout)o.clone()));
        }
        return sl;
    }

    @Override
    public Expression getInstance() {
        return this.deriveForStorage();
    }

    @Override
    public OutputFunction deriveForStorage() {
        try {
            DefaultOutputFunction sl = (DefaultOutputFunction)super.clone();
            sl.repeatingFooterValidator = this.repeatingFooterValidator.clone();
            sl.renderer = this.renderer.deriveForStorage();
            sl.inlineSubreports = (ArrayList)this.inlineSubreports.clone();
            sl.currentEvent = null;
            sl.pagebreakHandler = (DefaultLayoutPagebreakHandler)this.pagebreakHandler.clone();
            sl.pagebreakHandler.setReportState(null);
            sl.outputHandlers = this.outputHandlers.clone();
            sl.renderedCrosstabLayouts = this.renderedCrosstabLayouts.clone();
            sl.renderedCrosstabLayouts.clear();
            int rSize = this.renderedCrosstabLayouts.size();
            for (int i = 0; i < rSize; ++i) {
                RenderedCrosstabLayout o = (RenderedCrosstabLayout)this.renderedCrosstabLayouts.get(i);
                sl.renderedCrosstabLayouts.push((Object)o.derive());
            }
            return sl;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    @Override
    public OutputFunction deriveForPagebreak() {
        try {
            DefaultOutputFunction sl = (DefaultOutputFunction)super.clone();
            sl.repeatingFooterValidator = this.repeatingFooterValidator.clone();
            sl.renderer = this.renderer.deriveForPagebreak();
            sl.inlineSubreports = (ArrayList)this.inlineSubreports.clone();
            sl.currentEvent = null;
            sl.pagebreakHandler = (DefaultLayoutPagebreakHandler)this.pagebreakHandler.clone();
            sl.outputHandlers = this.outputHandlers.clone();
            sl.renderedCrosstabLayouts = this.renderedCrosstabLayouts.clone();
            sl.renderedCrosstabLayouts.clear();
            int rSize = this.renderedCrosstabLayouts.size();
            for (int i = 0; i < rSize; ++i) {
                RenderedCrosstabLayout o = (RenderedCrosstabLayout)this.renderedCrosstabLayouts.get(i);
                sl.renderedCrosstabLayouts.push((Object)o.derive());
            }
            return sl;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    protected boolean isDesignTime() {
        return false;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void print(ExpressionRuntime dataRow, Band band) throws ReportProcessingException {
        this.renderer.add(band, dataRow);
    }

    protected void printEmptyRootLevelBand() throws ReportProcessingException {
        this.renderer.addEmptyRootLevelBand();
    }

    private void clearPendingPageStart(ReportEvent event) {
        this.clearPendingPageStart(event, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPendingPageStart(ReportEvent event, boolean force) {
        this.pagebreakHandler.setReportState(event.getState());
        try {
            if (this.renderer.clearPendingPageStart(this.pagebreakHandler)) {
                return;
            }
            if (!force) {
                boolean validateResult;
                boolean currentPageEmpty = this.renderer.isCurrentPageEmpty();
                if (!currentPageEmpty) {
                    return;
                }
                boolean bl = validateResult = this.renderer.validatePages() != Renderer.LayoutResult.LAYOUT_UNVALIDATABLE;
                if (!validateResult) {
                    return;
                }
            }
            try {
                this.setCurrentEvent(event);
                this.renderer.newPageStarted();
                this.clearedFooter = true;
                this.updateHeaderArea(event.getState());
            }
            finally {
                this.clearCurrentEvent();
            }
        }
        catch (ReportProcessingException e) {
            throw new InvalidReportStateException("Failed to update the page-header", e);
        }
        catch (ContentProcessingException e) {
            throw new InvalidReportStateException("Failed to update the page-header", e);
        }
        finally {
            this.pagebreakHandler.setReportState(null);
        }
    }

    @Override
    public InlineSubreportMarker[] getInlineSubreports() {
        if (this.inlineSubreports.isEmpty()) {
            return EMPTY_INLINE_SUBREPORT_MARKERS;
        }
        return this.inlineSubreports.toArray(new InlineSubreportMarker[this.inlineSubreports.size()]);
    }

    @Override
    public void clearInlineSubreports(SubReportProcessType inlineExecution) {
        InlineSubreportMarker[] subreports = this.getInlineSubreports();
        for (int i = subreports.length - 1; i >= 0; --i) {
            InlineSubreportMarker subreport = subreports[i];
            if (inlineExecution != subreport.getProcessType()) continue;
            this.inlineSubreports.remove(i);
        }
    }

    public RenderedCrosstabLayout startRenderedCrosstabLayout() {
        RenderedCrosstabLayout layout = new RenderedCrosstabLayout();
        this.renderedCrosstabLayouts.push((Object)layout);
        return layout;
    }

    public RenderedCrosstabLayout getCurrentRenderedCrosstabLayout() {
        return (RenderedCrosstabLayout)this.renderedCrosstabLayouts.peek();
    }

    public void endRenderedCrosstabLayout() {
        this.renderedCrosstabLayouts.pop();
    }

    @Override
    public void restart(ReportState state) throws ReportProcessingException {
        ReportEvent event = new ReportEvent(state, state.getEventCode());
        this.clearPendingPageStart(event, true);
    }

    @Override
    public boolean createRollbackInformation() {
        Renderer commitableRenderer = this.getRenderer();
        commitableRenderer.createRollbackInformation();
        return true;
    }
}

