/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class HideNullValuesFunction
extends AbstractElementFormatFunction {
    private String field;

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    @Override
    protected boolean evaluateElement(ReportElement e) {
        if (ObjectUtilities.equal((Object)e.getName(), (Object)this.getElement())) {
            boolean visible = this.computeVisibility();
            e.getStyle().setStyleProperty(ElementStyleKeys.VISIBLE, visible);
            return true;
        }
        return false;
    }

    protected boolean computeVisibility() {
        Object value = this.getDataRow().get(this.getField());
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String strValue = (String)value;
            return strValue.trim().length() > 0;
        }
        if (value instanceof Number) {
            Number numValue = (Number)value;
            return numValue.doubleValue() != 0.0;
        }
        return true;
    }
}

