/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.ReportFormulaContext;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.Formula;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;

public final class FormulaFunction
extends AbstractFunction {
    private static final Log logger = LogFactory.getLog(FormulaFunction.class);
    private transient Formula compiledFormula;
    private String formulaNamespace;
    private String formulaExpression;
    private String formula;
    private String initialNamespace;
    private String initialExpression;
    private String initial;
    private boolean initialized;
    private Exception formulaError;
    private Boolean failOnError;

    public Boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(Boolean failOnError) {
        this.failOnError = failOnError;
    }

    private FormulaContext getFormulaContext() {
        ProcessingContext globalContext = this.getRuntime().getProcessingContext();
        return globalContext.getFormulaContext();
    }

    public String getInitial() {
        return this.initial;
    }

    public String getInitialExpression() {
        return this.initialExpression;
    }

    public String getInitialNamespace() {
        return this.initialNamespace;
    }

    public void setInitial(String initial) {
        this.initial = initial;
        if (initial == null) {
            this.initialNamespace = null;
            this.initialExpression = null;
        } else {
            int separator;
            if (initial.endsWith(";")) {
                logger.warn((Object)"A initial-formula with a trailing semicolon is not valid. Auto-correcting the initial-formula.");
                initial = initial.substring(0, initial.length() - 1);
            }
            if ((separator = initial.indexOf(58)) <= 0 || separator + 1 == initial.length()) {
                if (initial.length() > 0 && initial.charAt(0) == '=') {
                    this.initialNamespace = "report";
                    this.initialExpression = initial.substring(1);
                } else {
                    this.initialNamespace = null;
                    this.initialExpression = null;
                }
            } else {
                this.initialNamespace = initial.substring(0, separator);
                this.initialExpression = initial.substring(separator + 1);
            }
        }
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.initialized = false;
    }

    public String getFormula() {
        return this.formula;
    }

    public String getFormulaNamespace() {
        return this.formulaNamespace;
    }

    public String getFormulaExpression() {
        return this.formulaExpression;
    }

    public void setFormula(String formula) {
        this.formula = formula;
        if (formula == null) {
            this.formulaNamespace = null;
            this.formulaExpression = null;
        } else {
            int separator = formula.indexOf(58);
            if (separator <= 0 || separator + 1 == formula.length()) {
                if (formula.length() > 0 && formula.charAt(0) == '=') {
                    this.formulaNamespace = "report";
                    this.formulaExpression = formula.substring(1);
                } else {
                    this.formulaNamespace = null;
                    this.formulaExpression = null;
                }
            } else {
                this.formulaNamespace = formula.substring(0, separator);
                this.formulaExpression = formula.substring(separator + 1);
            }
        }
        this.compiledFormula = null;
        this.formulaError = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object computeInitialValue() {
        if (this.initial == null) return this.computeRegularValue();
        ExpressionRuntime expressionRuntime = this.getRuntime();
        Formula initFormula = new Formula(this.initialExpression);
        ReportFormulaContext context = new ReportFormulaContext(this.getFormulaContext(), expressionRuntime);
        try {
            initFormula.initialize((FormulaContext)context);
            Object evaluate = initFormula.evaluate();
            if (Boolean.TRUE.equals(this.getComputedFailOnError()) && evaluate instanceof ErrorValue) {
                throw new InvalidReportStateException(String.format("Failed to evaluate formula-expression with error %s", evaluate));
            }
            Object object = evaluate;
            context.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                context.close();
                throw throwable;
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    Configuration config = this.getReportConfiguration();
                    if ("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.function.LogFormulaFailureCause"))) {
                        logger.debug((Object)("Failed to compute the initial value [" + this.formulaExpression + ']'), (Throwable)e);
                    } else {
                        logger.debug((Object)("Failed to compute the initial value [" + this.formulaExpression + ']'));
                    }
                }
                if (!Boolean.TRUE.equals(this.getComputedFailOnError())) return LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE;
                throw new InvalidReportStateException(String.format("Failed to evaluate formula-function with error %s", e.getMessage()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object computeRegularValue() {
        if (this.formulaError != null) {
            if (Boolean.TRUE.equals(this.getComputedFailOnError())) {
                throw new InvalidReportStateException(String.format("Previously failed to evaluate formula-expression with error %s", this.formulaError));
            }
            return LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE;
        }
        if (this.compiledFormula == null) {
            this.compiledFormula = new Formula(this.formulaExpression);
        }
        ExpressionRuntime expressionRuntime = this.getRuntime();
        ReportFormulaContext context = new ReportFormulaContext(this.getFormulaContext(), expressionRuntime);
        try {
            this.compiledFormula.initialize((FormulaContext)context);
            Object evaluate = this.compiledFormula.evaluate();
            if (Boolean.TRUE.equals(this.getComputedFailOnError()) && evaluate instanceof ErrorValue) {
                throw new InvalidReportStateException(String.format("Failed to evaluate formula-expression with error %s", evaluate));
            }
            Object object = evaluate;
            context.close();
            return object;
        }
        catch (Throwable throwable) {
            try {
                context.close();
                throw throwable;
            }
            catch (Exception e) {
                this.formulaError = e;
                if (logger.isDebugEnabled()) {
                    Configuration config = this.getReportConfiguration();
                    if ("true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.function.LogFormulaFailureCause"))) {
                        logger.debug((Object)("Failed to compute the regular value [" + this.formulaExpression + ']'), (Throwable)e);
                    } else {
                        logger.debug((Object)("Failed to compute the regular value [" + this.formulaExpression + ']'));
                    }
                }
                if (Boolean.TRUE.equals(this.getComputedFailOnError())) {
                    throw new InvalidReportStateException(String.format("Failed to evaluate formula-function with error %s", e.getMessage()), e);
                }
                return LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE;
            }
        }
    }

    @Override
    public Object getValue() {
        if (!this.initialized) {
            this.initialized = true;
            return this.computeInitialValue();
        }
        return this.computeRegularValue();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FormulaFunction o = (FormulaFunction)super.clone();
        if (this.compiledFormula != null) {
            o.compiledFormula = (Formula)this.compiledFormula.clone();
        }
        return o;
    }

    @Override
    public Expression getInstance() {
        FormulaFunction instance = (FormulaFunction)super.getInstance();
        instance.compiledFormula = null;
        instance.formulaError = null;
        return instance;
    }

    private Boolean getComputedFailOnError() {
        return this.failOnError == null ? "true".equals(this.getReportConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.StrictErrorHandling")) : this.failOnError.booleanValue();
    }
}

