/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.ui;

import java.util.List;
import java.util.function.Supplier;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.extension.ExtensionPointHandler;
import org.pentaho.di.core.extension.KettleExtensionPoint;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.engine.configuration.api.RunConfiguration;
import org.pentaho.di.engine.configuration.api.RunConfigurationService;
import org.pentaho.di.engine.configuration.impl.pentaho.DefaultRunConfiguration;
import org.pentaho.di.engine.ui.RunConfigurationDeleteDialog;
import org.pentaho.di.engine.ui.RunConfigurationDialog;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.JobEntryRunConfigurableInterface;
import org.pentaho.di.ui.spoon.Spoon;

public class RunConfigurationDelegate {
    private static Class<?> PKG = RunConfigurationDelegate.class;
    private Supplier<Spoon> spoonSupplier = Spoon::getInstance;
    private RunConfigurationService configurationManager;

    public RunConfigurationDelegate(RunConfigurationService configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void edit(RunConfiguration runConfiguration) {
        String key = runConfiguration.getName();
        RunConfigurationDialog dialog = new RunConfigurationDialog(this.spoonSupplier.get().getShell(), this.configurationManager, runConfiguration);
        RunConfiguration savedRunConfiguration = dialog.open();
        if (savedRunConfiguration != null) {
            this.configurationManager.delete(key);
            this.configurationManager.save(savedRunConfiguration);
            this.spoonSupplier.get().refreshTree();
            this.updateLoadedJobs(key, savedRunConfiguration);
        }
    }

    protected void updateLoadedJobs(String key, RunConfiguration runConfig) {
        for (JobMeta job : this.spoonSupplier.get().getLoadedJobs()) {
            for (int i = 0; i < job.nrJobEntries(); ++i) {
                JobEntryRunConfigurableInterface jet;
                JobEntryInterface entry = job.getJobEntry(i).getEntry();
                if (!(entry instanceof JobEntryRunConfigurableInterface) || (jet = (JobEntryRunConfigurableInterface)entry).getRunConfiguration() == null || !jet.getRunConfiguration().equals(key)) continue;
                try {
                    ExtensionPointHandler.callExtensionPoint((LogChannelInterface)job.getLogChannel(), (String)KettleExtensionPoint.JobEntryTransSave.id, (Object)new Object[]{job, runConfig.getName()});
                }
                catch (KettleException e) {
                    this.spoonSupplier.get().getLog().logBasic("Unable to set run configuration in job " + job.getName());
                }
                jet.setRunConfiguration(runConfig.getName());
                if (runConfig instanceof DefaultRunConfiguration) {
                    jet.setRemoteSlaveServerName(((DefaultRunConfiguration)runConfig).getServer());
                    jet.setLoggingRemoteWork(((DefaultRunConfiguration)runConfig).isLogRemoteExecutionLocally());
                }
                jet.setChanged();
            }
        }
    }

    public void delete(RunConfiguration runConfiguration) {
        RunConfigurationDeleteDialog deleteDialog = new RunConfigurationDeleteDialog(this.spoonSupplier.get().getShell());
        int response = deleteDialog.open();
        if (response == 64) {
            this.configurationManager.delete(runConfiguration.getName());
            this.spoonSupplier.get().refreshTree();
        }
    }

    public void create() {
        List names = this.configurationManager.getNames();
        String name = BaseMessages.getString(PKG, (String)"RunConfigurationPopupMenuExtension.Configuration.Default", (String[])new String[0]) + " ";
        int index = 1;
        while (names.contains(name + String.valueOf(index))) {
            ++index;
        }
        name = name + String.valueOf(index);
        DefaultRunConfiguration defaultRunConfiguration = new DefaultRunConfiguration();
        defaultRunConfiguration.setName(name);
        RunConfigurationDialog dialog = new RunConfigurationDialog(this.spoonSupplier.get().getShell(), this.configurationManager, (RunConfiguration)defaultRunConfiguration);
        RunConfiguration savedRunConfiguration = dialog.open();
        if (savedRunConfiguration != null) {
            this.configurationManager.save(savedRunConfiguration);
            this.spoonSupplier.get().refreshTree();
        }
    }

    public List<RunConfiguration> load() {
        return this.configurationManager.load();
    }
}

