/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.TezEdgeProperty;
import org.apache.hadoop.mapred.JobConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Explain(displayName="Tez", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class TezWork
extends AbstractOperatorDesc {
    private static final transient Logger LOG = LoggerFactory.getLogger(TezWork.class);
    private static final AtomicInteger counter = new AtomicInteger(1);
    private final String dagId;
    private final String queryName;
    private final Set<BaseWork> roots = new HashSet<BaseWork>();
    private final Set<BaseWork> leaves = new HashSet<BaseWork>();
    private final Map<BaseWork, List<BaseWork>> workGraph = new HashMap<BaseWork, List<BaseWork>>();
    private final Map<BaseWork, List<BaseWork>> invertedWorkGraph = new HashMap<BaseWork, List<BaseWork>>();
    private final Map<Pair<BaseWork, BaseWork>, TezEdgeProperty> edgeProperties = new HashMap<Pair<BaseWork, BaseWork>, TezEdgeProperty>();
    private final Map<BaseWork, VertexType> workVertexTypeMap = new HashMap<BaseWork, VertexType>();
    private static final String MR_JAR_PROPERTY = "tmpjars";

    public TezWork(String queryId) {
        this(queryId, null);
    }

    public TezWork(String queryId, Configuration conf) {
        String queryName;
        this.dagId = queryId + ":" + counter.getAndIncrement();
        String string = queryName = conf != null ? DagUtils.getUserSpecifiedDagName(conf) : null;
        if (queryName == null) {
            queryName = this.dagId;
        }
        this.queryName = queryName;
    }

    @Explain(displayName="DagName")
    public String getName() {
        return this.queryName;
    }

    @Explain(displayName="DagId")
    public String getDagId() {
        return this.dagId;
    }

    @Explain(displayName="Vertices", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, BaseWork> getWorkMap() {
        LinkedHashMap<String, BaseWork> result = new LinkedHashMap<String, BaseWork>();
        for (BaseWork w : this.getAllWork()) {
            result.put(w.getName(), w);
        }
        return result;
    }

    public List<BaseWork> getAllWork() {
        LinkedList<BaseWork> result = new LinkedList<BaseWork>();
        HashSet<BaseWork> seen = new HashSet<BaseWork>();
        for (BaseWork leaf : this.leaves) {
            this.visit(leaf, seen, result);
        }
        return result;
    }

    public Collection<BaseWork> getAllWorkUnsorted() {
        return this.workGraph.keySet();
    }

    private void visit(BaseWork child, Set<BaseWork> seen, List<BaseWork> result) {
        if (seen.contains(child)) {
            return;
        }
        seen.add(child);
        for (BaseWork parent : this.getParents(child)) {
            if (seen.contains(parent)) continue;
            this.visit(parent, seen, result);
        }
        result.add(child);
    }

    public void addAll(Collection<BaseWork> c) {
        for (BaseWork w : c) {
            this.add(w);
        }
    }

    public void addAll(BaseWork[] bws) {
        for (BaseWork w : bws) {
            this.add(w);
        }
    }

    public void add(BaseWork w) {
        if (this.workGraph.containsKey(w)) {
            return;
        }
        this.workGraph.put(w, new LinkedList());
        this.invertedWorkGraph.put(w, new LinkedList());
        this.roots.add(w);
        this.leaves.add(w);
    }

    public void disconnect(BaseWork a, BaseWork b) {
        this.workGraph.get(a).remove(b);
        this.invertedWorkGraph.get(b).remove(a);
        if (this.getParents(b).isEmpty()) {
            this.roots.add(b);
        }
        if (this.getChildren(a).isEmpty()) {
            this.leaves.add(a);
        }
    }

    public Set<BaseWork> getRoots() {
        return new HashSet<BaseWork>(this.roots);
    }

    public Set<BaseWork> getLeaves() {
        return new HashSet<BaseWork>(this.leaves);
    }

    public List<BaseWork> getParents(BaseWork work) {
        assert (this.invertedWorkGraph.containsKey(work) && this.invertedWorkGraph.get(work) != null);
        return new LinkedList<BaseWork>((Collection)this.invertedWorkGraph.get(work));
    }

    public List<BaseWork> getChildren(BaseWork work) {
        assert (this.workGraph.containsKey(work) && this.workGraph.get(work) != null);
        return new LinkedList<BaseWork>((Collection)this.workGraph.get(work));
    }

    public void remove(BaseWork work) {
        if (!this.workGraph.containsKey(work)) {
            return;
        }
        List<BaseWork> children = this.getChildren(work);
        List<BaseWork> parents = this.getParents(work);
        for (BaseWork w : children) {
            this.invertedWorkGraph.get(w).remove(work);
            if (this.invertedWorkGraph.get(w).size() != 0) continue;
            this.roots.add(w);
        }
        for (BaseWork w : parents) {
            this.workGraph.get(w).remove(work);
            if (this.workGraph.get(w).size() != 0) continue;
            this.leaves.add(w);
        }
        this.roots.remove(work);
        this.leaves.remove(work);
        this.workGraph.remove(work);
        this.invertedWorkGraph.remove(work);
    }

    public TezEdgeProperty.EdgeType getEdgeType(BaseWork a, BaseWork b) {
        return this.edgeProperties.get(new ImmutablePair((Object)a, (Object)b)).getEdgeType();
    }

    public TezEdgeProperty getEdgeProperty(BaseWork a, BaseWork b) {
        return this.edgeProperties.get(new ImmutablePair((Object)a, (Object)b));
    }

    @Explain(displayName="Edges", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public Map<String, List<Dependency>> getDependencyMap() {
        LinkedHashMap<String, List<Dependency>> result = new LinkedHashMap<String, List<Dependency>>();
        for (Map.Entry<BaseWork, List<BaseWork>> entry : this.invertedWorkGraph.entrySet()) {
            LinkedList<Dependency> dependencies = new LinkedList<Dependency>();
            for (BaseWork d : entry.getValue()) {
                Dependency dependency = new Dependency();
                dependency.w = d;
                dependency.type = this.getEdgeType(d, entry.getKey());
                dependencies.add(dependency);
            }
            if (dependencies.isEmpty()) continue;
            Collections.sort(dependencies);
            result.put(entry.getKey().getName(), dependencies);
        }
        return result;
    }

    public String[] configureJobConfAndExtractJars(JobConf jobConf) {
        String[] oldTmpJars = jobConf.getStrings(MR_JAR_PROPERTY);
        jobConf.setStrings(MR_JAR_PROPERTY, new String[0]);
        for (BaseWork work : this.workGraph.keySet()) {
            work.configureJobConf(jobConf);
        }
        String[] newTmpJars = jobConf.getStrings(MR_JAR_PROPERTY);
        if (oldTmpJars != null || newTmpJars != null) {
            String[] finalTmpJars;
            if (oldTmpJars == null || oldTmpJars.length == 0) {
                finalTmpJars = newTmpJars;
            } else if (newTmpJars == null || newTmpJars.length == 0) {
                finalTmpJars = oldTmpJars;
            } else {
                finalTmpJars = new String[oldTmpJars.length + newTmpJars.length];
                System.arraycopy(oldTmpJars, 0, finalTmpJars, 0, oldTmpJars.length);
                System.arraycopy(newTmpJars, 0, finalTmpJars, oldTmpJars.length, newTmpJars.length);
            }
            jobConf.setStrings(MR_JAR_PROPERTY, finalTmpJars);
            return finalTmpJars;
        }
        return newTmpJars;
    }

    public void connect(BaseWork a, BaseWork b, TezEdgeProperty edgeProp) {
        this.workGraph.get(a).add(b);
        this.invertedWorkGraph.get(b).add(a);
        this.roots.remove(b);
        this.leaves.remove(a);
        ImmutablePair workPair = new ImmutablePair((Object)a, (Object)b);
        this.edgeProperties.put((Pair<BaseWork, BaseWork>)workPair, edgeProp);
    }

    public void setVertexType(BaseWork w, VertexType incomingVertexType) {
        VertexType vertexType = this.workVertexTypeMap.get(w);
        if (vertexType == null) {
            vertexType = VertexType.AUTO_INITIALIZED_EDGES;
        }
        switch (vertexType) {
            case INITIALIZED_EDGES: {
                if (incomingVertexType != VertexType.MULTI_INPUT_UNINITIALIZED_EDGES) break;
                vertexType = VertexType.MULTI_INPUT_INITIALIZED_EDGES;
                break;
            }
            case MULTI_INPUT_INITIALIZED_EDGES: {
                break;
            }
            case MULTI_INPUT_UNINITIALIZED_EDGES: {
                if (incomingVertexType != VertexType.INITIALIZED_EDGES) break;
                vertexType = VertexType.MULTI_INPUT_INITIALIZED_EDGES;
                break;
            }
            case AUTO_INITIALIZED_EDGES: {
                vertexType = incomingVertexType;
                break;
            }
        }
        this.workVertexTypeMap.put(w, vertexType);
    }

    public VertexType getVertexType(BaseWork w) {
        return this.workVertexTypeMap.get(w);
    }

    public boolean getLlapMode() {
        for (BaseWork work : this.getAllWork()) {
            if (!work.getLlapMode()) continue;
            return true;
        }
        return false;
    }

    public class Dependency
    implements Serializable,
    Comparable<Dependency> {
        public BaseWork w;
        public TezEdgeProperty.EdgeType type;

        @Explain(displayName="Name")
        public String getName() {
            return this.w.getName();
        }

        @Explain(displayName="Type")
        public String getType() {
            return this.type.toString();
        }

        @Override
        public int compareTo(Dependency o) {
            int compare = this.getName().compareTo(o.getName());
            if (compare == 0) {
                compare = this.getType().compareTo(o.getType());
            }
            return compare;
        }
    }

    public static enum VertexType {
        AUTO_INITIALIZED_EDGES,
        INITIALIZED_EDGES,
        MULTI_INPUT_INITIALIZED_EDGES,
        MULTI_INPUT_UNINITIALIZED_EDGES;


        public static boolean isCustomInputType(VertexType vertex) {
            return vertex != null && vertex != AUTO_INITIALIZED_EDGES;
        }
    }
}

