/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRexUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HivePreFilteringRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger((String)HivePreFilteringRule.class.getName());
    private static final Set<SqlKind> COMPARISON = EnumSet.of(SqlKind.EQUALS, new SqlKind[]{SqlKind.GREATER_THAN_OR_EQUAL, SqlKind.LESS_THAN_OR_EQUAL, SqlKind.GREATER_THAN, SqlKind.LESS_THAN, SqlKind.NOT_EQUALS});
    private final RelFactories.FilterFactory filterFactory = HiveRelFactories.HIVE_FILTER_FACTORY;
    private final int maxCNFNodeCount;

    public HivePreFilteringRule(int maxCNFNodeCount) {
        super(HivePreFilteringRule.operand(Filter.class, (RelOptRuleOperand)HivePreFilteringRule.operand(RelNode.class, (RelOptRuleOperandChildren)HivePreFilteringRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        this.maxCNFNodeCount = maxCNFNodeCount;
    }

    public boolean matches(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        RelNode filterChild = call.rel(1);
        if (filterChild instanceof TableScan) {
            return false;
        }
        HiveRulesRegistry registry = (HiveRulesRegistry)call.getPlanner().getContext().unwrap(HiveRulesRegistry.class);
        return registry == null || !registry.getVisited(this).contains(filter);
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        HiveRulesRegistry registry = (HiveRulesRegistry)call.getPlanner().getContext().unwrap(HiveRulesRegistry.class);
        if (registry != null) {
            registry.registerVisited(this, (RelNode)filter);
        }
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        RexNode topFilterCondition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)filter.getCondition());
        List<Object> operandsToPushDown = new ArrayList();
        ArrayList<RexNode> deterministicExprs = new ArrayList<RexNode>();
        ArrayList<RexNode> nonDeterministicExprs = new ArrayList<RexNode>();
        switch (topFilterCondition.getKind()) {
            case AND: {
                ImmutableList operands = RexUtil.flattenAnd((Iterable)((RexCall)topFilterCondition).getOperands());
                HashSet<String> operandsToPushDownDigest = new HashSet<String>();
                List<RexNode> extractedCommonOperands = null;
                for (RexNode operand : operands) {
                    if (operand.getKind() == SqlKind.OR) {
                        extractedCommonOperands = HivePreFilteringRule.extractCommonOperands(rexBuilder, operand, this.maxCNFNodeCount);
                        for (RexNode extractedExpr : extractedCommonOperands) {
                            if (!operandsToPushDownDigest.add(extractedExpr.toString())) continue;
                            operandsToPushDown.add(extractedExpr);
                        }
                    }
                    if (HiveCalciteUtil.isDeterministic(operand)) {
                        deterministicExprs.add(operand);
                        continue;
                    }
                    nonDeterministicExprs.add(operand);
                }
                if (nonDeterministicExprs.size() <= 0) break;
                for (RexNode expr : deterministicExprs) {
                    if (operandsToPushDownDigest.contains(expr.toString())) continue;
                    operandsToPushDown.add(expr);
                    operandsToPushDownDigest.add(expr.toString());
                }
                topFilterCondition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)RexUtil.composeConjunction((RexBuilder)rexBuilder, nonDeterministicExprs, (boolean)false));
                break;
            }
            case OR: {
                operandsToPushDown = HivePreFilteringRule.extractCommonOperands(rexBuilder, topFilterCondition, this.maxCNFNodeCount);
                break;
            }
            default: {
                return;
            }
        }
        if (operandsToPushDown.isEmpty()) {
            return;
        }
        ImmutableList<RexNode> newConjuncts = HiveCalciteUtil.getPredsNotPushedAlready(filter.getInput(), operandsToPushDown);
        RexNode newPredicate = RexUtil.composeConjunction((RexBuilder)rexBuilder, newConjuncts, (boolean)false);
        if (newPredicate.isAlwaysTrue()) {
            return;
        }
        RexNode newChildFilterCondition = RexUtil.pullFactors((RexBuilder)rexBuilder, (RexNode)newPredicate);
        RelNode newChildFilter = this.filterFactory.createFilter(filter.getInput(), newChildFilterCondition);
        RelNode newTopFilter = this.filterFactory.createFilter(newChildFilter, topFilterCondition);
        if (registry != null) {
            registry.registerVisited(this, newChildFilter);
            registry.registerVisited(this, newTopFilter);
        }
        call.transformTo(newTopFilter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<RexNode> extractCommonOperands(RexBuilder rexBuilder, RexNode condition, int maxCNFNodeCount) {
        assert (condition.getKind() == SqlKind.OR);
        LinkedHashMultimap reductionCondition = LinkedHashMultimap.create();
        HashSet refsInAllOperands = null;
        ImmutableList operands = RexUtil.flattenOr((Iterable)((RexCall)condition).getOperands());
        for (int i = 0; i < operands.size(); ++i) {
            RexNode operand = (RexNode)operands.get(i);
            RexNode operandCNF = HiveRexUtil.toCnf(rexBuilder, maxCNFNodeCount, operand);
            List conjunctions = RelOptUtil.conjunctions((RexNode)operandCNF);
            HashSet refsInCurrentOperand = Sets.newHashSet();
            for (RexNode conjunction : conjunctions) {
                if (!(conjunction instanceof RexCall) || !HiveCalciteUtil.isDeterministic(conjunction)) {
                    return new ArrayList<RexNode>();
                }
                RexCall conjCall = (RexCall)conjunction;
                RexNode ref = null;
                if (COMPARISON.contains(conjCall.getOperator().getKind())) {
                    if (conjCall.operands.get(0) instanceof RexInputRef && conjCall.operands.get(1) instanceof RexLiteral) {
                        ref = (RexNode)conjCall.operands.get(0);
                    } else {
                        if (!(conjCall.operands.get(1) instanceof RexInputRef) || !(conjCall.operands.get(0) instanceof RexLiteral)) return new ArrayList<RexNode>();
                        ref = (RexNode)conjCall.operands.get(1);
                    }
                } else if (conjCall.getOperator().getKind().equals((Object)SqlKind.IN)) {
                    ref = (RexNode)conjCall.operands.get(0);
                } else {
                    if (!conjCall.getOperator().getKind().equals((Object)SqlKind.BETWEEN)) return new ArrayList<RexNode>();
                    ref = (RexNode)conjCall.operands.get(1);
                }
                String stringRef = ref.toString();
                reductionCondition.put((Object)stringRef, (Object)conjCall);
                refsInCurrentOperand.add(stringRef);
            }
            refsInAllOperands = i == 0 ? refsInCurrentOperand : Sets.intersection((Set)refsInAllOperands, (Set)refsInCurrentOperand);
            if (!refsInAllOperands.isEmpty()) continue;
            return new ArrayList<RexNode>();
        }
        ArrayList<RexNode> commonOperands = new ArrayList<RexNode>();
        for (String ref : refsInAllOperands) {
            commonOperands.add(RexUtil.composeDisjunction((RexBuilder)rexBuilder, (Iterable)reductionCondition.get((Object)ref), (boolean)false));
        }
        return commonOperands;
    }
}

