/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.read;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.parquet.convert.DataWritableRecordConverter;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.StringUtils;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class DataWritableReadSupport
extends ReadSupport<ArrayWritable> {
    public static final String HIVE_TABLE_AS_PARQUET_SCHEMA = "HIVE_TABLE_SCHEMA";
    public static final String PARQUET_COLUMN_INDEX_ACCESS = "parquet.column.index.access";
    private TypeInfo hiveTypeInfo;

    private static List<String> getColumnNames(String columns) {
        return (List)VirtualColumn.removeVirtualColumns(StringUtils.getStringCollection((String)columns));
    }

    private static List<TypeInfo> getColumnTypes(String types) {
        return TypeInfoUtils.getTypeInfosFromTypeString((String)types);
    }

    private static Type getFieldTypeIgnoreCase(GroupType groupType, String fieldName) {
        for (Type type : groupType.getFields()) {
            if (!type.getName().equalsIgnoreCase(fieldName)) continue;
            return type;
        }
        return null;
    }

    private static List<Type> getProjectedGroupFields(GroupType schema, List<String> colNames, List<TypeInfo> colTypes) {
        ArrayList<Type> schemaTypes = new ArrayList<Type>();
        ListIterator<String> columnIterator = colNames.listIterator();
        while (columnIterator.hasNext()) {
            TypeInfo colType = colTypes.get(columnIterator.nextIndex());
            String colName = columnIterator.next();
            Type fieldType = DataWritableReadSupport.getFieldTypeIgnoreCase(schema, colName);
            if (fieldType == null) {
                schemaTypes.add((Type)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named(colName));
                continue;
            }
            schemaTypes.add(DataWritableReadSupport.getProjectedType(colType, fieldType));
        }
        return schemaTypes;
    }

    private static Type getProjectedType(TypeInfo colType, Type fieldType) {
        switch (colType.getCategory()) {
            case STRUCT: {
                List<Type> groupFields = DataWritableReadSupport.getProjectedGroupFields(fieldType.asGroupType(), ((StructTypeInfo)colType).getAllStructFieldNames(), ((StructTypeInfo)colType).getAllStructFieldTypeInfos());
                Type[] typesArray = groupFields.toArray(new Type[0]);
                return (Type)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)fieldType.getRepetition()).addFields(typesArray)).named(fieldType.getName());
            }
            case LIST: {
                Object subFieldType;
                TypeInfo elemType = ((ListTypeInfo)colType).getListElementTypeInfo();
                if (elemType.getCategory() != ObjectInspector.Category.STRUCT || (subFieldType = fieldType.asGroupType().getType(0)).isPrimitive()) break;
                String subFieldName = subFieldType.getName();
                Text name = new Text(subFieldName);
                subFieldType = name.equals((Object)ParquetHiveSerDe.ARRAY) || name.equals((Object)ParquetHiveSerDe.LIST) ? new GroupType(Type.Repetition.REPEATED, subFieldName, new Type[]{DataWritableReadSupport.getProjectedType(elemType, subFieldType.asGroupType().getType(0))}) : DataWritableReadSupport.getProjectedType(elemType, subFieldType);
                return (Type)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup((Type.Repetition)Type.Repetition.OPTIONAL).as(OriginalType.LIST)).addFields(new Type[]{subFieldType})).named(fieldType.getName());
            }
        }
        return fieldType;
    }

    private static MessageType getSchemaByName(MessageType schema, List<String> colNames, List<TypeInfo> colTypes) {
        List<Type> projectedFields = DataWritableReadSupport.getProjectedGroupFields((GroupType)schema, colNames, colTypes);
        Type[] typesArray = projectedFields.toArray(new Type[0]);
        return (MessageType)((Types.GroupBuilder)Types.buildMessage().addFields(typesArray)).named(schema.getName());
    }

    private static MessageType getSchemaByIndex(MessageType schema, List<String> colNames, List<Integer> colIndexes) {
        ArrayList<Object> schemaTypes = new ArrayList<Object>();
        for (Integer i : colIndexes) {
            if (i >= colNames.size()) continue;
            if (i < schema.getFieldCount()) {
                schemaTypes.add(schema.getType(i.intValue()));
                continue;
            }
            schemaTypes.add(Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("_mask_" + colNames.get(i)));
        }
        return new MessageType(schema.getName(), schemaTypes);
    }

    public ReadSupport.ReadContext init(InitContext context) {
        Configuration configuration = context.getConfiguration();
        MessageType fileSchema = context.getFileSchema();
        String columnNames = configuration.get("columns");
        HashMap<String, String> contextMetadata = new HashMap<String, String>();
        boolean indexAccess = configuration.getBoolean(PARQUET_COLUMN_INDEX_ACCESS, false);
        if (columnNames != null) {
            MessageType tableSchema;
            List<String> columnNamesList = DataWritableReadSupport.getColumnNames(columnNames);
            String columnTypes = configuration.get("columns.types");
            List<TypeInfo> columnTypesList = DataWritableReadSupport.getColumnTypes(columnTypes);
            if (indexAccess) {
                ArrayList<Integer> indexSequence = new ArrayList<Integer>();
                for (int i = 0; i < columnNamesList.size(); ++i) {
                    indexSequence.add(i);
                }
                tableSchema = DataWritableReadSupport.getSchemaByIndex(fileSchema, columnNamesList, indexSequence);
            } else {
                tableSchema = DataWritableReadSupport.getSchemaByName(fileSchema, columnNamesList, columnTypesList);
            }
            contextMetadata.put(HIVE_TABLE_AS_PARQUET_SCHEMA, tableSchema.toString());
            contextMetadata.put(PARQUET_COLUMN_INDEX_ACCESS, String.valueOf(indexAccess));
            this.hiveTypeInfo = TypeInfoFactory.getStructTypeInfo(columnNamesList, columnTypesList);
            List indexColumnsWanted = ColumnProjectionUtils.getReadColumnIDs((Configuration)configuration);
            if (!ColumnProjectionUtils.isReadAllColumns((Configuration)configuration) && !indexColumnsWanted.isEmpty()) {
                MessageType requestedSchemaByUser = DataWritableReadSupport.getSchemaByIndex(tableSchema, columnNamesList, indexColumnsWanted);
                return new ReadSupport.ReadContext(requestedSchemaByUser, contextMetadata);
            }
            return new ReadSupport.ReadContext(tableSchema, contextMetadata);
        }
        contextMetadata.put(HIVE_TABLE_AS_PARQUET_SCHEMA, fileSchema.toString());
        return new ReadSupport.ReadContext(fileSchema, contextMetadata);
    }

    public RecordMaterializer<ArrayWritable> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        Map metadata = readContext.getReadSupportMetadata();
        if (metadata == null) {
            throw new IllegalStateException("ReadContext not initialized properly. Don't know the Hive Schema.");
        }
        String key = HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION.varname;
        if (!metadata.containsKey(key)) {
            metadata.put(key, String.valueOf(HiveConf.getBoolVar((Configuration)configuration, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PARQUET_TIMESTAMP_SKIP_CONVERSION)));
        }
        return new DataWritableRecordConverter((GroupType)readContext.getRequestedSchema(), metadata, this.hiveTypeInfo);
    }
}

