/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates;

import java.util.ArrayList;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.LongWritable;

@Description(name="var_samp", value="_FUNC_(x) - Returns the sample variance of a set of numbers (vectorized, double)")
public class VectorUDAFVarSampTimestamp
extends VectorAggregateExpression {
    private static final long serialVersionUID = 1L;
    private VectorExpression inputExpression;
    private transient LongWritable resultCount;
    private transient DoubleWritable resultSum;
    private transient DoubleWritable resultVariance;
    private transient Object[] partialResult = new Object[3];
    private transient ObjectInspector soi;

    public VectorUDAFVarSampTimestamp(VectorExpression inputExpression) {
        this();
        this.inputExpression = inputExpression;
    }

    public VectorUDAFVarSampTimestamp() {
        this.resultCount = new LongWritable();
        this.resultSum = new DoubleWritable();
        this.resultVariance = new DoubleWritable();
        this.partialResult[0] = this.resultCount;
        this.partialResult[1] = this.resultSum;
        this.partialResult[2] = this.resultVariance;
        this.initPartialResultInspector();
    }

    private void initPartialResultInspector() {
        ArrayList<Object> foi = new ArrayList<Object>();
        foi.add(PrimitiveObjectInspectorFactory.writableLongObjectInspector);
        foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        foi.add(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        ArrayList<String> fname = new ArrayList<String>();
        fname.add("count");
        fname.add("sum");
        fname.add("variance");
        this.soi = ObjectInspectorFactory.getStandardStructObjectInspector(fname, foi);
    }

    private Aggregation getCurrentAggregationBuffer(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, int row) {
        VectorAggregationBufferRow mySet = aggregationBufferSets[row];
        Aggregation myagg = (Aggregation)mySet.getAggregationBuffer(aggregateIndex);
        return myagg;
    }

    @Override
    public void aggregateInputSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls || !inputColVector.isNull[0]) {
                this.iterateRepeatingNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColVector.getDouble(0), batchSize);
            }
        } else if (!batch.selectedInUse && inputColVector.noNulls) {
            this.iterateNoSelectionNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColVector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColVector, batchSize, inputColVector.isNull);
        } else if (inputColVector.noNulls) {
            this.iterateSelectionNoNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColVector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNullsWithAggregationSelection(aggregationBufferSets, aggregateIndex, inputColVector, batchSize, inputColVector.isNull, batch.selected);
        }
    }

    private void iterateRepeatingNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, double value, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            if (myagg.isNull) {
                myagg.init();
            }
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
            if (myagg.count <= 1L) continue;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    private void iterateSelectionHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, j);
            int i = selected[j];
            if (isNull[i]) continue;
            double value = inputColVector.getDouble(i);
            if (myagg.isNull) {
                myagg.init();
            }
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
            if (myagg.count <= 1L) continue;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    private void iterateSelectionNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, TimestampColumnVector inputColVector, int batchSize, int[] selected) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            double value = inputColVector.getDouble(selected[i]);
            if (myagg.isNull) {
                myagg.init();
            }
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
            if (myagg.count <= 1L) continue;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    private void iterateNoSelectionHasNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            double value = inputColVector.getDouble(i);
            if (myagg.isNull) {
                myagg.init();
            }
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
            if (myagg.count <= 1L) continue;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    private void iterateNoSelectionNoNullsWithAggregationSelection(VectorAggregationBufferRow[] aggregationBufferSets, int aggregateIndex, TimestampColumnVector inputColVector, int batchSize) {
        for (int i = 0; i < batchSize; ++i) {
            Aggregation myagg = this.getCurrentAggregationBuffer(aggregationBufferSets, aggregateIndex, i);
            if (myagg.isNull) {
                myagg.init();
            }
            double value = inputColVector.getDouble(i);
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
            if (myagg.count <= 1L) continue;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    @Override
    public void aggregateInput(VectorAggregateExpression.AggregationBuffer agg, VectorizedRowBatch batch) throws HiveException {
        this.inputExpression.evaluate(batch);
        TimestampColumnVector inputColVector = (TimestampColumnVector)batch.cols[this.inputExpression.getOutputColumn()];
        int batchSize = batch.size;
        if (batchSize == 0) {
            return;
        }
        Aggregation myagg = (Aggregation)agg;
        if (inputColVector.isRepeating) {
            if (inputColVector.noNulls) {
                this.iterateRepeatingNoNulls(myagg, inputColVector.getDouble(0), batchSize);
            }
        } else if (!batch.selectedInUse && inputColVector.noNulls) {
            this.iterateNoSelectionNoNulls(myagg, inputColVector, batchSize);
        } else if (!batch.selectedInUse) {
            this.iterateNoSelectionHasNulls(myagg, inputColVector, batchSize, inputColVector.isNull);
        } else if (inputColVector.noNulls) {
            this.iterateSelectionNoNulls(myagg, inputColVector, batchSize, batch.selected);
        } else {
            this.iterateSelectionHasNulls(myagg, inputColVector, batchSize, inputColVector.isNull, batch.selected);
        }
    }

    private void iterateRepeatingNoNulls(Aggregation myagg, double value, int batchSize) {
        if (myagg.isNull) {
            myagg.init();
        }
        Aggregation aggregation = myagg;
        aggregation.sum = aggregation.sum + value;
        aggregation = myagg;
        aggregation.count = aggregation.count + 1L;
        if (myagg.count > 1L) {
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
        for (int i = 1; i < batchSize; ++i) {
            Aggregation aggregation3 = myagg;
            aggregation3.sum = aggregation3.sum + value;
            aggregation3 = myagg;
            aggregation3.count = aggregation3.count + 1L;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation4 = myagg;
            aggregation4.variance = aggregation4.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    private void iterateSelectionHasNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull, int[] selected) {
        for (int j = 0; j < batchSize; ++j) {
            int i = selected[j];
            if (isNull[i]) continue;
            double value = inputColVector.getDouble(i);
            if (myagg.isNull) {
                myagg.init();
            }
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
            if (myagg.count <= 1L) continue;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    private void iterateSelectionNoNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize, int[] selected) {
        if (myagg.isNull) {
            myagg.init();
        }
        double value = inputColVector.getDouble(selected[0]);
        Aggregation aggregation = myagg;
        aggregation.sum = aggregation.sum + value;
        aggregation = myagg;
        aggregation.count = aggregation.count + 1L;
        if (myagg.count > 1L) {
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
        for (int i = 1; i < batchSize; ++i) {
            value = inputColVector.getDouble(selected[i]);
            Aggregation aggregation3 = myagg;
            aggregation3.sum = aggregation3.sum + value;
            aggregation3 = myagg;
            aggregation3.count = aggregation3.count + 1L;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation4 = myagg;
            aggregation4.variance = aggregation4.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    private void iterateNoSelectionHasNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize, boolean[] isNull) {
        for (int i = 0; i < batchSize; ++i) {
            if (isNull[i]) continue;
            double value = inputColVector.getDouble(i);
            if (myagg.isNull) {
                myagg.init();
            }
            Aggregation aggregation = myagg;
            aggregation.sum = aggregation.sum + value;
            aggregation = myagg;
            aggregation.count = aggregation.count + 1L;
            if (myagg.count <= 1L) continue;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    private void iterateNoSelectionNoNulls(Aggregation myagg, TimestampColumnVector inputColVector, int batchSize) {
        if (myagg.isNull) {
            myagg.init();
        }
        double value = inputColVector.getDouble(0);
        Aggregation aggregation = myagg;
        aggregation.sum = aggregation.sum + value;
        aggregation = myagg;
        aggregation.count = aggregation.count + 1L;
        if (myagg.count > 1L) {
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation2 = myagg;
            aggregation2.variance = aggregation2.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
        for (int i = 1; i < batchSize; ++i) {
            value = inputColVector.getDouble(i);
            Aggregation aggregation3 = myagg;
            aggregation3.sum = aggregation3.sum + value;
            aggregation3 = myagg;
            aggregation3.count = aggregation3.count + 1L;
            double t = (double)myagg.count * value - myagg.sum;
            Aggregation aggregation4 = myagg;
            aggregation4.variance = aggregation4.variance + t * t / ((double)myagg.count * (double)(myagg.count - 1L));
        }
    }

    @Override
    public VectorAggregateExpression.AggregationBuffer getNewAggregationBuffer() throws HiveException {
        return new Aggregation();
    }

    @Override
    public void reset(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myAgg = (Aggregation)agg;
        myAgg.reset();
    }

    @Override
    public Object evaluateOutput(VectorAggregateExpression.AggregationBuffer agg) throws HiveException {
        Aggregation myagg = (Aggregation)agg;
        if (myagg.isNull) {
            return null;
        }
        assert (0L < myagg.count);
        this.resultCount.set(myagg.count);
        this.resultSum.set(myagg.sum);
        this.resultVariance.set(myagg.variance);
        return this.partialResult;
    }

    @Override
    public ObjectInspector getOutputObjectInspector() {
        return this.soi;
    }

    @Override
    public int getAggregationBufferFixedSize() {
        JavaDataModel model = JavaDataModel.get();
        return JavaDataModel.alignUp((int)(model.object() + model.primitive2() * 3 + model.primitive1()), (int)model.memoryAlign());
    }

    @Override
    public void init(AggregationDesc desc) throws HiveException {
    }

    public VectorExpression getInputExpression() {
        return this.inputExpression;
    }

    public void setInputExpression(VectorExpression inputExpression) {
        this.inputExpression = inputExpression;
    }

    private static final class Aggregation
    implements VectorAggregateExpression.AggregationBuffer {
        private static final long serialVersionUID = 1L;
        private transient double sum;
        private transient long count;
        private transient double variance;
        private transient boolean isNull = true;

        private Aggregation() {
        }

        public void init() {
            this.isNull = false;
            this.sum = 0.0;
            this.count = 0L;
            this.variance = 0.0;
        }

        @Override
        public int getVariableSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reset() {
            this.isNull = true;
            this.sum = 0.0;
            this.count = 0L;
            this.variance = 0.0;
        }
    }
}

