/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.parquet.output;

import org.pentaho.big.data.kettle.plugins.formats.BaseFormatOutputField;
import org.pentaho.big.data.kettle.plugins.formats.parquet.output.ParquetOutputMetaBase;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.hadoop.shim.api.format.IParquetOutputField;
import org.pentaho.hadoop.shim.api.format.ParquetSpec;

public class ParquetOutputField
extends BaseFormatOutputField
implements IParquetOutputField {
    public ParquetSpec.DataType getParquetType() {
        for (ParquetSpec.DataType type : ParquetSpec.DataType.values()) {
            if (type.getId() != this.formatType) continue;
            return type;
        }
        return null;
    }

    public void setFormatType(ParquetSpec.DataType formatType) {
        this.formatType = formatType.getId();
    }

    @Injection(name="FIELD_PARQUET_TYPE", group="FIELDS")
    public void setFormatType(String typeName) {
        try {
            this.setFormatType(Integer.parseInt(typeName));
        }
        catch (NumberFormatException nfe) {
            for (ParquetSpec.DataType parquetType : ParquetSpec.DataType.values()) {
                if (!parquetType.getName().equals(typeName)) continue;
                this.formatType = parquetType.getId();
                break;
            }
        }
    }

    @Injection(name="FIELD_TYPE", group="FIELDS")
    @Deprecated
    public void setPentahoType(String typeName) {
        for (int i = 0; i < ValueMetaInterface.typeCodes.length; ++i) {
            if (!typeName.equals(ValueMetaInterface.typeCodes[i])) continue;
            this.setFormatType(ParquetOutputMetaBase.convertToParquetType(i));
            break;
        }
    }

    public boolean isDecimalType() {
        return this.getParquetType().equals((Object)ParquetSpec.DataType.DECIMAL);
    }

    @Override
    public void setPrecision(String precision) {
        if (precision == null || precision.trim().length() == 0) {
            this.precision = this.isDecimalType() ? 20 : 0;
        } else {
            this.precision = Integer.valueOf(precision);
            if (this.precision <= 0 && this.isDecimalType()) {
                this.precision = 20;
            }
        }
    }

    @Override
    public void setScale(String scale) {
        if (scale == null || scale.trim().length() == 0) {
            this.scale = this.isDecimalType() ? 0 : 0;
        } else {
            this.scale = Integer.valueOf(scale);
            if (this.scale < 0) {
                this.scale = this.isDecimalType() ? 0 : 0;
            }
        }
    }
}

