/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.avro.output;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputField;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class AvroOutputMetaBase
extends BaseStepMeta
implements StepMetaInterface,
ResolvableResource {
    private static final Class<?> PKG = AvroOutputMetaBase.class;
    @Injection(name="FILENAME")
    private String filename;
    @InjectionDeep
    private List<AvroOutputField> outputFields = new ArrayList<AvroOutputField>();
    @Injection(name="OPTIONS_DATE_IN_FILE_NAME")
    protected boolean dateInFileName = false;
    @Injection(name="OPTIONS_TIME_IN_FILE_NAME")
    protected boolean timeInFileName = false;
    @Injection(name="OPTIONS_DATE_FORMAT")
    protected String dateTimeFormat = "";
    @Injection(name="OPTIONS_COMPRESSION")
    protected String compressionType;
    @Injection(name="SCHEMA_FILENAME")
    protected String schemaFilename;
    @Injection(name="SCHEMA_NAMESPACE")
    protected String namespace;
    @Injection(name="SCHEMA_RECORD_NAME")
    protected String recordName;
    @Injection(name="SCHEMA_DOC_VALUE")
    protected String docValue;
    @Injection(name="OVERRIDE_OUTPUT")
    protected boolean overrideOutput;

    public void setDefault() {
    }

    public boolean isOverrideOutput() {
        return this.overrideOutput;
    }

    public void setOverrideOutput(boolean overrideOutput) {
        this.overrideOutput = overrideOutput;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<AvroOutputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<AvroOutputField> outputFields) {
        this.outputFields = outputFields;
    }

    public boolean isDateInFileName() {
        return this.dateInFileName;
    }

    public void setDateInFileName(boolean dateInFileName) {
        this.dateInFileName = dateInFileName;
    }

    public boolean isTimeInFileName() {
        return this.timeInFileName;
    }

    public void setTimeInFileName(boolean timeInFileName) {
        this.timeInFileName = timeInFileName;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, metaStore);
    }

    private void readData(Node stepnode, IMetaStore metastore) throws KettleXMLException {
        try {
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            String override = XMLHandler.getTagValue((Node)stepnode, (String)"overrideOutput");
            this.overrideOutput = override != null && override.length() > 0 ? "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"overrideOutput")) : true;
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            ArrayList<AvroOutputField> avroOutputFields = new ArrayList<AvroOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                AvroOutputField outputField = new AvroOutputField();
                outputField.setFormatFieldName(XMLHandler.getTagValue((Node)fnode, (String)"path"));
                outputField.setPentahoFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                outputField.setFormatType(this.convertToAvroType(XMLHandler.getTagValue((Node)fnode, (String)"type")));
                outputField.setPrecision(XMLHandler.getTagValue((Node)fnode, (String)"precision"));
                outputField.setScale(XMLHandler.getTagValue((Node)fnode, (String)"scale"));
                outputField.setAllowNull(XMLHandler.getTagValue((Node)fnode, (String)"nullable"));
                outputField.setDefaultValue(XMLHandler.getTagValue((Node)fnode, (String)"default"));
                avroOutputFields.add(outputField);
            }
            this.outputFields = avroOutputFields;
            this.compressionType = XMLHandler.getTagValue((Node)stepnode, (String)"compression");
            this.dateTimeFormat = XMLHandler.getTagValue((Node)stepnode, (String)"dateTimeFormat");
            this.dateInFileName = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dateInFileName"));
            this.timeInFileName = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"timeInFileName"));
            this.schemaFilename = XMLHandler.getTagValue((Node)stepnode, (String)"schemaFilename");
            this.namespace = XMLHandler.getTagValue((Node)stepnode, (String)"namespace");
            this.docValue = XMLHandler.getTagValue((Node)stepnode, (String)"docValue");
            this.recordName = XMLHandler.getTagValue((Node)stepnode, (String)"recordName");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(800);
        String INDENT = "    ";
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"overrideOutput", (boolean)this.overrideOutput));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.size(); ++i) {
            AvroOutputField field = this.outputFields.get(i);
            if (field.getPentahoFieldName() == null || field.getPentahoFieldName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)field.getFormatFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getPentahoFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (int)field.getAvroType().getId()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"scale", (int)field.getScale()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullable", (boolean)field.getAllowNull()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"default", (String)field.getDefaultValue()));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"compression", (String)this.compressionType));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dateTimeFormat", (String)this.dateTimeFormat));
        retval.append("    ").append(XMLHandler.addTagValue((String)"dateInFileName", (boolean)this.dateInFileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"timeInFileName", (boolean)this.timeInFileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schemaFilename", (String)this.schemaFilename));
        retval.append("    ").append(XMLHandler.addTagValue((String)"namespace", (String)this.namespace));
        retval.append("    ").append(XMLHandler.addTagValue((String)"docValue", (String)this.docValue));
        retval.append("    ").append(XMLHandler.addTagValue((String)"recordName", (String)this.recordName));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.filename = rep.getStepAttributeString(id_step, "filename");
            String override = rep.getStepAttributeString(id_step, "overrideOutput");
            this.overrideOutput = override != null && override.length() > 0 ? rep.getStepAttributeBoolean(id_step, "overrideOutput") : true;
            int nrfields = rep.countNrStepAttributes(id_step, "type");
            ArrayList<AvroOutputField> avroOutputFields = new ArrayList<AvroOutputField>();
            for (int i = 0; i < nrfields; ++i) {
                AvroOutputField outputField = new AvroOutputField();
                outputField.setFormatFieldName(rep.getStepAttributeString(id_step, i, "path"));
                outputField.setPentahoFieldName(rep.getStepAttributeString(id_step, i, "name"));
                outputField.setFormatType(this.convertToAvroType(rep.getStepAttributeString(id_step, i, "type")));
                outputField.setPrecision(rep.getStepAttributeString(id_step, i, "precision"));
                outputField.setScale(rep.getStepAttributeString(id_step, i, "scale"));
                outputField.setAllowNull(rep.getStepAttributeString(id_step, i, "nullable"));
                outputField.setDefaultValue(rep.getStepAttributeString(id_step, i, "default"));
                avroOutputFields.add(outputField);
            }
            this.outputFields = avroOutputFields;
            this.compressionType = rep.getStepAttributeString(id_step, "compression");
            this.dateTimeFormat = rep.getStepAttributeString(id_step, "dateTimeFormat");
            this.dateInFileName = rep.getStepAttributeBoolean(id_step, "dateInFileName");
            this.timeInFileName = rep.getStepAttributeBoolean(id_step, "timeInFileName");
            this.schemaFilename = rep.getStepAttributeString(id_step, "schemaFilename");
            this.namespace = rep.getStepAttributeString(id_step, "namespace");
            this.docValue = rep.getStepAttributeString(id_step, "docValue");
            this.recordName = rep.getStepAttributeString(id_step, "recordName");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.filename);
            rep.saveStepAttribute(id_transformation, id_step, "overrideOutput", this.overrideOutput);
            for (int i = 0; i < this.outputFields.size(); ++i) {
                AvroOutputField field = this.outputFields.get(i);
                rep.saveStepAttribute(id_transformation, id_step, i, "path", field.getFormatFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "name", field.getPentahoFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "type", (long)field.getAvroType().getId());
                rep.saveStepAttribute(id_transformation, id_step, i, "precision", (long)field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "scale", (long)field.getScale());
                rep.saveStepAttribute(id_transformation, id_step, i, "nullable", Boolean.toString(field.getAllowNull()));
                rep.saveStepAttribute(id_transformation, id_step, i, "default", field.getDefaultValue());
            }
            super.saveRep(rep, metaStore, id_transformation, id_step);
            rep.saveStepAttribute(id_transformation, id_step, "compression", this.compressionType);
            rep.saveStepAttribute(id_transformation, id_step, "dateTimeFormat", this.dateTimeFormat);
            rep.saveStepAttribute(id_transformation, id_step, "dateInFileName", this.dateInFileName);
            rep.saveStepAttribute(id_transformation, id_step, "timeInFileName", this.timeInFileName);
            rep.saveStepAttribute(id_transformation, id_step, "schemaFilename", this.schemaFilename);
            rep.saveStepAttribute(id_transformation, id_step, "namespace", this.namespace);
            rep.saveStepAttribute(id_transformation, id_step, "docValue", this.docValue);
            rep.saveStepAttribute(id_transformation, id_step, "recordName", this.recordName);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void resolve() {
        FileObject fileObject;
        if (this.filename != null && !this.filename.isEmpty()) {
            try {
                String realFileName = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.filename);
                fileObject = KettleVFS.getFileObject((String)realFileName);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.filename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.schemaFilename != null && !this.schemaFilename.isEmpty()) {
            try {
                String realSchemaFilename = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.schemaFilename);
                fileObject = KettleVFS.getFileObject((String)realSchemaFilename);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.schemaFilename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getSchemaFilename() {
        return this.schemaFilename;
    }

    public void setSchemaFilename(String schemaFilename) {
        this.schemaFilename = schemaFilename;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getRecordName() {
        return this.recordName;
    }

    public void setRecordName(String recordName) {
        this.recordName = recordName;
    }

    public String getDocValue() {
        return this.docValue;
    }

    public void setDocValue(String docValue) {
        this.docValue = docValue;
    }

    public String getCompressionType() {
        return StringUtil.isVariable((String)this.compressionType) ? this.compressionType : this.getCompressionType(null).toString();
    }

    public void setCompressionType(String value) {
        this.compressionType = StringUtil.isVariable((String)value) ? value : AvroOutputMetaBase.parseFromToString(value, CompressionType.values(), CompressionType.NONE).name();
    }

    public CompressionType getCompressionType(VariableSpace vspace) {
        return this.parseReplace(this.compressionType, vspace, str -> this.findCompressionType((String)str), CompressionType.NONE);
    }

    private CompressionType findCompressionType(String str) {
        try {
            return CompressionType.valueOf(str);
        }
        catch (Throwable th) {
            return AvroOutputMetaBase.parseFromToString(str, CompressionType.values(), CompressionType.NONE);
        }
    }

    public String[] getCompressionTypes() {
        return AvroOutputMetaBase.getStrings(CompressionType.values());
    }

    protected static <T> String[] getStrings(T[] objects) {
        String[] names = new String[objects.length];
        int i = 0;
        for (T obj : objects) {
            names[i++] = obj.toString();
        }
        return names;
    }

    protected static <T> T parseFromToString(String str, T[] values, T defaultValue) {
        if (!Utils.isEmpty((CharSequence)str)) {
            for (T type : values) {
                if (!str.equalsIgnoreCase(type.toString())) continue;
                return type;
            }
        }
        return defaultValue;
    }

    private <T> T parseReplace(String value, VariableSpace vspace, Function<String, T> parser, T defaultValue) {
        String replaced;
        String string = replaced = vspace != null ? vspace.environmentSubstitute(value) : value;
        if (!Utils.isEmpty((CharSequence)replaced)) {
            try {
                return parser.apply(replaced);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static String convertToAvroType(int pdiType) {
        switch (pdiType) {
            case 2: 
            case 10: {
                return AvroSpec.DataType.STRING.getName();
            }
            case 9: {
                return AvroSpec.DataType.TIMESTAMP_MILLIS.getName();
            }
            case 8: {
                return AvroSpec.DataType.BYTES.getName();
            }
            case 6: {
                return AvroSpec.DataType.DECIMAL.getName();
            }
            case 4: {
                return AvroSpec.DataType.BOOLEAN.getName();
            }
            case 3: {
                return AvroSpec.DataType.DATE.getName();
            }
            case 5: {
                return AvroSpec.DataType.LONG.getName();
            }
            case 1: {
                return AvroSpec.DataType.DOUBLE.getName();
            }
        }
        return AvroSpec.DataType.NULL.getName();
    }

    private String convertToAvroType(String type) {
        int pdiType = ValueMetaFactory.getIdForValueMeta((String)type);
        if (pdiType > 0) {
            return AvroOutputMetaBase.convertToAvroType(pdiType);
        }
        return type;
    }

    public String constructOutputFilename(String file) {
        String extension;
        int endIndex = file.lastIndexOf(".");
        String name = endIndex > 0 ? file.substring(0, endIndex) : file;
        String string = extension = endIndex <= 0 ? "" : file.substring(endIndex, file.length());
        if (this.dateTimeFormat != null && !this.dateTimeFormat.isEmpty()) {
            String dateTimeFormatPattern = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.dateTimeFormat);
            name = name + new SimpleDateFormat(dateTimeFormatPattern).format(new Date());
        } else {
            if (this.dateInFileName) {
                name = name + '_' + new SimpleDateFormat("yyyyMMdd").format(new Date());
            }
            if (this.timeInFileName) {
                name = name + '_' + new SimpleDateFormat("HHmmss").format(new Date());
            }
        }
        return name + extension;
    }

    private static String getMsg(String key) {
        return BaseMessages.getString(PKG, (String)key, (String[])new String[0]);
    }

    static /* synthetic */ String access$000(String x0) {
        return AvroOutputMetaBase.getMsg(x0);
    }

    protected static class FieldNames {
        public static final String COMPRESSION = "compression";
        public static final String SCHEMA_FILENAME = "schemaFilename";
        public static final String OVERRIDE_OUTPUT = "overrideOutput";
        public static final String RECORD_NAME = "recordName";
        public static final String DOC_VALUE = "docValue";
        public static final String NAMESPACE = "namespace";
        public static final String DATE_IN_FILE_NAME = "dateInFileName";
        public static final String TIME_IN_FILE_NAME = "timeInFileName";
        public static final String DATE_FORMAT = "dateTimeFormat";

        protected FieldNames() {
        }
    }

    public static enum CompressionType {
        NONE(AvroOutputMetaBase.access$000("AvroOutput.CompressionType.NONE")),
        DEFLATE(AvroOutputMetaBase.access$000("AvroOutput.CompressionType.DEFLATE")),
        SNAPPY(AvroOutputMetaBase.access$000("AvroOutput.CompressionType.SNAPPY"));

        private final String name;

        private CompressionType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

