/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.avro.output;

import org.pentaho.big.data.kettle.plugins.formats.BaseFormatOutputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputMetaBase;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.hadoop.shim.api.format.IAvroOutputField;

public class AvroOutputField
extends BaseFormatOutputField
implements IAvroOutputField {
    public AvroSpec.DataType getAvroType() {
        return AvroSpec.DataType.values()[this.formatType];
    }

    public void setFormatType(AvroSpec.DataType avroType) {
        this.formatType = avroType.getId();
    }

    @Override
    public void setFormatType(int formatType) {
        for (AvroSpec.DataType avroType : AvroSpec.DataType.values()) {
            if (avroType.getId() != formatType) continue;
            this.formatType = formatType;
        }
    }

    @Injection(name="FIELD_AVRO_TYPE", group="FIELDS")
    public void setFormatType(String typeName) {
        try {
            this.setFormatType(Integer.parseInt(typeName));
        }
        catch (NumberFormatException nfe) {
            for (AvroSpec.DataType avroType : AvroSpec.DataType.values()) {
                if (!avroType.getName().equals(typeName)) continue;
                this.formatType = avroType.getId();
                break;
            }
        }
    }

    @Injection(name="FIELD_TYPE", group="FIELDS")
    @Deprecated
    public void setPentahoType(String typeName) {
        for (int i = 0; i < ValueMetaInterface.typeCodes.length; ++i) {
            if (!typeName.equals(ValueMetaInterface.typeCodes[i])) continue;
            this.setFormatType(AvroOutputMetaBase.convertToAvroType(i));
            break;
        }
    }

    public boolean isDecimalType() {
        return this.getAvroType().equals((Object)AvroSpec.DataType.DECIMAL);
    }

    @Override
    public void setPrecision(String precision) {
        if (precision == null || precision.trim().length() == 0) {
            this.precision = this.isDecimalType() ? 10 : 0;
        } else {
            this.precision = Integer.valueOf(precision);
            if (this.precision <= 0 && this.isDecimalType()) {
                this.precision = 10;
            }
        }
    }

    @Override
    public void setScale(String scale) {
        if (scale == null || scale.trim().length() == 0) {
            this.scale = this.isDecimalType() ? 0 : 0;
        } else {
            this.scale = Integer.valueOf(scale);
            if (this.scale < 0) {
                this.scale = this.isDecimalType() ? 0 : 0;
            }
        }
    }
}

