/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.avro.input;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.big.data.kettle.plugins.formats.FormatInputFile;
import org.pentaho.big.data.kettle.plugins.formats.avro.input.AvroInputField;
import org.pentaho.big.data.kettle.plugins.formats.avro.output.AvroOutputMetaBase;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.vfs.AliasedFileObject;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.steps.file.BaseFileInputAdditionalField;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.di.workarounds.ResolvableResource;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public abstract class AvroInputMetaBase
extends BaseFileInputMeta<BaseFileInputAdditionalField, FormatInputFile, AvroInputField>
implements ResolvableResource {
    private static final Class<?> PKG = AvroOutputMetaBase.class;
    @Injection(name="AVRO_FILENAME")
    private String filename;
    @Injection(name="SCHEMA_FILENAME")
    protected String schemaFilename;
    @Injection(name="STREAM_FIELDNAME")
    protected String inputStreamFieldName;
    @Injection(name="USE_INPUT_STREAM")
    protected boolean useFieldAsInputStream;

    public AvroInputMetaBase() {
        this.additionalOutputFields = new BaseFileInputAdditionalField();
        this.inputFiles = new FormatInputFile();
        this.inputFields = new AvroInputField[0];
    }

    public void allocateFiles(int nrFiles) {
        ((FormatInputFile)this.inputFiles).environment = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileName = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileMask = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).excludeFileMask = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).fileRequired = new String[nrFiles];
        ((FormatInputFile)this.inputFiles).includeSubFolders = new String[nrFiles];
    }

    public String getEncoding() {
        return null;
    }

    public void setDefault() {
        this.allocateFiles(0);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public AvroInputField[] getInputFields() {
        return (AvroInputField[])this.inputFields;
    }

    public void setInputFields(AvroInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public void setInputFields(List<AvroInputField> inputFields) {
        this.inputFields = new AvroInputField[inputFields.size()];
        this.inputFields = inputFields.toArray(this.inputFields);
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, metaStore);
    }

    private void readData(Node stepnode, IMetaStore metastore) throws KettleXMLException {
        try {
            String passFileds = XMLHandler.getTagValue((Node)stepnode, (String)"passing_through_fields") == null ? "false" : XMLHandler.getTagValue((Node)stepnode, (String)"passing_through_fields");
            ((FormatInputFile)this.inputFiles).passingThruFields = ValueMetaBase.convertStringToBoolean((String)passFileds);
            this.filename = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.useFieldAsInputStream = ValueMetaBase.convertStringToBoolean((String)(XMLHandler.getTagValue((Node)stepnode, (String)"useStreamField") == null ? "false" : XMLHandler.getTagValue((Node)stepnode, (String)"useStreamField")));
            this.inputStreamFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"stream_fieldname");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.inputFields = new AvroInputField[nrfields];
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                AvroInputField inputField = new AvroInputField();
                inputField.setFormatFieldName(XMLHandler.getTagValue((Node)fnode, (String)"path"));
                inputField.setPentahoFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                inputField.setPentahoType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                inputField.setAvroType(XMLHandler.getTagValue((Node)fnode, (String)"avro_type"));
                String stringFormat = XMLHandler.getTagValue((Node)fnode, (String)"format");
                inputField.setStringFormat(stringFormat == null ? "" : stringFormat);
                ((AvroInputField[])this.inputFields)[i] = inputField;
            }
            this.schemaFilename = XMLHandler.getTagValue((Node)stepnode, (String)"schemaFilename");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(800);
        String INDENT = "    ";
        ((FormatInputFile)this.inputFiles).normalizeAllocation(((FormatInputFile)this.inputFiles).fileName.length);
        retval.append("    ").append(XMLHandler.addTagValue((String)"passing_through_fields", (boolean)((FormatInputFile)this.inputFiles).passingThruFields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.getFilename()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"useStreamField", (boolean)this.isUseFieldAsInputStream()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"stream_fieldname", (String)this.getInputStreamFieldName()));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < ((AvroInputField[])this.inputFields).length; ++i) {
            AvroInputField field = ((AvroInputField[])this.inputFields)[i];
            if (field.getPentahoFieldName() == null || field.getPentahoFieldName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"path", (String)field.getAvroFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getPentahoFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            if (field.getAvroType() != null) {
                retval.append("        ").append(XMLHandler.addTagValue((String)"avro_type", (String)field.getAvroType().getName()));
            }
            if (field.getStringFormat() != null) {
                retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getStringFormat()));
            }
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)"schemaFilename", (String)this.getSchemaFilename()));
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            ((FormatInputFile)this.inputFiles).passingThruFields = rep.getStepAttributeBoolean(id_step, "passing_through_fields");
            this.filename = rep.getStepAttributeString(id_step, "filename");
            this.useFieldAsInputStream = rep.getStepAttributeBoolean(id_step, "useStreamField");
            this.inputStreamFieldName = rep.getStepAttributeString(id_step, "stream_fieldname");
            int nrfields = rep.countNrStepAttributes(id_step, "type");
            this.inputFields = new AvroInputField[nrfields];
            for (int i = 0; i < nrfields; ++i) {
                AvroInputField inputField = new AvroInputField();
                inputField.setFormatFieldName(rep.getStepAttributeString(id_step, i, "path"));
                inputField.setPentahoFieldName(rep.getStepAttributeString(id_step, i, "name"));
                inputField.setPentahoType(rep.getStepAttributeString(id_step, i, "type"));
                inputField.setAvroType(rep.getStepAttributeString(id_step, i, "avro_type"));
                String stringFormat = rep.getStepAttributeString(id_step, i, "format");
                inputField.setStringFormat(stringFormat == null ? "" : stringFormat);
                ((AvroInputField[])this.inputFields)[i] = inputField;
            }
            this.schemaFilename = rep.getStepAttributeString(id_step, "schemaFilename");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "passing_through_fields", ((FormatInputFile)this.inputFiles).passingThruFields);
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.getFilename());
            rep.saveStepAttribute(id_transformation, id_step, "useStreamField", this.isUseFieldAsInputStream());
            rep.saveStepAttribute(id_transformation, id_step, "stream_fieldname", this.getInputStreamFieldName());
            for (int i = 0; i < ((AvroInputField[])this.inputFields).length; ++i) {
                AvroInputField field = ((AvroInputField[])this.inputFields)[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "path", field.getAvroFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "name", field.getPentahoFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "type", field.getTypeDesc());
                if (field.getAvroType() != null) {
                    rep.saveStepAttribute(id_transformation, id_step, i, "avro_type", field.getAvroType().getName());
                }
                if (field.getStringFormat() == null) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "format", field.getStringFormat());
            }
            super.saveRep(rep, metaStore, id_transformation, id_step);
            rep.saveStepAttribute(id_transformation, id_step, "schemaFilename", this.getSchemaFilename());
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void resolve() {
        FileObject fileObject;
        if (this.filename != null && !this.filename.isEmpty()) {
            try {
                String realFileName = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.filename);
                fileObject = KettleVFS.getFileObject((String)realFileName);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.filename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.schemaFilename != null && !this.schemaFilename.isEmpty()) {
            try {
                String realSchemaFilename = this.getParentStepMeta().getParentTransMeta().environmentSubstitute(this.schemaFilename);
                fileObject = KettleVFS.getFileObject((String)realSchemaFilename);
                if (AliasedFileObject.isAliasedFile((FileObject)fileObject)) {
                    this.schemaFilename = ((AliasedFileObject)fileObject).getOriginalURIString();
                }
            }
            catch (KettleFileException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getSchemaFilename() {
        return this.schemaFilename;
    }

    public void setSchemaFilename(String schemaFilename) {
        this.schemaFilename = schemaFilename;
    }

    public String getInputStreamFieldName() {
        return this.inputStreamFieldName;
    }

    public void setInputStreamFieldName(String inputStreamFieldName) {
        this.inputStreamFieldName = inputStreamFieldName;
    }

    public boolean isUseFieldAsInputStream() {
        return this.useFieldAsInputStream;
    }

    public void setUseFieldAsInputStream(boolean useFieldAsInputStream) {
        this.useFieldAsInputStream = useFieldAsInputStream;
    }
}

