/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.singlethreader;

import java.io.IOException;
import org.apache.commons.vfs2.FileObject;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderMeta;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ColumnsResizer;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.DialogHelper;
import org.pentaho.di.ui.util.DialogUtils;
import org.pentaho.di.ui.util.SwtSvgImageUtil;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class SingleThreaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SingleThreaderMeta.class;
    private SingleThreaderMeta singleThreaderMeta;
    private Label wlPath;
    private TextVar wPath;
    private Button wbBrowse;
    private TextVar wBatchSize;
    private TextVar wInjectStep;
    private Button wGetInjectStep;
    private TextVar wRetrieveStep;
    private Button wGetRetrieveStep;
    private TableView wParameters;
    private TransMeta mappingTransMeta = null;
    protected boolean transModified;
    private ModifyListener lsMod;
    private ObjectId referenceObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private Button wPassParams;
    private Button wbGetParams;
    private TextVar wBatchTime;

    public SingleThreaderDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.singleThreaderMeta = (SingleThreaderMeta)in;
        this.transModified = false;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.singleThreaderMeta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SingleThreaderDialog.this.singleThreaderMeta.setChanged();
            }
        };
        this.changed = this.singleThreaderMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, 0);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.width = 250;
        this.fdStepname.left = new FormAttachment(0, 0);
        this.fdStepname.top = new FormAttachment((Control)this.wlStepname, 5);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        this.wlPath = new Label((Composite)this.shell, 16384);
        this.props.setLook((Control)this.wlPath);
        this.wlPath.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Transformation.Label", (String[])new String[0]));
        FormData fdlTransformation = new FormData();
        fdlTransformation.left = new FormAttachment(0, 0);
        fdlTransformation.top = new FormAttachment((Control)spacer, 20);
        fdlTransformation.right = new FormAttachment(50, 0);
        this.wlPath.setLayoutData((Object)fdlTransformation);
        this.wPath = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPath);
        FormData fdTransformation = new FormData();
        fdTransformation.left = new FormAttachment(0, 0);
        fdTransformation.top = new FormAttachment((Control)this.wlPath, 5);
        fdTransformation.width = 350;
        this.wPath.setLayoutData(fdTransformation);
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.left = new FormAttachment((Control)this.wPath, 5);
        fdBrowse.top = new FormAttachment((Control)this.wlPath, Const.isOSX() ? 0 : 5);
        this.wbBrowse.setLayoutData((Object)fdBrowse);
        this.wbBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (SingleThreaderDialog.this.repository != null) {
                    SingleThreaderDialog.this.selectRepositoryTrans();
                } else {
                    SingleThreaderDialog.this.selectFileTrans(true);
                }
            }
        });
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wOptionsTab = new CTabItem(wTabFolder, 0);
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Options.Group.Label", (String[])new String[0]));
        Composite wOptions = new Composite((Composite)wTabFolder, 32);
        this.props.setLook((Control)wOptions);
        FormLayout specLayout = new FormLayout();
        specLayout.marginWidth = 15;
        specLayout.marginHeight = 15;
        wOptions.setLayout((Layout)specLayout);
        Label wlInjectStep = new Label(wOptions, 16384);
        wlInjectStep.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.InjectStep.Label", (String[])new String[0]));
        this.props.setLook((Control)wlInjectStep);
        FormData fdlInjectStep = new FormData();
        fdlInjectStep.top = new FormAttachment(0, 0);
        fdlInjectStep.left = new FormAttachment(0, 0);
        wlInjectStep.setLayoutData((Object)fdlInjectStep);
        this.wInjectStep = new TextVar((VariableSpace)this.transMeta, wOptions, 18436);
        this.props.setLook((Control)this.wInjectStep);
        this.wInjectStep.addModifyListener(this.lsMod);
        FormData fdInjectStep = new FormData();
        fdInjectStep.width = 250;
        fdInjectStep.left = new FormAttachment(0, 0);
        fdInjectStep.top = new FormAttachment((Control)wlInjectStep, 5);
        this.wInjectStep.setLayoutData(fdInjectStep);
        this.wGetInjectStep = new Button(wOptions, 8);
        this.wGetInjectStep.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Button.Get", (String[])new String[0]));
        FormData fdGetInjectStep = new FormData();
        fdGetInjectStep.top = new FormAttachment((Control)wlInjectStep, Const.isOSX() ? 0 : 5);
        fdGetInjectStep.left = new FormAttachment((Control)this.wInjectStep, 5);
        this.wGetInjectStep.setLayoutData((Object)fdGetInjectStep);
        this.wGetInjectStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    SingleThreaderDialog.this.loadTransformation();
                    String stepname = SingleThreaderDialog.this.mappingTransMeta == null ? "" : Const.NVL((String)SingleThreaderDialog.getInjectorStep(SingleThreaderDialog.this.mappingTransMeta), (String)"");
                    SingleThreaderDialog.this.wInjectStep.setText(stepname);
                }
                catch (Exception e) {
                    new ErrorDialog(SingleThreaderDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
                }
            }
        });
        Label wlRetrieveStep = new Label(wOptions, 16384);
        wlRetrieveStep.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.RetrieveStep.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRetrieveStep);
        FormData fdlRetrieveStep = new FormData();
        fdlRetrieveStep.top = new FormAttachment((Control)this.wInjectStep, 10);
        fdlRetrieveStep.left = new FormAttachment(0, 0);
        wlRetrieveStep.setLayoutData((Object)fdlRetrieveStep);
        this.wRetrieveStep = new TextVar((VariableSpace)this.transMeta, wOptions, 18436);
        this.props.setLook((Control)this.wRetrieveStep);
        this.wRetrieveStep.addModifyListener(this.lsMod);
        FormData fdRetrieveStep = new FormData();
        fdRetrieveStep.width = 250;
        fdRetrieveStep.left = new FormAttachment(0, 0);
        fdRetrieveStep.top = new FormAttachment((Control)wlRetrieveStep, 5);
        this.wRetrieveStep.setLayoutData(fdRetrieveStep);
        this.wGetRetrieveStep = new Button(wOptions, 8);
        this.wGetRetrieveStep.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Button.Get", (String[])new String[0]));
        FormData fdGetRetrieveStep = new FormData();
        fdGetRetrieveStep.top = new FormAttachment((Control)wlRetrieveStep, Const.isOSX() ? 0 : 5);
        fdGetRetrieveStep.left = new FormAttachment((Control)this.wRetrieveStep, 5);
        this.wGetRetrieveStep.setLayoutData((Object)fdGetRetrieveStep);
        this.wGetRetrieveStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    SingleThreaderDialog.this.loadTransformation();
                    if (SingleThreaderDialog.this.mappingTransMeta != null) {
                        String[] stepNames = SingleThreaderDialog.this.mappingTransMeta.getStepNames();
                        EnterSelectionDialog d = new EnterSelectionDialog(SingleThreaderDialog.this.shell, stepNames, BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.SelectStep.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.SelectStep.Message", (String[])new String[0]));
                        String step = d.open();
                        if (step != null) {
                            SingleThreaderDialog.this.wRetrieveStep.setText(step);
                        }
                    }
                }
                catch (Exception e) {
                    new ErrorDialog(SingleThreaderDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
                }
            }
        });
        Label wlBatchSize = new Label(wOptions, 16384);
        wlBatchSize.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.BatchSize.Label", (String[])new String[0]));
        this.props.setLook((Control)wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.top = new FormAttachment((Control)this.wRetrieveStep, 10);
        fdlBatchSize.left = new FormAttachment(0, 0);
        wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar((VariableSpace)this.transMeta, wOptions, 18436);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(0, 0);
        fdBatchSize.top = new FormAttachment((Control)wlBatchSize, 5);
        this.wBatchSize.setLayoutData(fdBatchSize);
        Label wlBatchTime = new Label(wOptions, 16384);
        wlBatchTime.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.BatchTime.Label", (String[])new String[0]));
        this.props.setLook((Control)wlBatchTime);
        FormData fdlBatchTime = new FormData();
        fdlBatchTime.top = new FormAttachment((Control)this.wBatchSize, 10);
        fdlBatchTime.left = new FormAttachment(0, 0);
        wlBatchTime.setLayoutData((Object)fdlBatchTime);
        this.wBatchTime = new TextVar((VariableSpace)this.transMeta, wOptions, 18436);
        this.wBatchTime.addModifyListener(this.lsMod);
        FormData fdBatchTime = new FormData();
        fdBatchTime.left = new FormAttachment(0, 0);
        fdBatchTime.top = new FormAttachment((Control)wlBatchTime, 5);
        this.wBatchTime.setLayoutData(fdBatchTime);
        wOptionsTab.setControl((Control)wOptions);
        FormData fdOptions = new FormData();
        fdOptions.left = new FormAttachment(0, 0);
        fdOptions.top = new FormAttachment(0, 0);
        fdOptions.right = new FormAttachment(100, 0);
        fdOptions.bottom = new FormAttachment(100, 0);
        wOptions.setLayoutData((Object)fdOptions);
        CTabItem wParametersTab = new CTabItem(wTabFolder, 0);
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Fields.Parameters.Label", (String[])new String[0]));
        FormLayout fieldLayout = new FormLayout();
        fieldLayout.marginWidth = 15;
        fieldLayout.marginHeight = 15;
        Composite wParameterComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wParameterComp);
        wParameterComp.setLayout((Layout)fieldLayout);
        this.wPassParams = new Button(wParameterComp, 32);
        this.props.setLook((Control)this.wPassParams);
        this.wPassParams.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.PassAllParameters.Label", (String[])new String[0]));
        FormData fdPassParams = new FormData();
        fdPassParams.left = new FormAttachment(0, 0);
        fdPassParams.top = new FormAttachment(0, 0);
        this.wPassParams.setLayoutData((Object)fdPassParams);
        this.wPassParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SingleThreaderDialog.this.changed = true;
            }
        });
        this.wbGetParams = new Button(wParameterComp, 8);
        this.wbGetParams.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.GetParameters.Button.Label", (String[])new String[0]));
        FormData fdGetParams = new FormData();
        fdGetParams.bottom = new FormAttachment(100, 0);
        fdGetParams.right = new FormAttachment(100, 0);
        this.wbGetParams.setLayoutData((Object)fdGetParams);
        this.wbGetParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SingleThreaderDialog.this.getParameters(null);
            }
        });
        int parameterRows = this.singleThreaderMeta.getParameters() != null ? this.singleThreaderMeta.getParameters().length : 0;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Parameters.Parameter.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Parameters.Value.Label", (String[])new String[0]), 1, false)};
        colinf[1].setUsingVariables(true);
        this.wParameters = new TableView((VariableSpace)this.transMeta, wParameterComp, 67586, colinf, parameterRows, false, this.lsMod, this.props, false);
        FormData fdParameters = new FormData();
        fdParameters.left = new FormAttachment(0, 0);
        fdParameters.top = new FormAttachment((Control)this.wPassParams, 10);
        fdParameters.right = new FormAttachment(100);
        fdParameters.bottom = new FormAttachment((Control)this.wbGetParams, -10);
        this.wParameters.setLayoutData(fdParameters);
        this.wParameters.getTable().addListener(11, (Listener)new ColumnsResizer(0, 50, 50));
        FormData fdParametersComp = new FormData();
        fdParametersComp.left = new FormAttachment(0, 0);
        fdParametersComp.top = new FormAttachment(0, 0);
        fdParametersComp.right = new FormAttachment(100, 0);
        fdParametersComp.bottom = new FormAttachment(100, 0);
        wParameterComp.setLayoutData((Object)fdParametersComp);
        wParameterComp.layout();
        wParametersTab.setControl((Control)wParameterComp);
        wTabFolder.setSelection(0);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdCancel = new FormData();
        fdCancel.right = new FormAttachment(100, 0);
        fdCancel.bottom = new FormAttachment(100, 0);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fdOk = new FormData();
        fdOk.right = new FormAttachment((Control)this.wCancel, -5);
        fdOk.bottom = new FormAttachment(100, 0);
        this.wOK.setLayoutData((Object)fdOk);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wPath, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SingleThreaderDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SingleThreaderDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SingleThreaderDialog.this.ok();
            }
        };
        this.wPath.addSelectionListener(this.lsDef);
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wBatchSize.addSelectionListener(this.lsDef);
        this.wBatchTime.addSelectionListener(this.lsDef);
        this.wInjectStep.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SingleThreaderDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.singleThreaderMeta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected Image getImage() {
        return SwtSvgImageUtil.getImage(this.shell.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader(), "MAP.svg", 32, 32);
    }

    private void selectRepositoryTrans() {
        RepositoryObject repositoryObject = DialogHelper.selectRepositoryObject("*.ktr", this.log);
        try {
            if (repositoryObject != null) {
                this.loadRepositoryTrans(repositoryObject.getName(), repositoryObject.getRepositoryDirectory());
                String path = DialogUtils.getPath(this.transMeta.getRepositoryDirectory().getPath(), this.mappingTransMeta.getRepositoryDirectory().getPath());
                String fullPath = (path.equals("/") ? "/" : path + "/") + this.mappingTransMeta.getName();
                this.wPath.setText(fullPath);
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorSelectingObject.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorSelectingObject.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void loadRepositoryTrans(String transName, RepositoryDirectoryInterface repdir) throws KettleException {
        this.mappingTransMeta = this.repository.loadTransformation(this.transMeta.environmentSubstitute(transName), repdir, null, true, null);
        this.mappingTransMeta.clearChanged();
    }

    private void selectFileTrans(boolean useVfs) {
        String curFile = this.transMeta.environmentSubstitute(this.wPath.getText());
        if (useVfs) {
            FileObject root = null;
            String parentFolder = null;
            try {
                parentFolder = KettleVFS.getFileObject((String)this.transMeta.environmentSubstitute(this.transMeta.getFilename())).getParent().toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                root = KettleVFS.getFileObject((String)(curFile != null ? curFile : Const.getUserHomeDirectory()));
                VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(root.getParent(), root);
                FileObject file = vfsFileChooser.open(this.shell, null, Const.STRING_TRANS_FILTER_EXT, Const.getTransformationFilterNames(), 0);
                if (file == null) {
                    return;
                }
                String fileName = file.getName().toString();
                if (fileName != null) {
                    this.loadFileTrans(fileName);
                    if (parentFolder != null && fileName.startsWith(parentFolder)) {
                        fileName = fileName.replace(parentFolder, "${Internal.Entry.Current.Directory}");
                    }
                    this.wPath.setText(fileName);
                    this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                }
            }
            catch (IOException | KettleException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), (Exception)e);
            }
        }
    }

    private void loadFileTrans(String fname) throws KettleException {
        this.mappingTransMeta = new TransMeta(this.transMeta.environmentSubstitute(fname));
        this.mappingTransMeta.clearChanged();
    }

    private void loadTransformation() throws KettleException {
        String filename = this.wPath.getText();
        this.specificationMethod = this.repository != null ? ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME : ObjectLocationSpecificationMethod.FILENAME;
        switch (this.specificationMethod) {
            case FILENAME: {
                if (Utils.isEmpty((CharSequence)filename)) {
                    return;
                }
                if (!filename.endsWith(".ktr")) {
                    filename = filename + ".ktr";
                    this.wPath.setText(filename);
                }
                this.loadFileTrans(filename);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                if (Utils.isEmpty((CharSequence)filename)) {
                    return;
                }
                if (filename.endsWith(".ktr")) {
                    filename = filename.replace(".ktr", "");
                    this.wPath.setText(filename);
                }
                String realTransname = transPath = this.transMeta.environmentSubstitute(filename);
                String realDirectory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    realTransname = transPath.substring(index + 1);
                    realDirectory = transPath.substring(0, index);
                }
                if (Utils.isEmpty((CharSequence)realDirectory) || Utils.isEmpty((CharSequence)realTransname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
                }
                RepositoryDirectoryInterface repdir = this.repository.findDirectory(realDirectory);
                if (repdir == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.UnableToFindRepositoryDirectory)", (String[])new String[0]));
                }
                this.loadRepositoryTrans(realTransname, repdir);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.mappingTransMeta = this.repository.loadTransformation(this.referenceObjectId, null);
                this.mappingTransMeta.clearChanged();
                break;
            }
        }
        this.wInjectStep.setText(SingleThreaderDialog.getInjectorStep(this.mappingTransMeta));
    }

    public void getData() {
        this.specificationMethod = this.singleThreaderMeta.getSpecificationMethod();
        switch (this.specificationMethod) {
            case FILENAME: {
                this.wPath.setText(Const.NVL((String)this.singleThreaderMeta.getFileName(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                String fullPath = Const.NVL((String)this.singleThreaderMeta.getDirectoryPath(), (String)"") + "/" + Const.NVL((String)this.singleThreaderMeta.getTransName(), (String)"");
                this.wPath.setText(fullPath);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.referenceObjectId = this.singleThreaderMeta.getTransObjectId();
                this.getByReferenceData(this.referenceObjectId);
                break;
            }
        }
        this.wBatchSize.setText(Const.NVL((String)this.singleThreaderMeta.getBatchSize(), (String)""));
        this.wBatchTime.setText(Const.NVL((String)this.singleThreaderMeta.getBatchTime(), (String)""));
        this.wInjectStep.setText(Const.NVL((String)this.singleThreaderMeta.getInjectStep(), (String)""));
        this.wRetrieveStep.setText(Const.NVL((String)this.singleThreaderMeta.getRetrieveStep(), (String)""));
        if (this.singleThreaderMeta.getParameters() != null) {
            for (int i = 0; i < this.singleThreaderMeta.getParameters().length; ++i) {
                TableItem ti = this.wParameters.table.getItem(i);
                if (Utils.isEmpty((CharSequence)this.singleThreaderMeta.getParameters()[i])) continue;
                ti.setText(1, Const.NVL((String)this.singleThreaderMeta.getParameters()[i], (String)""));
                ti.setText(2, Const.NVL((String)this.singleThreaderMeta.getParameterValues()[i], (String)""));
            }
            this.wParameters.removeEmptyRows();
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        this.wPassParams.setSelection(this.singleThreaderMeta.isPassingAllParameters());
        try {
            this.loadTransformation();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void getByReferenceData(ObjectId transObjectId) {
        try {
            RepositoryObject transInf = this.repository.getObjectInformation(transObjectId, RepositoryObjectType.TRANSFORMATION);
            String path = DialogUtils.getPath(this.transMeta.getRepositoryDirectory().getPath(), transInf.getRepositoryDirectory().getPath());
            String fullPath = Const.NVL((String)path, (String)"") + "/" + Const.NVL((String)transInf.getName(), (String)"");
            this.wPath.setText(fullPath);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JobEntryTransDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEntryTransDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    public static String getInjectorStep(TransMeta mappingTransMeta) {
        for (StepMeta stepMeta : mappingTransMeta.getSteps()) {
            if (!stepMeta.getStepID().equals("Injector") && !stepMeta.getStepID().equals("MappingInput")) continue;
            return stepMeta.getName();
        }
        return "";
    }

    private void cancel() {
        this.stepname = null;
        this.singleThreaderMeta.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(SingleThreaderMeta meta) throws KettleException {
        int i;
        this.loadTransformation();
        this.specificationMethod = this.repository != null ? ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME : ObjectLocationSpecificationMethod.FILENAME;
        meta.setSpecificationMethod(this.specificationMethod);
        switch (this.specificationMethod) {
            case FILENAME: {
                meta.setFileName(this.wPath.getText());
                meta.setDirectoryPath(null);
                meta.setTransName(null);
                meta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                String transPath;
                String transName = transPath = this.wPath.getText();
                String directory = "";
                int index = transPath.lastIndexOf("/");
                if (index != -1) {
                    transName = transPath.substring(index + 1);
                    directory = transPath.substring(0, index);
                }
                meta.setDirectoryPath(directory);
                meta.setTransName(transName);
                meta.setFileName(null);
                meta.setTransObjectId(null);
                break;
            }
        }
        meta.setBatchSize(this.wBatchSize.getText());
        meta.setBatchTime(this.wBatchTime.getText());
        meta.setInjectStep(this.wInjectStep.getText());
        meta.setRetrieveStep(this.wRetrieveStep.getText());
        int nritems = this.wParameters.nrNonEmpty();
        int nr = 0;
        for (i = 0; i < nritems; ++i) {
            String param = this.wParameters.getNonEmpty(i).getText(1);
            if (Utils.isEmpty((CharSequence)param)) continue;
            ++nr;
        }
        meta.setParameters(new String[nr]);
        meta.setParameterValues(new String[nr]);
        nr = 0;
        for (i = 0; i < nritems; ++i) {
            String param = this.wParameters.getNonEmpty(i).getText(1);
            String value = this.wParameters.getNonEmpty(i).getText(2);
            meta.getParameters()[nr] = param;
            meta.getParameterValues()[nr] = Const.NVL((String)value, (String)"");
            ++nr;
        }
        meta.setPassingAllParameters(this.wPassParams.getSelection());
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        try {
            this.getInfo(this.singleThreaderMeta);
            this.loadTransformation();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorLoadingSpecifiedTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorLoadingSpecifiedTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    protected void getParameters(TransMeta mappingTransMeta) {
        try {
            if (mappingTransMeta == null) {
                SingleThreaderMeta jet = new SingleThreaderMeta();
                this.getInfo(jet);
                mappingTransMeta = SingleThreaderMeta.loadSingleThreadedTransMeta((SingleThreaderMeta)jet, (Repository)this.repository, (VariableSpace)this.transMeta);
            }
            String[] parameters = mappingTransMeta.listParameters();
            String[] existing = this.wParameters.getItems(1);
            for (int i = 0; i < parameters.length; ++i) {
                if (Const.indexOfString((String)parameters[i], (String[])existing) >= 0) continue;
                TableItem item = new TableItem(this.wParameters.table, 0);
                item.setText(1, parameters[i]);
            }
            this.wParameters.removeEmptyRows();
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.UnableToLoadTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.UnableToLoadTransformation.Message", (String[])new String[0]), e);
        }
    }
}

