/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.file.BaseFileInputMeta;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public abstract class BaseFileStepDialog<T extends BaseFileInputMeta<?, ?, ?>>
extends BaseStepDialog
implements StepDialogInterface {
    protected final Class<?> PKG = ((Object)((Object)this)).getClass();
    protected T input;
    protected ModifyListener lsMod;

    public BaseFileStepDialog(Shell parent, T in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseFileStepDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        this.createUI();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                BaseFileStepDialog.this.cancel();
            }
        });
        this.getData(this.input);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input, false);
        this.dispose();
    }

    protected abstract void createUI();

    protected abstract void getData(T var1);

    protected abstract void getInfo(T var1, boolean var2);

    public static class FD {
        private final Control control;
        private final FormData fd;

        public FD(Control control) {
            this.control = control;
            this.fd = new FormData();
        }

        public FD width(int width) {
            this.fd.width = width;
            return this;
        }

        public FD height(int height) {
            this.fd.height = height;
            return this;
        }

        public FD top(int numerator, int offset) {
            this.fd.top = new FormAttachment(numerator, offset);
            return this;
        }

        public FD top(Control control, int offset) {
            this.fd.top = new FormAttachment(control, offset);
            return this;
        }

        public FD bottom(int numerator, int offset) {
            this.fd.bottom = new FormAttachment(numerator, offset);
            return this;
        }

        public FD bottom(Control control, int offset) {
            this.fd.bottom = new FormAttachment(control, offset);
            return this;
        }

        public FD left(int numerator, int offset) {
            this.fd.left = new FormAttachment(numerator, offset);
            return this;
        }

        public FD left(Control control, int offset) {
            this.fd.left = new FormAttachment(control, offset);
            return this;
        }

        public FD right(int numerator, int offset) {
            this.fd.right = new FormAttachment(numerator, offset);
            return this;
        }

        public FD right(Control control, int offset) {
            this.fd.right = new FormAttachment(control, offset);
            return this;
        }

        public void apply() {
            this.control.setLayoutData((Object)this.fd);
        }
    }
}

