/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.trans;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.i18n.GlobalMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.di.ui.xul.KettleXulLoader;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.tags.SwtToolbarbutton;

public class TransGridDelegate
extends SpoonDelegate
implements XulEventHandler {
    private static Class<?> PKG = Spoon.class;
    private static final String XUL_FILE_TRANS_GRID_TOOLBAR = "ui/trans-grid-toolbar.xul";
    private static final int STEP_NUMBER_COLUMN = 0;
    private static final int STEP_NAME_COLUMN = 1;
    public static final long REFRESH_TIME = 100L;
    public static final long UPDATE_TIME_VIEW = 1000L;
    private TransGraph transGraph;
    private CTabItem transGridTab;
    private TableView transGridView;
    private boolean refresh_busy;
    private long lastUpdateView;
    private XulToolbar toolbar;
    private Composite transGridComposite;
    private boolean hideInactiveSteps;
    private boolean showSelectedSteps;

    public TransGridDelegate(Spoon spoon, TransGraph transGraph) {
        super(spoon);
        this.transGraph = transGraph;
        this.hideInactiveSteps = false;
    }

    public void showGridView() {
        if (this.transGridTab == null || this.transGridTab.isDisposed()) {
            this.addTransGrid();
        } else {
            this.transGridTab.dispose();
            this.transGraph.checkEmptyExtraView();
        }
    }

    public void addTransGrid() {
        if (this.transGraph.extraViewComposite == null || this.transGraph.extraViewComposite.isDisposed()) {
            this.transGraph.addExtraView();
        } else if (this.transGridTab != null && !this.transGridTab.isDisposed()) {
            this.transGraph.extraViewTabFolder.setSelection(this.transGridTab);
            return;
        }
        this.transGridTab = new CTabItem(this.transGraph.extraViewTabFolder, 0);
        this.transGridTab.setImage(GUIResource.getInstance().getImageShowGrid());
        this.transGridTab.setText(BaseMessages.getString(PKG, (String)"Spoon.TransGraph.GridTab.Name", (String[])new String[0]));
        this.transGridComposite = new Composite((Composite)this.transGraph.extraViewTabFolder, 0);
        this.transGridComposite.setLayout((Layout)new FormLayout());
        this.addToolBar();
        Control toolbarControl = (Control)this.toolbar.getManagedObject();
        toolbarControl.setLayoutData((Object)new FormData());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        toolbarControl.setLayoutData((Object)fd);
        toolbarControl.setParent(this.transGridComposite);
        String stepNameColumnName = BaseMessages.getString(PKG, (String)"TransLog.Column.Stepname", (String[])new String[0]);
        ValueMetaString valueMeta = new ValueMetaString(stepNameColumnName);
        valueMeta.setIgnoreWhitespace(true);
        ColumnInfo stepNameColumnInfo = new ColumnInfo(stepNameColumnName, 1, false, true);
        stepNameColumnInfo.setValueMeta((ValueMetaInterface)valueMeta);
        ColumnInfo[] colinf = new ColumnInfo[]{stepNameColumnInfo, new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Copynr", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Read", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Written", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Input", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Output", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Updated", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Rejected", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Errors", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Active", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Time", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.Speed", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"TransLog.Column.PriorityBufferSizes", (String[])new String[0]), 1, false, true)};
        colinf[1].setAllignement(131072);
        colinf[2].setAllignement(131072);
        colinf[3].setAllignement(131072);
        colinf[4].setAllignement(131072);
        colinf[5].setAllignement(131072);
        colinf[6].setAllignement(131072);
        colinf[7].setAllignement(131072);
        colinf[8].setAllignement(131072);
        colinf[9].setAllignement(16384);
        colinf[10].setAllignement(131072);
        colinf[11].setAllignement(131072);
        colinf[12].setAllignement(131072);
        this.transGridView = new TableView((VariableSpace)this.transGraph.getManagedObject(), this.transGridComposite, 67586, colinf, 1, true, null, this.spoon.props);
        FormData fdView = new FormData();
        fdView.left = new FormAttachment(0, 0);
        fdView.right = new FormAttachment(100, 0);
        fdView.top = new FormAttachment((Control)this.toolbar.getManagedObject(), 0);
        fdView.bottom = new FormAttachment(100, 0);
        this.transGridView.setLayoutData(fdView);
        final Timer tim = new Timer("TransGraph: " + this.transGraph.getMeta().getName());
        final AtomicBoolean busy = new AtomicBoolean(false);
        TimerTask timtask = new TimerTask(){

            @Override
            public void run() {
                if (!TransGridDelegate.this.spoon.getDisplay().isDisposed()) {
                    TransGridDelegate.this.spoon.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!busy.get()) {
                                busy.set(true);
                                TransGridDelegate.this.refreshView();
                                busy.set(false);
                            }
                        }
                    });
                }
            }
        };
        tim.schedule(timtask, 0L, 100L);
        this.transGridTab.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                tim.cancel();
            }
        });
        this.transGridTab.setControl((Control)this.transGridComposite);
        this.transGraph.extraViewTabFolder.setSelection(this.transGridTab);
    }

    private void addToolBar() {
        try {
            KettleXulLoader loader = new KettleXulLoader();
            loader.setSettingsManager(XulSpoonSettingsManager.getInstance());
            ResourceBundle bundle = GlobalMessages.getBundle((String)"org/pentaho/di/ui/spoon/messages/messages");
            XulDomContainer xulDomContainer = loader.loadXul(XUL_FILE_TRANS_GRID_TOOLBAR, bundle);
            xulDomContainer.addEventHandler((XulEventHandler)this);
            this.toolbar = (XulToolbar)xulDomContainer.getDocumentRoot().getElementById("nav-toolbar");
            ToolBar swtToolBar = (ToolBar)this.toolbar.getManagedObject();
            this.spoon.props.setLook((Control)swtToolBar, 6);
            swtToolBar.layout(true, true);
        }
        catch (Throwable t) {
            this.log.logError(this.toString(), new Object[]{Const.getStackTracker((Throwable)t)});
            new ErrorDialog(this.transGridComposite.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_TRANS_GRID_TOOLBAR}), new Exception(t));
        }
    }

    public void showHideInactive() {
        this.hideInactiveSteps = !this.hideInactiveSteps;
        SwtToolbarbutton onlyActiveButton = (SwtToolbarbutton)this.toolbar.getElementById("show-inactive");
        if (onlyActiveButton != null) {
            onlyActiveButton.setSelected(this.hideInactiveSteps);
            if (this.hideInactiveSteps) {
                onlyActiveButton.setImage(GUIResource.getInstance().getImageHideInactive());
            } else {
                onlyActiveButton.setImage(GUIResource.getInstance().getImageShowInactive());
            }
        }
    }

    public void showHideSelected() {
        this.showSelectedSteps = !this.showSelectedSteps;
        SwtToolbarbutton onlySelectedButton = (SwtToolbarbutton)this.toolbar.getElementById("show-selected");
        if (onlySelectedButton != null) {
            onlySelectedButton.setSelected(this.showSelectedSteps);
            if (this.showSelectedSteps) {
                onlySelectedButton.setImage(GUIResource.getInstance().getImageShowSelected());
            } else {
                onlySelectedButton.setImage(GUIResource.getInstance().getImageShowAll());
            }
        }
    }

    private void refreshView() {
        boolean tableCleared = false;
        int numberStepsToDisplay = -1;
        int baseStepCount = -1;
        if (this.transGridView == null || this.transGridView.isDisposed()) {
            return;
        }
        if (this.refresh_busy) {
            return;
        }
        ArrayList<StepMeta> selectedSteps = new ArrayList();
        if (this.showSelectedSteps) {
            selectedSteps = this.transGraph.trans.getTransMeta().getSelectedSteps();
        }
        int topIdx = this.transGridView.getTable().getTopIndex();
        this.refresh_busy = true;
        Table table = this.transGridView.table;
        long time = new Date().getTime();
        long msSinceLastUpdate = time - this.lastUpdateView;
        if (this.transGraph.trans != null && !this.transGraph.trans.isPreparing() && msSinceLastUpdate > 1000L) {
            StepInterface baseStep;
            int i;
            this.lastUpdateView = time;
            baseStepCount = this.transGraph.trans.nrSteps();
            numberStepsToDisplay = this.hideInactiveSteps ? this.transGraph.trans.nrActiveSteps() : baseStepCount;
            BaseStepData.StepExecutionStatus[] stepStatusLookup = this.transGraph.trans.getTransStepExecutionStatusLookup();
            boolean[] isRunningLookup = this.transGraph.trans.getTransStepIsRunningLookup();
            for (i = 0; i < baseStepCount; ++i) {
                if (this.hideInactiveSteps && !isRunningLookup[i] && stepStatusLookup[i] == BaseStepData.StepExecutionStatus.STATUS_FINISHED) continue;
                baseStep = this.transGraph.trans.getRunThread(i);
                numberStepsToDisplay += baseStep.subStatuses().size();
            }
            if (table.getItemCount() != numberStepsToDisplay) {
                table.removeAll();
                tableCleared = true;
            }
            if (numberStepsToDisplay == 0 && table.getItemCount() == 0) {
                new TableItem(table, 0);
                this.refresh_busy = false;
                return;
            }
            if (tableCleared) {
                for (i = 0; i < baseStepCount; ++i) {
                    baseStep = this.transGraph.trans.getRunThread(i);
                    if ((!this.showSelected(selectedSteps, baseStep) || !this.hideInactiveSteps || !isRunningLookup[i] && stepStatusLookup[i] == BaseStepData.StepExecutionStatus.STATUS_FINISHED) && (this.hideInactiveSteps || stepStatusLookup[i] == BaseStepData.StepExecutionStatus.STATUS_EMPTY)) continue;
                    TableItem ti = new TableItem(table, 0);
                    String baseStepNumber = "" + (i + 1);
                    ti.setText(0, baseStepNumber);
                    this.updateRowFromBaseStep(baseStep, ti);
                    int subStepIndex = 1;
                    for (StepStatus subStepStatus : baseStep.subStatuses()) {
                        String[] subFields = subStepStatus.getTransLogFields(baseStep.getStatus().getDescription());
                        subFields[1] = "     " + subFields[1];
                        TableItem subItem = new TableItem(table, 0);
                        subItem.setText(0, baseStepNumber + "." + subStepIndex++);
                        for (int f = 1; f < subFields.length; ++f) {
                            subItem.setText(f, subFields[f]);
                        }
                    }
                }
            } else {
                for (int rowIndex = 0; rowIndex < numberStepsToDisplay; ++rowIndex) {
                    int baseStepNumber;
                    StepInterface baseStep2;
                    TableItem ti = table.getItem(rowIndex);
                    if (ti == null) continue;
                    String tableStepNumber = ti.getText(0);
                    String[] tableStepNumberSplit = tableStepNumber.split("\\.");
                    String tableBaseStepNumber = tableStepNumberSplit[0];
                    boolean isBaseStep = true;
                    if (tableStepNumberSplit.length > 1) {
                        isBaseStep = false;
                    }
                    if ((!this.showSelected(selectedSteps, baseStep2 = this.transGraph.trans.getRunThread(baseStepNumber = Integer.parseInt(tableBaseStepNumber) - 1)) || !this.hideInactiveSteps || !isRunningLookup[baseStepNumber] && stepStatusLookup[baseStepNumber] == BaseStepData.StepExecutionStatus.STATUS_FINISHED) && (this.hideInactiveSteps || stepStatusLookup[baseStepNumber] == BaseStepData.StepExecutionStatus.STATUS_EMPTY)) continue;
                    if (isBaseStep) {
                        this.updateRowFromBaseStep(baseStep2, ti);
                        continue;
                    }
                    String tableSubStepName = ti.getText(1);
                    for (StepStatus subStepStatus : baseStep2.subStatuses()) {
                        String[] subFields = subStepStatus.getTransLogFields(baseStep2.getStatus().getDescription());
                        subFields[1] = "     " + subFields[1];
                        if (!subFields[1].equals(tableSubStepName)) continue;
                        this.updateCellsIfChanged(subFields, ti);
                    }
                }
            }
            int sortColumn = this.transGridView.getSortField();
            boolean sortDescending = this.transGridView.isSortingDescending();
            if (table.getItemCount() > 0 && (sortColumn != 0 || sortDescending)) {
                this.transGridView.sortTable(this.transGridView.getSortField(), sortDescending);
            }
            for (int i2 = 0; i2 < table.getItems().length; ++i2) {
                TableItem item = table.getItem(i2);
                item.setForeground(GUIResource.getInstance().getColorBlack());
                if (item.getBackground().equals((Object)GUIResource.getInstance().getColorRed())) continue;
                item.setBackground(i2 % 2 == 0 ? GUIResource.getInstance().getColorWhite() : GUIResource.getInstance().getColorBlueCustomGrid());
            }
            this.transGridView.optWidth(true);
            int[] selectedItems = this.transGridView.getSelectionIndices();
            if (selectedItems != null && selectedItems.length > 0) {
                this.transGridView.setSelection(selectedItems);
            }
            if (this.transGridView.getTable().getTopIndex() != topIdx) {
                this.transGridView.getTable().setTopIndex(topIdx);
            }
        } else if (table.getItemCount() == 0) {
            new TableItem(table, 0);
        }
        this.refresh_busy = false;
    }

    private void updateRowFromBaseStep(StepInterface baseStep, TableItem row) {
        StepStatus stepStatus = new StepStatus(baseStep);
        String[] fields = stepStatus.getTransLogFields();
        this.updateCellsIfChanged(fields, row);
        if (baseStep.getErrors() > 0L) {
            row.setBackground(GUIResource.getInstance().getColorRed());
        } else {
            row.setBackground(GUIResource.getInstance().getColorWhite());
        }
    }

    private boolean showSelected(List<StepMeta> selectedSteps, StepInterface baseStep) {
        boolean showSelected;
        if (this.showSelectedSteps) {
            if (selectedSteps.size() == 0) {
                showSelected = true;
            } else {
                showSelected = false;
                for (StepMeta stepMeta : selectedSteps) {
                    if (!baseStep.getStepMeta().equals((Object)stepMeta)) continue;
                    showSelected = true;
                    break;
                }
            }
        } else {
            showSelected = true;
        }
        return showSelected;
    }

    private void updateCellsIfChanged(String[] fields, TableItem row) {
        for (int f = 1; f < fields.length; ++f) {
            if (fields[f].equalsIgnoreCase(row.getText(f))) continue;
            row.setText(f, fields[f]);
        }
    }

    public CTabItem getTransGridTab() {
        return this.transGridTab;
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return "transgrid";
    }

    public XulDomContainer getXulDomContainer() {
        return null;
    }

    public void setData(Object data) {
    }

    public void setName(String name) {
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
    }
}

