/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository2.unified.jcr;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.api.locale.IPentahoLocale;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.unified.jcr.DefaultPathConversionHelper;
import org.pentaho.platform.repository2.unified.jcr.ILockHelper;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.repository2.unified.jcr.LocalePropertyResolver;
import org.pentaho.platform.repository2.unified.jcr.LocalizationUtil;
import org.pentaho.platform.repository2.unified.jcr.PentahoJcrConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.extensions.jcr.JcrCallback;
import org.springframework.extensions.jcr.JcrTemplate;

public class RepositoryFileProxy
extends RepositoryFile {
    private static final long serialVersionUID = 5244310953843118329L;
    private static Logger logger = LoggerFactory.getLogger(RepositoryFileProxy.class);
    private Node node;
    private PentahoJcrConstants constants;
    private JcrTemplate template;
    private Map<String, Serializable> metadata;
    private String creatorId;
    private Map<String, Properties> localeMap;
    private String description;
    private String title;
    private IPentahoLocale pentahoLocale;
    private long fileSize = -1L;
    private Date lastModifiedDate;
    private Boolean locked;
    private ILockHelper lockHelper;
    private String lockMessage;
    private String lockOwner;
    private String path;
    private String absPath;
    private Boolean folder;
    private Boolean hidden;
    private Boolean schedulable;
    private Boolean versioned;
    private Serializable id;
    private Lock lock;
    private Date lockDate;
    private String name;
    private String versionId;
    private Date createdDate;
    private Boolean aclNode;

    public RepositoryFileProxy(Node node, JcrTemplate template, IPentahoLocale pentahoLocale) {
        super(null, null, false, Boolean.valueOf(false), Boolean.valueOf(true), false, null, null, null, null, false, null, null, null, null, null, null, null, null, -1L, null, null, false);
        this.node = node;
        this.pentahoLocale = pentahoLocale;
        try {
            this.absPath = node.getPath();
        }
        catch (RepositoryException e) {
            RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
        }
        this.template = template;
        this.lockHelper = (ILockHelper)PentahoSystem.get(ILockHelper.class);
    }

    public static Logger getLogger() {
        return logger;
    }

    private PentahoJcrConstants getPentahoJcrConstants() {
        if (this.constants == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    RepositoryFileProxy.this.constants = new PentahoJcrConstants(session);
                }
            });
        }
        return this.constants;
    }

    public RepositoryFile clone() {
        return super.clone();
    }

    public int compareTo(RepositoryFile other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (this.equals(other)) {
            return 0;
        }
        return this.getTitle().compareTo(other.getTitle());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RepositoryFile other = (RepositoryFile)obj;
        if (this.getId() == null) {
            if (other.getId() != null) {
                return false;
            }
            if (this.getPath() != null && !other.getPath().equals(this.getPath())) {
                return false;
            }
        } else if (!this.getId().equals(other.getId())) {
            return false;
        }
        if (this.getLocale() == null ? other.getLocale() != null : !this.getLocale().equals(other.getLocale())) {
            return false;
        }
        return !(this.getVersionId() == null ? other.getVersionId() != null : !this.getVersionId().equals(other.getVersionId()));
    }

    public Date getCreatedDate() {
        if (this.createdDate == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        Calendar tmpCal;
                        if (RepositoryFileProxy.this.node.hasProperty(RepositoryFileProxy.this.getPentahoJcrConstants().getJCR_CREATED()) && (tmpCal = RepositoryFileProxy.this.node.getProperty(RepositoryFileProxy.this.getPentahoJcrConstants().getJCR_CREATED()).getDate()) != null) {
                            RepositoryFileProxy.this.createdDate = tmpCal.getTime();
                        }
                    }
                    catch (PathNotFoundException e) {
                        RepositoryFileProxy.getLogger().error(null, (Throwable)e);
                    }
                    catch (ValueFormatException e) {
                        RepositoryFileProxy.getLogger().error(null, (Throwable)e);
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error(null, (Throwable)e);
                    }
                }
            });
        }
        return this.createdDate;
    }

    @VisibleForTesting
    Map<String, Serializable> getMetadata() throws RepositoryException {
        if (this.metadata == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.metadata = JcrRepositoryFileUtils.getFileMetadata(session, RepositoryFileProxy.this.getId());
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.metadata;
    }

    public String getCreatorId() {
        try {
            Map<String, Serializable> metadata;
            if (this.creatorId == null && (metadata = this.getMetadata()) != null) {
                this.creatorId = (String)((Object)metadata.get(PentahoJcrConstants.PHO_CONTENTCREATOR));
            }
        }
        catch (RepositoryException e) {
            RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
        }
        return this.creatorId;
    }

    public Date getDeletedDate() {
        return super.getDeletedDate();
    }

    private void getTitleAndDescription() {
        if (this.title == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        if (JcrRepositoryFileUtils.isPentahoHierarchyNode(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node)) {
                            if (RepositoryFileProxy.this.node.hasNode(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_LOCALES())) {
                                LocalePropertyResolver lpr = new LocalePropertyResolver(RepositoryFileProxy.this.getName());
                                Locale loc = RepositoryFileProxy.this.getPentahoLocale() != null ? RepositoryFileProxy.this.getPentahoLocale().getLocale() : null;
                                LocalizationUtil localizationUtil = new LocalizationUtil(RepositoryFileProxy.this.getLocalePropertiesMap(), loc);
                                RepositoryFileProxy.this.title = localizationUtil.resolveLocalizedString(lpr.resolveDefaultTitleKey(), null);
                                if (StringUtils.isBlank((String)RepositoryFileProxy.this.title)) {
                                    RepositoryFileProxy.this.title = localizationUtil.resolveLocalizedString(lpr.resolveTitleKey(), null);
                                    if (StringUtils.isBlank((String)RepositoryFileProxy.this.title)) {
                                        RepositoryFileProxy.this.title = localizationUtil.resolveLocalizedString(lpr.resolveNameKey(), RepositoryFileProxy.this.title);
                                    }
                                }
                                RepositoryFileProxy.this.description = localizationUtil.resolveLocalizedString(lpr.resolveDefaultDescriptionKey(), null);
                                if (StringUtils.isBlank((String)RepositoryFileProxy.this.description)) {
                                    RepositoryFileProxy.this.description = localizationUtil.resolveLocalizedString(lpr.resolveDescriptionKey(), RepositoryFileProxy.this.description);
                                }
                            }
                            if (RepositoryFileProxy.this.title == null && RepositoryFileProxy.this.node.hasNode(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_TITLE())) {
                                RepositoryFileProxy.this.title = JcrRepositoryFileUtils.getLocalizedString(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node.getNode(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_TITLE()), RepositoryFileProxy.this.pentahoLocale);
                            }
                            if (RepositoryFileProxy.this.description == null && RepositoryFileProxy.this.node.hasNode(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_DESCRIPTION())) {
                                RepositoryFileProxy.this.description = JcrRepositoryFileUtils.getLocalizedString(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node.getNode(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_DESCRIPTION()), RepositoryFileProxy.this.pentahoLocale);
                            }
                        }
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        this.getTitleAndDescription();
        return this.description;
    }

    private IPentahoLocale getPentahoLocale() {
        return this.pentahoLocale;
    }

    public Long getFileSize() {
        if (this.fileSize == -1L) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        if (RepositoryFileProxy.this.node.hasProperty(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_FILESIZE())) {
                            RepositoryFileProxy.this.fileSize = RepositoryFileProxy.this.node.getProperty(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_FILESIZE()).getLong();
                        }
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.fileSize;
    }

    public Serializable getId() {
        if (this.id == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.id = JcrRepositoryFileUtils.getNodeId(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node);
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.id;
    }

    public Date getLastModifiedDate() {
        if (this.lastModifiedDate == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        Calendar tmpCal;
                        if (JcrRepositoryFileUtils.isPentahoFile(RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node) && !RepositoryFileProxy.this.node.isNodeType(RepositoryFileProxy.this.getPentahoJcrConstants().getNT_FROZENNODE()) && (tmpCal = RepositoryFileProxy.this.node.getProperty(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_LASTMODIFIED()).getDate()) != null) {
                            RepositoryFileProxy.this.lastModifiedDate = tmpCal.getTime();
                        }
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.lastModifiedDate;
    }

    public String getLocale() {
        IPentahoLocale loc = this.getPentahoLocale();
        return loc != null ? loc.toString() : null;
    }

    public Map<String, Properties> getLocalePropertiesMap() {
        if (this.localeMap == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.localeMap = JcrRepositoryFileUtils.getLocalePropertiesMap(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node.getNode(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_LOCALES()));
                    }
                    catch (PathNotFoundException pathNotFoundException) {
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.localeMap;
    }

    private Lock getLock() {
        if (this.lock == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.lock = session.getWorkspace().getLockManager().getLock(RepositoryFileProxy.this.node.getPath());
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.lock;
    }

    public Date getLockDate() {
        if (this.isLocked()) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.lockDate = RepositoryFileProxy.this.lockHelper.getLockDate(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.getLock());
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.lockDate;
    }

    public String getLockMessage() {
        if (this.isLocked()) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.lockMessage = RepositoryFileProxy.this.lockHelper.getLockMessage(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.getLock());
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.lockMessage;
    }

    public String getLockOwner() {
        if (this.isLocked()) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.lockOwner = RepositoryFileProxy.this.lockHelper.getLockOwner(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.getLock());
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.lockOwner;
    }

    public String getName() {
        if (this.name == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.name = "/".equals(RepositoryFileProxy.this.getPath()) ? "" : JcrRepositoryFileUtils.getNodeName(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node);
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.name;
    }

    public String getOriginalParentFolderPath() {
        return super.getOriginalParentFolderPath();
    }

    public String getPath() {
        if (this.path == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.path = new DefaultPathConversionHelper().absToRel(JcrRepositoryFileUtils.getAbsolutePath(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node));
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.path;
    }

    public String getTitle() {
        this.getTitleAndDescription();
        return this.title != null ? this.title : this.getName();
    }

    public Serializable getVersionId() {
        if (this.versionId == null && this.isVersioned()) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.versionId = JcrRepositoryFileUtils.getVersionId(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node);
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.versionId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.getLocale() == null ? 0 : this.getLocale().hashCode());
        result = 31 * result + (this.getVersionId() == null ? 0 : this.getVersionId().hashCode());
        return result;
    }

    public boolean isFolder() {
        if (this.folder == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.folder = JcrRepositoryFileUtils.isPentahoFolder(RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node);
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.folder;
    }

    public Boolean isHidden() {
        if (this.hidden == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        if (RepositoryFileProxy.this.node.hasProperty(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_HIDDEN())) {
                            RepositoryFileProxy.this.hidden = RepositoryFileProxy.this.node.getProperty(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_HIDDEN()).getBoolean();
                        }
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.hidden == null ? false : this.hidden;
    }

    public Boolean isSchedulable() {
        if (this.schedulable == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        Map<String, Serializable> metadata = RepositoryFileProxy.this.getMetadata();
                        if (metadata != null) {
                            RepositoryFileProxy.this.schedulable = metadata.get("_PERM_SCHEDULABLE") != null ? Boolean.valueOf(BooleanUtils.toBoolean((String)((String)((Object)metadata.get("_PERM_SCHEDULABLE"))))) : null;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return this.schedulable == null ? true : this.schedulable;
    }

    public boolean isLocked() {
        if (this.locked == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.locked = JcrRepositoryFileUtils.isLocked(RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node);
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.locked;
    }

    public boolean isVersioned() {
        if (this.versioned == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        RepositoryFileProxy.this.versioned = JcrRepositoryFileUtils.isVersioned(session, RepositoryFileProxy.this.getPentahoJcrConstants(), RepositoryFileProxy.this.node);
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.versioned;
    }

    public boolean isAclNode() {
        if (this.aclNode == null) {
            this.executeOperation(new SessionOperation(){

                @Override
                public void execute(Session session) {
                    try {
                        if (RepositoryFileProxy.this.node.hasProperty(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_ACLNODE())) {
                            RepositoryFileProxy.this.aclNode = RepositoryFileProxy.this.node.getProperty(RepositoryFileProxy.this.getPentahoJcrConstants().getPHO_ACLNODE()).getBoolean();
                        }
                    }
                    catch (RepositoryException e) {
                        RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
                    }
                }
            });
        }
        return this.aclNode == null ? false : this.aclNode;
    }

    public String toString() {
        return super.toString();
    }

    private void executeOperation(final SessionOperation op) {
        try {
            if (this.node.getSession().isLive()) {
                op.execute(this.node.getSession());
            } else {
                this.template.execute(new JcrCallback(){

                    public Object doInJcr(Session session) throws IOException, RepositoryException {
                        RepositoryFileProxy.this.node = (Node)session.getItem(RepositoryFileProxy.this.absPath);
                        op.execute(RepositoryFileProxy.this.node.getSession());
                        return null;
                    }
                });
            }
        }
        catch (RepositoryException e) {
            RepositoryFileProxy.getLogger().error("RepositoryException was found: ", (Throwable)e);
        }
    }

    private static interface SessionOperation {
        public void execute(Session var1);
    }
}

