/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

final class RetryAttemptState {
    private final ThreadLocal<Boolean> exhausted = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private final ThreadLocal<Integer> inProgressCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };

    RetryAttemptState() {
    }

    void signalStart() {
        Preconditions.checkState((!this.isExhausted() ? 1 : 0) != 0, (Object)"retry attempts exhausted");
        this.inProgressCount.set(this.inProgressCount.get() + 1);
    }

    void signalEnd() {
        int currentLevel = this.inProgressCount.get() - 1;
        this.inProgressCount.set(currentLevel);
        if (currentLevel == 0) {
            this.exhausted.set(false);
        }
    }

    void signalExhausted() {
        this.exhausted.set(true);
    }

    boolean isExhausted() {
        return this.exhausted.get();
    }

    @VisibleForTesting
    int getInProgressCount() {
        return this.inProgressCount.get();
    }
}

