/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionForNominalTimeJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.util.CoordActionsInDateRange;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.Pair;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XLog;
import org.jdom.Element;

public class CoordUtils {
    public static final String HADOOP_USER = "user.name";

    public static String getDoneFlag(Element doneFlagElement) {
        if (doneFlagElement != null) {
            return doneFlagElement.getTextTrim();
        }
        return "_SUCCESS";
    }

    public static Configuration getHadoopConf(Configuration jobConf) {
        Configuration conf = new Configuration();
        ParamChecker.notNull(jobConf, "Configuration to be used for hadoop setup ");
        String user = ParamChecker.notEmpty(jobConf.get(HADOOP_USER), HADOOP_USER);
        conf.set(HADOOP_USER, user);
        return conf;
    }

    public static List<CoordinatorActionBean> getCoordActions(String rangeType, String jobId, String scope, boolean active) throws CommandException {
        List<CoordinatorActionBean> coordActions = null;
        if (rangeType.equals("date")) {
            coordActions = CoordUtils.getCoordActionsFromDates(jobId, scope, active);
        } else if (rangeType.equals("action")) {
            coordActions = CoordUtils.getCoordActionsFromIds(jobId, scope);
        }
        return coordActions;
    }

    static List<CoordinatorActionBean> getCoordActionsFromDates(String jobId, String scope, boolean active) throws CommandException {
        String[] list;
        JPAService jpaService = Services.get().get(JPAService.class);
        ParamChecker.notEmpty(jobId, "jobId");
        ParamChecker.notEmpty(scope, "scope");
        HashSet<CoordinatorActionBean> actionSet = new HashSet<CoordinatorActionBean>();
        for (String s : list = scope.split(",")) {
            if ((s = s.trim()).contains("::")) {
                List<CoordinatorActionBean> listOfActions;
                try {
                    listOfActions = CoordActionsInDateRange.getCoordActionsFromDateRange(jobId, s, active);
                }
                catch (XException e) {
                    throw new CommandException(e);
                }
                actionSet.addAll(listOfActions);
                continue;
            }
            try {
                Date date = DateUtils.parseDateOozieTZ(s.trim());
                CoordinatorActionBean coordAction = jpaService.execute(new CoordJobGetActionForNominalTimeJPAExecutor(jobId, date));
                if (coordAction == null) {
                    throw new RuntimeException("This should never happen, Coordinator Action shouldn't be null");
                }
                actionSet.add(coordAction);
            }
            catch (ParseException e) {
                throw new CommandException(ErrorCode.E0302, s.trim(), e);
            }
            catch (JPAExecutorException e) {
                throw new CommandException(e);
            }
        }
        ArrayList<CoordinatorActionBean> coordActions = new ArrayList<CoordinatorActionBean>();
        for (CoordinatorActionBean coordAction : actionSet) {
            coordActions.add(coordAction);
        }
        return coordActions;
    }

    public static List<CoordinatorActionBean> getCoordActionsFromIds(String jobId, String scope) throws CommandException {
        String[] list;
        JPAService jpaService = Services.get().get(JPAService.class);
        ParamChecker.notEmpty(jobId, "jobId");
        ParamChecker.notEmpty(scope, "scope");
        HashSet<String> actions = new HashSet<String>();
        for (String s : list = scope.split(",")) {
            if ((s = s.trim()).contains("-")) {
                int end;
                int start;
                String[] range = s.split("-");
                if (range.length != 2) {
                    throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "', an example of correct format is 1-5");
                }
                try {
                    start = Integer.parseInt(range[0].trim());
                }
                catch (NumberFormatException ne) {
                    throw new CommandException(ErrorCode.E0302, "could not parse " + range[0].trim() + "into an integer", ne);
                }
                try {
                    end = Integer.parseInt(range[1].trim());
                }
                catch (NumberFormatException ne) {
                    throw new CommandException(ErrorCode.E0302, "could not parse " + range[1].trim() + "into an integer", ne);
                }
                if (start > end) {
                    throw new CommandException(ErrorCode.E0302, "format is wrong for action's range '" + s + "', starting action" + "number of the range should be less than ending action number, an example will be 1-4");
                }
                for (int i = start; i <= end; ++i) {
                    actions.add(jobId + "@" + i);
                }
                continue;
            }
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException ne) {
                throw new CommandException(ErrorCode.E0302, "format is wrong for action id'" + s + "'. Integer only.");
            }
            actions.add(jobId + "@" + s);
        }
        ArrayList<CoordinatorActionBean> coordActions = new ArrayList<CoordinatorActionBean>();
        for (String id : actions) {
            CoordinatorActionBean coordAction = null;
            try {
                coordAction = jpaService.execute(new CoordActionGetJPAExecutor(id));
            }
            catch (JPAExecutorException je) {
                if (je.getErrorCode().equals((Object)ErrorCode.E0605)) {
                    XLog.getLog(XLogService.class).warn("Coord action ID num [{0}] not yet materialized. Hence skipping over it for Kill action", id.substring(id.indexOf("@") + 1));
                    continue;
                }
                throw new CommandException(je);
            }
            coordActions.add(coordAction);
        }
        return coordActions;
    }

    public static Map<String, Object> getWhereClause(StringBuilder sb, Map<Pair<String, CoordinatorEngine.FILTER_COMPARATORS>, List<Object>> filterMap) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        int pcnt = 1;
        for (Map.Entry<Pair<String, CoordinatorEngine.FILTER_COMPARATORS>, List<Object>> filter : filterMap.entrySet()) {
            String sqlField;
            String field = filter.getKey().getFist();
            CoordinatorEngine.FILTER_COMPARATORS comp = filter.getKey().getSecond();
            if (field.equals("status")) {
                sqlField = "a.statusStr";
            } else if (field.equals("nominaltime")) {
                sqlField = "a.nominalTimestamp";
            } else {
                throw new IllegalArgumentException("Invalid filter key " + field);
            }
            sb.append(" and ").append(sqlField).append(" ");
            switch (comp) {
                case EQUALS: {
                    sb.append("IN (");
                    params.putAll(CoordUtils.appendParams(sb, filter.getValue(), pcnt));
                    sb.append(")");
                    break;
                }
                case NOT_EQUALS: {
                    sb.append("NOT IN (");
                    params.putAll(CoordUtils.appendParams(sb, filter.getValue(), pcnt));
                    sb.append(")");
                    break;
                }
                case GREATER: 
                case GREATER_EQUAL: 
                case LESSTHAN: 
                case LESSTHAN_EQUAL: {
                    if (filter.getValue().size() != 1) {
                        throw new IllegalArgumentException(field + comp.getSign() + " can't have more than 1 values");
                    }
                    sb.append(comp.getSign()).append(" ");
                    params.putAll(CoordUtils.appendParams(sb, filter.getValue(), pcnt));
                }
            }
            pcnt += filter.getValue().size();
        }
        sb.append(" ");
        return params;
    }

    private static Map<String, Object> appendParams(StringBuilder sb, List<Object> value, int sindex) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        boolean first = true;
        for (Object val : value) {
            String pname = "p" + sindex++;
            params.put(pname, val);
            if (!first) {
                sb.append(", ");
            }
            sb.append(':').append(pname);
            first = false;
        }
        return params;
    }
}

