/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleSQLException;
import org.pentaho.di.core.jdbc.ThinUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.sql.SQLAggregation;
import org.pentaho.di.core.sql.SQLField;
import org.pentaho.di.core.sql.SQLFields;
import org.pentaho.di.core.util.Utils;

public class SQLCondition {
    private String tableAlias;
    RowMetaInterface serviceFields;
    private Condition condition;
    private String conditionClause;
    private SQLFields selectFields;
    private static final Pattern PARAMETER_REGEX_PATTERN = Pattern.compile("(?i)^PARAMETER\\s*\\(\\s*'(.*)'\\s*\\)\\s*=\\s*'?([^']*)'?$");

    public SQLCondition(String tableAlias, String conditionSql, RowMetaInterface serviceFields) throws KettleSQLException {
        this(tableAlias, conditionSql, serviceFields, null);
    }

    public SQLCondition(String tableAlias, String conditionSql, RowMetaInterface serviceFields, SQLFields selectFields) throws KettleSQLException {
        this.tableAlias = tableAlias;
        this.conditionClause = conditionSql;
        this.serviceFields = serviceFields;
        this.selectFields = selectFields;
        this.parse();
    }

    private void parse() throws KettleSQLException {
        this.condition = this.splitConditionByOperator(this.conditionClause, null, 0);
        for (int i = 0; i < 20 && this.condition.simplify(); ++i) {
        }
    }

    int searchForWord(String clause, String word, int startIndex) throws KettleSQLException {
        int index = startIndex;
        while (index < clause.length()) {
            if ((index = ThinUtil.skipChars(clause, index, '\'', '(')) + word.length() > clause.length()) {
                return -1;
            }
            if (clause.substring(index).toUpperCase().startsWith(word.toUpperCase())) {
                if (index > 0 && String.valueOf(clause.charAt(index - 1)).matches("\\S")) {
                    ++index;
                    continue;
                }
                if (index + word.length() < clause.length() && String.valueOf(clause.charAt(index + word.length())).matches("\\S")) {
                    ++index;
                    continue;
                }
                return index;
            }
            ++index;
        }
        return -1;
    }

    private Condition splitConditionByOperator(String clause, Condition parentCondition, int parentOperator) throws KettleSQLException {
        if (parentCondition == null) {
            parentCondition = new Condition();
        } else {
            Condition c = new Condition();
            c.setOperator(parentOperator);
            parentCondition.addCondition(c);
            parentCondition = c;
        }
        int lastIndex = this.splitByOperator(clause, parentCondition, "OR", 1);
        if (lastIndex == 0 && (lastIndex = this.splitByOperator(clause, parentCondition, "AND", 2)) == 0) {
            String cleaned = Const.trim((String)clause);
            boolean negation = false;
            Matcher paramMatcher = PARAMETER_REGEX_PATTERN.matcher(cleaned);
            if (paramMatcher.matches()) {
                String parameterName = paramMatcher.group(1);
                String parameterValue = paramMatcher.group(2);
                this.validateParam(clause, parameterName, parameterValue);
                parentCondition.addCondition(this.createParameterCondition(1, parameterName, parameterValue));
            } else {
                if (Pattern.matches("^NOT\\s*\\(.*\\)$", cleaned.toUpperCase())) {
                    negation = true;
                    cleaned = Const.trim((String)cleaned.substring(3));
                }
                if (cleaned.startsWith("(") && cleaned.endsWith(")")) {
                    cleaned = cleaned.substring(1, cleaned.length() - 1);
                    Condition c = this.splitConditionByOperator(cleaned, parentCondition, 0);
                    c.setNegated(negation);
                } else {
                    Condition subCondition = this.parseAtomicCondition(cleaned);
                    subCondition.setOperator(1);
                    parentCondition.addCondition(subCondition);
                }
            }
        }
        return parentCondition;
    }

    private Condition createParameterCondition(int orConditionOperator, String parameterName, String parameterValue) {
        Condition subCondition = new Condition(parameterName, 14, parameterName, new ValueMetaAndData((ValueMetaInterface)new ValueMetaString("string"), (Object)Const.NVL((String)parameterValue, (String)"")));
        subCondition.setOperator(orConditionOperator);
        return subCondition;
    }

    private void validateParam(String clause, String parameterName, String parameterValue) throws KettleSQLException {
        if (Const.isEmpty((String)parameterName)) {
            throw new KettleSQLException("A parameter name cannot be empty in : " + clause);
        }
        if (Utils.isEmpty((CharSequence)parameterValue) || parameterValue.equals("''")) {
            throw new KettleSQLException("A parameter value cannot be empty in : " + clause);
        }
    }

    private int splitByOperator(String clause, Condition parentCondition, String operatorString, int conditionOperator) throws KettleSQLException {
        int lastIndex = 0;
        int index = 0;
        while (index < clause.length() && (index = this.searchForWord(clause, operatorString, index)) >= 0) {
            String left = clause.substring(lastIndex, index);
            this.splitConditionByOperator(left, parentCondition, conditionOperator);
            lastIndex = index += operatorString.length();
        }
        if (lastIndex > 0) {
            String right = clause.substring(lastIndex);
            this.splitConditionByOperator(right, parentCondition, conditionOperator);
        }
        return lastIndex;
    }

    private Condition parseAtomicCondition(String clause) throws KettleSQLException {
        ValueMetaAndData value;
        int function;
        List<String> clauseElements = this.splitConditionClause(clause);
        if (clauseElements.size() > 3) {
            throw new KettleSQLException("Unfortunately support for conditions is still very rudimentary, only 1 simple condition is supported [" + clause + "]");
        }
        String left = this.getCleansedName(this.getAlias(clauseElements.get(0)).orElse(clauseElements.get(0)));
        left = ThinUtil.unQuote(left.replaceAll("\"\"", "\""));
        int opFunction = Condition.getFunction((String)clauseElements.get(1));
        String right = this.getCleansedName(clauseElements.get(2));
        if (this.isEqualityComparisonOfLiteralValues(clauseElements)) {
            return new Condition(!left.equals(right), left, 14, right, null);
        }
        boolean negation = Pattern.matches("^NULL$", right.trim().toUpperCase());
        int n = function = negation ? 14 : opFunction;
        if (function == 9) {
            String trimmed = Const.trim((String)right);
            String partClause = trimmed.substring(1, trimmed.length() - 1);
            List<String> parts = ThinUtil.splitClause(partClause, ',', '\'');
            StringBuilder valueString = new StringBuilder();
            for (String part : parts) {
                ValueMetaAndData extractedConstraint;
                if (valueString.length() > 0) {
                    valueString.append(";");
                }
                if ((extractedConstraint = ThinUtil.extractConstant(part = Const.trim((String)part))) == null) {
                    throw new KettleSQLException("Condition parsing error: [" + part + "]");
                }
                part = extractedConstraint.toString();
                part = part.replace(";", "\\;");
                valueString.append(part);
            }
            value = new ValueMetaAndData((ValueMetaInterface)new ValueMetaString("constant-in-list"), (Object)valueString.toString());
        } else {
            String raw;
            int rightOrIndex;
            int leftOrIndex;
            String prefix = "'%'";
            String suffix = "'%'";
            if (right.startsWith(prefix) && right.endsWith(suffix) && (leftOrIndex = right.indexOf("||")) > 0 && (rightOrIndex = right.indexOf("||", leftOrIndex + 2)) > 0 && (raw = Const.trim((String)right.substring(leftOrIndex + 2, rightOrIndex))).startsWith("'") && raw.endsWith("'")) {
                right = "'%" + raw.substring(1, raw.length() - 1) + "%'";
            }
            value = ThinUtil.extractConstant(right);
        }
        if (value != null) {
            return new Condition(negation, left, function, null, value);
        }
        return new Condition(negation, left, function, right, null);
    }

    private boolean isEqualityComparisonOfLiteralValues(List<String> clauseElements) throws KettleSQLException {
        String left = clauseElements.get(0);
        int opFunction = Condition.getFunction((String)clauseElements.get(1));
        String right = clauseElements.get(2);
        return this.isLiteral(left) && this.isLiteral(right) && opFunction == 0;
    }

    private boolean isAggregateField(String left) throws KettleSQLException {
        return Arrays.stream(SQLAggregation.values()).filter(agg -> left.trim().toUpperCase().startsWith((Object)agg + "(")).findFirst().isPresent();
    }

    private boolean isLiteral(String element) throws KettleSQLException {
        return !this.getAlias(element).isPresent() && !ThinUtil.getValueMetaInterface(this.getCleansedName(element), this.getServiceFields()).isPresent() && !this.isAggregateField(element);
    }

    private String getCleansedName(String field) {
        return ThinUtil.getValueMetaInterface(field, this.getServiceFields()).map(ValueMetaInterface::getName).orElse(ThinUtil.stripQuotes(ThinUtil.stripQuoteTableAlias(field, this.tableAlias), '\"'));
    }

    private Optional<String> getAlias(String expression) {
        if (this.selectFields != null) {
            for (SQLField field : this.selectFields.getFields()) {
                if (!field.getExpression().equalsIgnoreCase(expression) || Const.isEmpty((String)field.getAlias())) continue;
                return Optional.of(field.getAlias());
            }
        }
        return Optional.empty();
    }

    private List<String> splitConditionClause(String clause) throws KettleSQLException {
        ArrayList<String> strings = new ArrayList<String>();
        String[] operators = new String[]{"<>", ">=", "=>", "<=", "=<", "<", ">", "=", " REGEX ", " IN ", " IS NOT NULL", " IS NULL", " LIKE", "CONTAINS "};
        int[] functions = new int[]{1, 5, 5, 3, 3, 2, 4, 0, 6, 9, 8, 7, 13, 10};
        for (int index = 0; index < clause.length(); ++index) {
            index = ThinUtil.skipChars(clause, index, '\'', '\"');
            for (String operator : operators) {
                if (index > clause.length() - operator.length() || !clause.substring(index).toUpperCase().startsWith(operator)) continue;
                int functionIndex = Const.indexOfString((String)operator, (String[])operators);
                String left = Const.trim((String)clause.substring(0, index));
                String op = Condition.functions[functions[functionIndex]];
                String right = Const.trim((String)clause.substring(index + operator.length()));
                return Arrays.asList(left, op, right);
            }
        }
        return strings;
    }

    public RowMetaInterface getServiceFields() {
        return this.serviceFields;
    }

    public void setServiceFields(RowMetaInterface serviceFields) {
        this.serviceFields = serviceFields;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String getConditionClause() {
        return this.conditionClause;
    }

    public void setConditionClause(String conditionClause) {
        this.conditionClause = conditionClause;
    }

    public boolean isEmpty() {
        return this.condition.isEmpty();
    }

    public SQLFields getSelectFields() {
        return this.selectFields;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public List<SQLField> extractHavingFields(List<SQLField> selectFields, List<SQLField> aggFields, RowMetaInterface rowMeta) throws KettleSQLException {
        ArrayList<SQLField> list = new ArrayList<SQLField>();
        ArrayList<String> expressions = new ArrayList<String>();
        this.addExpressions(this.condition, expressions);
        for (String expression : expressions) {
            SQLField field;
            SQLField aggField = SQLField.searchSQLFieldByFieldOrAlias(aggFields, expression);
            if (aggField != null || (field = new SQLField(this.tableAlias, expression, this.serviceFields)).getAggregation() == null) continue;
            field.setField(expression);
            list.add(field);
        }
        return list;
    }

    private void addExpressions(Condition condition, List<String> expressions) {
        if (condition.isAtomic()) {
            if (!expressions.contains(condition.getLeftValuename())) {
                expressions.add(condition.getLeftValuename());
            }
        } else {
            for (Condition child : condition.getChildren()) {
                this.addExpressions(child, expressions);
            }
        }
    }
}

