/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3n.vfs;

import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import java.util.Collection;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.jets3t.service.S3Service;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.pentaho.s3n.vfs.S3NFileObject;
import org.pentaho.s3n.vfs.S3NFileProvider;

public class S3NFileSystem
extends AbstractFileSystem
implements FileSystem {
    private S3Service service;

    protected S3NFileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        super(rootName, null, fileSystemOptions);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(S3NFileProvider.capabilities);
    }

    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new S3NFileObject(name, this);
    }

    public S3Service getS3Service() {
        if (this.service == null || this.service.getProviderCredentials() == null || this.service.getProviderCredentials().getAccessKey() == null) {
            com.amazonaws.auth.AWSCredentials credentials = DefaultAWSCredentialsProviderChain.getInstance().getCredentials();
            AWSCredentials awsCredentials = new AWSCredentials(credentials.getAWSAccessKeyId(), credentials.getAWSSecretKey());
            try {
                this.service = new RestS3Service((ProviderCredentials)awsCredentials);
            }
            catch (Throwable t) {
                System.out.println("Could not getS3Service() for " + awsCredentials.getLogString());
                t.printStackTrace();
            }
        }
        return this.service;
    }
}

