/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.pixie.wmf.records;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import org.pentaho.reporting.libraries.pixie.wmf.MfDcState;
import org.pentaho.reporting.libraries.pixie.wmf.MfRecord;
import org.pentaho.reporting.libraries.pixie.wmf.WmfFile;
import org.pentaho.reporting.libraries.pixie.wmf.records.MfCmd;
import org.pentaho.reporting.libraries.pixie.wmf.records.RecordCreationException;

public class MfCmdRoundRect
extends MfCmd {
    private static final int RECORD_SIZE = 6;
    private static final int POS_TOP = 4;
    private static final int POS_LEFT = 5;
    private static final int POS_RIGHT = 3;
    private static final int POS_BOTTOM = 2;
    private static final int POS_ROUND_WIDTH = 1;
    private static final int POS_ROUND_HEIGHT = 0;
    private int x;
    private int y;
    private int width;
    private int height;
    private int roundWidth;
    private int roundHeight;
    private int scaled_x;
    private int scaled_y;
    private int scaled_width;
    private int scaled_height;
    private int scaled_roundWidth;
    private int scaled_roundHeight;

    @Override
    public void replay(WmfFile file) {
        Graphics2D graph = file.getGraphics2D();
        Rectangle rec = this.getScaledBounds();
        Dimension dim = this.getScaledRoundingDim();
        RoundRectangle2D.Double shape = new RoundRectangle2D.Double();
        ((RoundRectangle2D)shape).setRoundRect(rec.x, rec.y, rec.width, rec.height, dim.width, dim.height);
        MfDcState state = file.getCurrentState();
        if (state.getLogBrush().isVisible()) {
            state.preparePaint();
            graph.fill(shape);
            state.postPaint();
        }
        if (state.getLogPen().isVisible()) {
            state.prepareDraw();
            graph.draw(shape);
            state.postDraw();
        }
    }

    @Override
    public MfCmd getInstance() {
        return new MfCmdRoundRect();
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[ROUND_RECTANGLE] bounds=");
        b.append(this.getBounds());
        b.append(" roundingDim=");
        b.append(this.getRoundingDim());
        return b.toString();
    }

    @Override
    public void setRecord(MfRecord record) {
        int rHeight = record.getParam(0);
        int rWidth = record.getParam(1);
        int bottom = record.getParam(2);
        int right = record.getParam(3);
        int top = record.getParam(4);
        int left = record.getParam(5);
        this.setBounds(left, top, right - left, bottom - top);
        this.setRoundingDim(rWidth, rHeight);
    }

    @Override
    public MfRecord getRecord() throws RecordCreationException {
        MfRecord record = new MfRecord(6);
        Dimension rDim = this.getRoundingDim();
        record.setParam(0, rDim.height);
        record.setParam(1, rDim.width);
        Rectangle bounds = this.getBounds();
        record.setParam(2, bounds.height + bounds.y);
        record.setParam(3, bounds.width + bounds.x);
        record.setParam(4, bounds.y);
        record.setParam(5, bounds.x);
        return record;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle getScaledBounds() {
        return new Rectangle(this.scaled_x, this.scaled_y, this.scaled_width, this.scaled_height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public void setRoundingDim(int w, int h) {
        this.roundWidth = w;
        this.roundHeight = h;
        this.scaleXChanged();
        this.scaleYChanged();
    }

    public Dimension getRoundingDim() {
        return new Dimension(this.roundWidth, this.roundHeight);
    }

    public Dimension getScaledRoundingDim() {
        return new Dimension(this.scaled_roundWidth, this.scaled_roundHeight);
    }

    @Override
    protected void scaleXChanged() {
        this.scaled_x = this.getScaledX(this.x);
        this.scaled_width = this.getScaledX(this.width);
        this.scaled_roundWidth = this.getScaledX(this.roundWidth);
    }

    @Override
    protected void scaleYChanged() {
        this.scaled_y = this.getScaledY(this.y);
        this.scaled_height = this.getScaledY(this.height);
        this.scaled_roundHeight = this.getScaledY(this.roundHeight);
    }

    @Override
    public int getFunction() {
        return 1564;
    }
}

