/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hbase.mapping;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.pentaho.bigdata.api.hbase.ByteConversionUtil;
import org.pentaho.bigdata.api.hbase.HBaseConnection;
import org.pentaho.bigdata.api.hbase.HBaseService;
import org.pentaho.bigdata.api.hbase.Result;
import org.pentaho.bigdata.api.hbase.mapping.Mapping;
import org.pentaho.bigdata.api.hbase.mapping.MappingFactory;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterface;
import org.pentaho.bigdata.api.hbase.meta.HBaseValueMetaInterfaceFactory;
import org.pentaho.bigdata.api.hbase.table.HBasePut;
import org.pentaho.bigdata.api.hbase.table.HBaseTable;
import org.pentaho.bigdata.api.hbase.table.HBaseTableWriteOperationManager;
import org.pentaho.bigdata.api.hbase.table.ResultScanner;
import org.pentaho.bigdata.api.hbase.table.ResultScannerBuilder;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;

public class MappingAdmin
implements Closeable {
    private final HBaseConnection hBaseConnection;
    private final HBaseService hBaseService;
    protected String m_mappingTableName = "pentaho_mappings";
    public static final String COLUMNS_FAMILY_NAME = "columns";
    public static final String KEY_FAMILY_NAME = "key";

    public MappingAdmin(HBaseConnection hBaseConnection) {
        this.hBaseConnection = hBaseConnection;
        this.hBaseService = hBaseConnection.getService();
    }

    public void setMappingTableName(String tableName) {
        this.m_mappingTableName = tableName;
    }

    public String getMappingTableName() {
        return this.m_mappingTableName;
    }

    public void createTestMapping() throws Exception {
        String keyName = "MyKey";
        String tableName = "MarksTestTable";
        String mappingName = "MarksTestMapping";
        MappingFactory mappingFactory = this.hBaseService.getMappingFactory();
        HBaseValueMetaInterfaceFactory valueMetaInterfaceFactory = this.hBaseService.getHBaseValueMetaInterfaceFactory();
        Mapping.KeyType keyType = Mapping.KeyType.LONG;
        Mapping testMapping = mappingFactory.createMapping(tableName, mappingName, keyName, keyType);
        String family1 = "Family1";
        String colA = "first_string_column";
        HBaseValueMetaInterface vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family1, colA, colA, 2, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colB = "first_unsigned_int_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family1, colB, colB, 5, -1, -1);
        vm.setIsLongOrDouble(false);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String family2 = "Family2";
        String colC = "first_indexed_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family2, colC, colC, 2, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        vm.setStorageType(2);
        Object[] vals = new Object[]{"nomVal1", "nomVal2", "nomVal3"};
        vm.setIndex(vals);
        testMapping.addMappedColumn(vm, false);
        String colD = "first_binary_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family1, colD, colD, 8, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colE = "first_boolean_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family1, colE, colE, 4, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colF = "first_signed_date_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family1, colF, colF, 3, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colG = "first_signed_double_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family2, colG, colG, 1, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colH = "first_signed_float_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family2, colH, colH, 1, -1, -1);
        vm.setIsLongOrDouble(false);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colI = "first_signed_int_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family2, colI, colI, 5, -1, -1);
        vm.setIsLongOrDouble(false);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colJ = "first_signed_long_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family2, colJ, colJ, 5, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colK = "first_unsigned_date_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family2, colK, colK, 3, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colL = "first_unsigned_double_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family2, colL, colL, 1, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colM = "first_unsigned_float_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family2, colM, colM, 1, -1, -1);
        vm.setIsLongOrDouble(false);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        String colN = "first_unsigned_long_column";
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family2, colN, colN, 5, -1, -1);
        vm.setTableName(tableName);
        vm.setMappingName(mappingName);
        testMapping.addMappedColumn(vm, false);
        this.putMapping(testMapping, false);
    }

    public void createTestTupleMapping() throws Exception {
        String keyName = "KEY";
        String tableName = "MarksTestTupleTable";
        String mappingName = "MarksTestTupleMapping";
        MappingFactory mappingFactory = this.hBaseService.getMappingFactory();
        HBaseValueMetaInterfaceFactory valueMetaInterfaceFactory = this.hBaseService.getHBaseValueMetaInterfaceFactory();
        Mapping.KeyType keyType = Mapping.KeyType.UNSIGNED_LONG;
        Mapping testMapping = mappingFactory.createMapping(tableName, mappingName, keyName, keyType);
        testMapping.setTupleMapping(true);
        String family = "";
        String colName = "";
        HBaseValueMetaInterface vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family, colName, "Family", 2, -1, -1);
        testMapping.addMappedColumn(vm, true);
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family, colName, "Column", 2, -1, -1);
        testMapping.addMappedColumn(vm, true);
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family, colName, "Value", 2, -1, -1);
        testMapping.addMappedColumn(vm, true);
        vm = valueMetaInterfaceFactory.createHBaseValueMetaInterface(family, colName, "Timestamp", 5, -1, -1);
        vm.setIsLongOrDouble(true);
        testMapping.addMappedColumn(vm, true);
        this.putMapping(testMapping, false);
    }

    public void createTupleTestTable() throws Exception {
        ByteConversionUtil byteConversionUtil = this.hBaseService.getByteConversionUtil();
        if (this.hBaseConnection == null) {
            throw new IOException("No connection exists yet!");
        }
        HBaseTable marksTestTupleTable = this.hBaseConnection.getTable("MarksTestTupleTable");
        if (marksTestTupleTable.exists()) {
            marksTestTupleTable.disable();
            marksTestTupleTable.delete();
        }
        ArrayList<String> colFamilies = new ArrayList<String>();
        colFamilies.add("Family1");
        colFamilies.add("Family2");
        marksTestTupleTable.create(colFamilies, null);
        HBaseTableWriteOperationManager writeOperationManager = marksTestTupleTable.createWriteOperationManager(Long.valueOf(0xC00000L));
        for (long key = 1L; key < 500L; ++key) {
            HBasePut hBasePut = writeOperationManager.createPut(byteConversionUtil.encodeKeyValue((Object)key, Mapping.KeyType.UNSIGNED_LONG));
            hBasePut.setWriteToWAL(false);
            int i = 0;
            while ((long)i < 10L * (key % 2L + 1L)) {
                if (i < 10) {
                    hBasePut.addColumn("Family1", "string_col" + i, false, byteConversionUtil.toBytes("StringValue_" + key));
                } else {
                    hBasePut.addColumn("Family2", "string_col" + i, false, byteConversionUtil.toBytes("StringValue_" + key));
                }
                hBasePut.execute();
                ++i;
            }
        }
        writeOperationManager.flushCommits();
        writeOperationManager.close();
    }

    public void createTestTable() throws Exception {
        ByteConversionUtil byteConversionUtil = this.hBaseService.getByteConversionUtil();
        HBaseTable marksTestTable = this.hBaseConnection.getTable("MarksTestTable");
        if (marksTestTable != null) {
            marksTestTable.disable();
            marksTestTable.delete();
        }
        ArrayList<String> colFamilies = new ArrayList<String>();
        colFamilies.add("Family1");
        colFamilies.add("Family2");
        marksTestTable.create(colFamilies, null);
        HBaseTableWriteOperationManager writeOperationManager = marksTestTable.createWriteOperationManager(Long.valueOf(0xC00000L));
        Random r = new Random();
        String[] nomVals = new String[]{"nomVal1", "nomVal2", "nomVal3"};
        Date date = new Date();
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        GregorianCalendar c2 = new GregorianCalendar();
        c2.set(1970, 2, 1);
        for (long key = -500L; key < 20000L; ++key) {
            HBasePut hBasePut = writeOperationManager.createPut(byteConversionUtil.encodeKeyValue((Object)key, Mapping.KeyType.LONG));
            hBasePut.setWriteToWAL(false);
            hBasePut.addColumn("Family1", "first_unsigned_int_column", false, byteConversionUtil.toBytes((key < 0L ? (long)((int)(-key)) : key) / 10L));
            hBasePut.addColumn("Family1", "first_string_column", false, byteConversionUtil.toBytes("StringValue_" + key));
            if (key % 10L > 0L) {
                int index = r.nextInt(3);
                String nomVal = nomVals[index];
                hBasePut.addColumn("Family2", "first_indexed_column", false, byteConversionUtil.toBytes(nomVal));
            }
            double d = r.nextDouble();
            int signedInt = r.nextInt(100);
            if (d < 0.5) {
                signedInt = -signedInt;
            }
            hBasePut.addColumn("Family2", "first_signed_int_column", false, byteConversionUtil.toBytes(signedInt));
            float f = r.nextFloat() * 1000.0f;
            hBasePut.addColumn("Family2", "first_unsigned_float_column", false, byteConversionUtil.toBytes(f));
            if (d > 0.5) {
                f = -f;
            }
            hBasePut.addColumn("Family2", "first_signed_float_column", false, byteConversionUtil.toBytes(f));
            double dd = d * 10000.0 * r.nextDouble();
            hBasePut.addColumn("Family2", "first_unsigned_double_column", false, byteConversionUtil.toBytes(dd));
            if (d > 0.5) {
                dd = -dd;
            }
            hBasePut.addColumn("Family2", "first_signed_double_column", false, byteConversionUtil.toBytes(dd));
            long l = r.nextInt(300);
            hBasePut.addColumn("Family2", "first_unsigned_long_column", false, byteConversionUtil.toBytes(l));
            if (d < 0.5) {
                l = -l;
            }
            hBasePut.addColumn("Family2", "first_signed_long_column", false, byteConversionUtil.toBytes(l));
            ((Calendar)c).add(6, 1);
            long longd = c.getTimeInMillis();
            hBasePut.addColumn("Family1", "first_unsigned_date_column", false, byteConversionUtil.toBytes(longd));
            ((Calendar)c2).add(6, -1);
            longd = c2.getTimeInMillis();
            hBasePut.addColumn("Family1", "first_signed_date_column", false, byteConversionUtil.toBytes(longd));
            String bVal = "";
            bVal = d < 0.5 ? "N" : "Y";
            hBasePut.addColumn("Family1", "first_boolean_column", false, byteConversionUtil.toBytes(bVal));
            byte[] serialized = byteConversionUtil.encodeObject((Object)new Double(d));
            hBasePut.addColumn("Family1", "first_serialized_column", false, serialized);
            byte[] rawStuff = byteConversionUtil.toBytes(5034555);
            hBasePut.addColumn("Family1", "first_binary_column", false, rawStuff);
            hBasePut.execute();
        }
        writeOperationManager.flushCommits();
        writeOperationManager.close();
    }

    public void createMappingTable() throws Exception {
        HBaseTable hBaseTable = this.hBaseConnection.getTable(this.m_mappingTableName);
        if (hBaseTable.exists()) {
            throw new IOException("Mapping table already exists!");
        }
        ArrayList<String> colFamNames = new ArrayList<String>();
        colFamNames.add(COLUMNS_FAMILY_NAME);
        colFamNames.add(KEY_FAMILY_NAME);
        hBaseTable.create(colFamNames, null);
    }

    public boolean mappingExists(String tableName, String mappingName) throws Exception {
        try (HBaseTable hBaseTable = this.hBaseConnection.getTable(this.m_mappingTableName);){
            if (hBaseTable.exists()) {
                boolean bl = hBaseTable.keyExists(this.hBaseService.getByteConversionUtil().compoundKey(new String[]{tableName, mappingName}));
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public Set<String> getMappedTables() throws Exception {
        ByteConversionUtil byteConversionUtil = this.hBaseService.getByteConversionUtil();
        HashSet<String> tableNames = new HashSet<String>();
        try (HBaseTable hBaseTable = this.hBaseConnection.getTable(this.m_mappingTableName);){
            if (hBaseTable.exists()) {
                ResultScannerBuilder scannerBuilder = hBaseTable.createScannerBuilder(null, null);
                scannerBuilder.setCaching(10);
                try (ResultScanner resultScanner = scannerBuilder.build();){
                    Result next;
                    while ((next = resultScanner.next()) != null) {
                        byte[] rawKey = next.getRow();
                        String tableName = byteConversionUtil.splitKey(rawKey)[0];
                        tableNames.add(tableName.trim());
                    }
                }
            }
            HashSet<String> hashSet = tableNames;
            return hashSet;
        }
    }

    public List<String> getMappingNames(String tableName) throws Exception {
        ByteConversionUtil byteConversionUtil = this.hBaseService.getByteConversionUtil();
        ArrayList<String> mappingsForTable = new ArrayList<String>();
        try (HBaseTable hBaseTable = this.hBaseConnection.getTable(this.m_mappingTableName);){
            if (hBaseTable.exists()) {
                ResultScannerBuilder scannerBuilder = hBaseTable.createScannerBuilder(null, null);
                scannerBuilder.setCaching(10);
                try (ResultScanner resultScanner = scannerBuilder.build();){
                    Result next;
                    while ((next = resultScanner.next()) != null) {
                        byte[] rowKey = next.getRow();
                        String[] splitKey = byteConversionUtil.splitKey(rowKey);
                        String tableN = splitKey[0];
                        if (!tableName.equals(tableN)) continue;
                        mappingsForTable.add(splitKey[1]);
                    }
                }
            }
            ArrayList<String> arrayList = mappingsForTable;
            return arrayList;
        }
    }

    /*
     * Exception decompiling
     */
    public boolean deleteMapping(String tableName, String mappingName) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 37[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean deleteMapping(Mapping theMapping) throws Exception {
        String tableName = theMapping.getTableName();
        String mappingName = theMapping.getMappingName();
        return this.deleteMapping(tableName, mappingName);
    }

    public void putMapping(Mapping theMapping, boolean overwrite) throws Exception {
        String tableName = theMapping.getTableName();
        String mappingName = theMapping.getMappingName();
        Map mapping = theMapping.getMappedColumns();
        String keyName = theMapping.getKeyName();
        Mapping.KeyType keyType = theMapping.getKeyType();
        boolean isTupleMapping = theMapping.isTupleMapping();
        String tupleFamilies = theMapping.getTupleFamilies();
        ByteConversionUtil byteConversionUtil = this.hBaseService.getByteConversionUtil();
        try (HBaseTable hBaseTable = this.hBaseConnection.getTable(this.m_mappingTableName);){
            boolean mappingExists;
            if (!hBaseTable.exists()) {
                this.createMappingTable();
            }
            if (hBaseTable.disabled()) {
                hBaseTable.enable();
            }
            if ((mappingExists = this.mappingExists(tableName, mappingName)) && !overwrite) {
                throw new IOException("The mapping \"" + mappingName + "\" already exists for table \"" + tableName + "\"");
            }
            if (mappingExists) {
                this.deleteMapping(tableName, mappingName);
            }
            HBaseTableWriteOperationManager writeOperationManager = hBaseTable.createWriteOperationManager(null);
            HBasePut hBasePut = writeOperationManager.createPut(byteConversionUtil.compoundKey(new String[]{tableName, mappingName}));
            hBasePut.setWriteToWAL(true);
            String family = COLUMNS_FAMILY_NAME;
            Set aliases = mapping.keySet();
            for (String alias : aliases) {
                HBaseValueMetaInterface vm = (HBaseValueMetaInterface)mapping.get(alias);
                String valueType = ValueMetaInterface.typeCodes[vm.getType()];
                if (vm.isInteger() && vm.getIsLongOrDouble()) {
                    valueType = "Long";
                }
                if (vm.isNumber()) {
                    valueType = vm.getIsLongOrDouble() ? "Double" : "Float";
                }
                if (vm.getStorageType() == 2 && vm.isString()) {
                    Object[] labels = vm.getIndex();
                    StringBuffer vals = new StringBuffer();
                    vals.append("{");
                    for (int i = 0; i < labels.length; ++i) {
                        if (i != labels.length - 1) {
                            vals.append(labels[i].toString().trim()).append(",");
                            continue;
                        }
                        vals.append(labels[i].toString().trim()).append("}");
                    }
                    valueType = vals.toString();
                }
                hBasePut.addColumn(family, hBasePut.createColumnName(new String[]{vm.getColumnFamily(), vm.getColumnName(), alias}), false, byteConversionUtil.toBytes(valueType));
            }
            family = KEY_FAMILY_NAME;
            ArrayList<String> qualifier = new ArrayList<String>(Collections.singletonList(keyName));
            if (isTupleMapping) {
                if (Const.isEmpty((String)tupleFamilies)) {
                    qualifier.add("");
                } else {
                    qualifier.add(tupleFamilies);
                }
            }
            String valueType = keyType.toString();
            hBasePut.addColumn(family, hBasePut.createColumnName(qualifier.toArray(new String[qualifier.size()])), false, byteConversionUtil.toBytes(valueType));
            hBasePut.execute();
            writeOperationManager.flushCommits();
        }
    }

    public String describeMapping(String tableName, String mappingName) throws Exception {
        return this.describeMapping(this.getMapping(tableName, mappingName));
    }

    public String describeMapping(Mapping aMapping) throws IOException {
        return aMapping.toString();
    }

    public Mapping getMapping(String tableName, String mappingName) throws Exception {
        ByteConversionUtil byteConversionUtil = this.hBaseService.getByteConversionUtil();
        MappingFactory mappingFactory = this.hBaseService.getMappingFactory();
        HBaseValueMetaInterfaceFactory valueMetaInterfaceFactory = this.hBaseService.getHBaseValueMetaInterfaceFactory();
        try (HBaseTable hBaseTable = this.hBaseConnection.getTable(this.m_mappingTableName);){
            if (!hBaseTable.exists()) {
                this.createMappingTable();
                throw new IOException("Mapping \"" + tableName + "," + mappingName + "\" does not exist!");
            }
            byte[] compoundKey = byteConversionUtil.compoundKey(new String[]{tableName, mappingName});
            ResultScannerBuilder scannerBuilder = hBaseTable.createScannerBuilder(compoundKey, compoundKey);
            scannerBuilder.setCaching(10);
            ResultScanner resultScanner = scannerBuilder.build();
            Result result = resultScanner.next();
            if (result == null) {
                throw new IOException("Mapping \"" + tableName + "," + mappingName + "\" does not exist!");
            }
            NavigableMap colsInKeyFamily = result.getFamilyMap(KEY_FAMILY_NAME);
            Set keyCols = colsInKeyFamily.keySet();
            if (keyCols.size() != 1) {
                throw new IOException("Mapping \"" + tableName + "," + mappingName + "\" has more than one key defined!");
            }
            byte[] keyNameB = (byte[])keyCols.iterator().next();
            String decodedKeyName = byteConversionUtil.toString(keyNameB);
            byte[] keyTypeB = (byte[])colsInKeyFamily.get(keyNameB);
            String decodedKeyType = byteConversionUtil.toString(keyTypeB);
            Mapping.KeyType keyType = null;
            for (Mapping.KeyType t : Mapping.KeyType.values()) {
                if (!decodedKeyType.equalsIgnoreCase(t.toString())) continue;
                keyType = t;
                break;
            }
            if (keyType == null) {
                throw new IOException("Unrecognized type for the key column in \"" + compoundKey + "\"");
            }
            String tupleFamilies = "";
            boolean isTupleMapping = false;
            if (decodedKeyName.indexOf(44) > 0) {
                isTupleMapping = true;
                if (decodedKeyName.indexOf(44) != decodedKeyName.length() - 1) {
                    tupleFamilies = decodedKeyName.substring(decodedKeyName.indexOf(44) + 1, decodedKeyName.length());
                }
                decodedKeyName = decodedKeyName.substring(0, decodedKeyName.indexOf(44));
            }
            Mapping resultMapping = mappingFactory.createMapping(tableName, mappingName, decodedKeyName, keyType);
            resultMapping.setTupleMapping(isTupleMapping);
            if (!Const.isEmpty((String)tupleFamilies)) {
                resultMapping.setTupleFamilies(tupleFamilies);
            }
            TreeMap<String, HBaseValueMetaInterface> resultCols = new TreeMap<String, HBaseValueMetaInterface>();
            NavigableMap colsInMapping = result.getFamilyMap(COLUMNS_FAMILY_NAME);
            Set colNames = colsInMapping.keySet();
            for (byte[] b : colNames) {
                String decodedName = byteConversionUtil.toString(b);
                byte[] c = (byte[])colsInMapping.get(b);
                if (c == null) {
                    throw new IOException("No type declaration for column \"" + decodedName + "\"");
                }
                String decodedType = byteConversionUtil.toString(c);
                HBaseValueMetaInterface newMeta = null;
                if (decodedType.equalsIgnoreCase("Float")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 1, -1, -1);
                    newMeta.setIsLongOrDouble(false);
                } else if (decodedType.equalsIgnoreCase("Double")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 1, -1, -1);
                } else if (decodedType.equalsIgnoreCase("String")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 2, -1, -1);
                } else if (decodedType.toLowerCase().startsWith("date")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 3, -1, -1);
                } else if (decodedType.equalsIgnoreCase("Boolean")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 4, -1, -1);
                } else if (decodedType.equalsIgnoreCase("Integer")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 5, -1, -1);
                    newMeta.setIsLongOrDouble(false);
                } else if (decodedType.equalsIgnoreCase("Long")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 5, -1, -1);
                } else if (decodedType.equalsIgnoreCase("BigNumber")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 6, -1, -1);
                } else if (decodedType.equalsIgnoreCase("Serializable")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 7, -1, -1);
                } else if (decodedType.equalsIgnoreCase("Binary")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 8, -1, -1);
                } else if (decodedType.startsWith("{") && decodedType.endsWith("}")) {
                    newMeta = valueMetaInterfaceFactory.createHBaseValueMetaInterface(decodedName, 2, -1, -1);
                    Object[] labels = null;
                    try {
                        labels = byteConversionUtil.stringIndexListToObjects(decodedType);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new IOException("Indexed/nominal type must have at least one label declared");
                    }
                    newMeta.setIndex(labels);
                    newMeta.setStorageType(2);
                } else {
                    throw new IOException("Unknown column type : \"" + decodedType + "\"");
                }
                newMeta.setTableName(tableName);
                newMeta.setMappingName(mappingName);
                String alias = newMeta.getAlias();
                if (Mapping.TupleMapping.KEY.toString().equalsIgnoreCase(alias)) continue;
                if (resultMapping.getKeyName().equals(alias)) {
                    throw new IOException("Error in mapping. Column \"" + newMeta.getAlias() + "\" has the same name as the table key (" + resultMapping.getKeyName() + ")");
                }
                resultCols.put(newMeta.getAlias(), newMeta);
            }
            resultMapping.setMappedColumns(resultCols);
            Mapping mapping = resultMapping;
            return mapping;
        }
    }

    @Override
    public void close() throws IOException {
        this.hBaseConnection.close();
    }

    public HBaseConnection getConnection() {
        return this.hBaseConnection;
    }

    public static String getTableNameFromVariable(BaseStepMeta stepMeta, String mappedTableName) {
        TransMeta parentTransMeta = stepMeta.getParentStepMeta().getParentTransMeta();
        return parentTransMeta.environmentSubstitute(mappedTableName);
    }
}

