/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.CharArrayWriter;
import java.util.Enumeration;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hive.service.cli.CLIServiceUtils;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class LogDivertAppenderForTest
extends WriterAppender {
    private static final Logger LOG = Logger.getLogger((String)LogDivertAppenderForTest.class.getName());
    private final OperationManager operationManager;
    private final CharArrayWriter writer = new CharArrayWriter();

    public LogDivertAppenderForTest(OperationManager operationManager) {
        this.setWriter(this.writer);
        this.setName("LogDivertAppenderForTest");
        this.operationManager = operationManager;
        this.addFilter(new TestFilter());
        this.initLayout(false);
    }

    private void setLayout(boolean isVerbose, Layout lo) {
        if (isVerbose) {
            if (lo == null) {
                lo = CLIServiceUtils.verboseLayout;
                LOG.info((Object)"Cannot find a Layout from a ConsoleAppender. Using default Layout pattern.");
            }
        } else {
            lo = CLIServiceUtils.nonVerboseLayout;
        }
        this.setLayout(lo);
    }

    private void initLayout(boolean isVerbose) {
        Logger root = Logger.getRootLogger();
        Layout layout = null;
        Enumeration appenders = root.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender ap = (Appender)appenders.nextElement();
            if (!ap.getClass().equals(ConsoleAppender.class)) continue;
            layout = ap.getLayout();
            break;
        }
        this.setLayout(isVerbose, layout);
    }

    protected void subAppend(LoggingEvent event) {
        super.subAppend(event);
        String logOutput = this.writer.toString();
        this.writer.reset();
        OperationLog log = this.operationManager.getOperationLogByThread();
        if (log == null) {
            LOG.debug((Object)(" ---+++=== Dropped log event from thread " + event.getThreadName()));
            return;
        }
        log.writeOperationLogForTest(logOutput);
    }

    private static class TestFilter
    extends Filter {
        private TestFilter() {
        }

        public int decide(LoggingEvent event) {
            if (event.getLevel().equals((Object)Level.INFO) && "SessionState".equals(event.getLoggerName()) && (event.getRenderedMessage().startsWith("PREHOOK:") || event.getRenderedMessage().startsWith("POSTHOOK:") || event.getRenderedMessage().startsWith("unix_timestamp(void)") || event.getRenderedMessage().startsWith("Warning: "))) {
                return 1;
            }
            return -1;
        }
    }
}

