/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.hdfs.job;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.pentaho.big.data.api.cluster.NamedCluster;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.JobEntry;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.job.entries.copyfiles.JobEntryCopyFiles;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.runtime.test.RuntimeTester;
import org.pentaho.runtime.test.action.RuntimeTestActionService;

@JobEntry(id="HadoopCopyFilesPlugin", image="HDM.svg", name="HadoopCopyFilesPlugin.Name", description="HadoopCopyFilesPlugin.Description", categoryDescription="i18n:org.pentaho.di.job:JobCategory.Category.BigData", i18nPackageName="org.pentaho.di.job.entries.hadoopcopyfiles", documentationUrl="http://wiki.pentaho.com/display/EAI/Hadoop+Copy+Files")
public class JobEntryHadoopCopyFiles
extends JobEntryCopyFiles {
    public static final String S3_SOURCE_FILE = "S3-SOURCE-FILE-";
    public static final String S3_DEST_FILE = "S3-DEST-FILE-";
    private final NamedClusterService namedClusterService;
    private final RuntimeTestActionService runtimeTestActionService;
    private final RuntimeTester runtimeTester;

    public JobEntryHadoopCopyFiles(NamedClusterService namedClusterService, RuntimeTestActionService runtimeTestActionService, RuntimeTester runtimeTester) {
        this.namedClusterService = namedClusterService;
        this.runtimeTestActionService = runtimeTestActionService;
        this.runtimeTester = runtimeTester;
    }

    public String loadURL(String url, String ncName, IMetaStore metastore, Map mappings) {
        NamedCluster c = this.namedClusterService.getNamedClusterByName(ncName, metastore);
        String pref = null;
        if (url != null && url.indexOf("EMPTY_SOURCE_URL-") > -1) {
            String origUrl = url;
            url = origUrl.substring(origUrl.indexOf("-", origUrl.indexOf("EMPTY_SOURCE_URL-") + "EMPTY_SOURCE_URL-".length()) + 1);
            pref = origUrl.substring(0, origUrl.indexOf("-", origUrl.indexOf("EMPTY_SOURCE_URL-") + "EMPTY_SOURCE_URL-".length()) + 1);
        } else if (url != null && url.indexOf("EMPTY_DEST_URL-") > -1) {
            String origUrl = url;
            url = origUrl.substring(origUrl.indexOf("-", origUrl.indexOf("EMPTY_DEST_URL-") + "EMPTY_DEST_URL-".length()) + 1);
            pref = origUrl.substring(0, origUrl.indexOf("-", origUrl.indexOf("EMPTY_DEST_URL-") + "EMPTY_DEST_URL-".length()) + 1);
        }
        if (c != null) {
            url = c.processURLsubstitution(url, metastore, this.getVariables());
        }
        if (pref != null) {
            url = pref + url;
        }
        if (!Const.isEmpty((String)ncName) && !Const.isEmpty((String)url)) {
            mappings.put(url, ncName);
        }
        return url;
    }

    @VisibleForTesting
    protected VariableSpace getVariables() {
        return super.getVariables();
    }

    public NamedClusterService getNamedClusterService() {
        return this.namedClusterService;
    }

    public RuntimeTestActionService getRuntimeTestActionService() {
        return this.runtimeTestActionService;
    }

    public RuntimeTester getRuntimeTester() {
        return this.runtimeTester;
    }
}

