/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.googledrive.vfs;

import com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.store.DataStoreFactory;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.FileList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.pentaho.googledrive.vfs.GoogleDriveFileSystem;
import org.pentaho.googledrive.vfs.util.CustomAuthorizationCodeInstalledApp;
import org.pentaho.googledrive.vfs.util.CustomDataStoreFactory;
import org.pentaho.googledrive.vfs.util.CustomLocalServerReceiver;

public class GoogleDriveFileObject
extends AbstractFileObject {
    public static final String PROJECT_NAME = "pentaho-googledrive-vfs";
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/drive");
    private CustomDataStoreFactory DATA_STORE_FACTORY;
    private final JsonFactory JSON_FACTORY = JacksonFactory.getDefaultInstance();
    private HttpTransport HTTP_TRANSPORT;
    private String APPLICATION_NAME = "";
    private Drive driveService;
    private FileType mimeType;
    private String id;
    private static ResourceBundle resourceBundle = PropertyResourceBundle.getBundle("plugin");
    private final File DATA_STORE_DIR = new File(GoogleDriveFileObject.resolveCredentialsPath());

    protected GoogleDriveFileObject(AbstractFileName fileName, GoogleDriveFileSystem fileSystem) throws FileSystemException {
        super(fileName, (AbstractFileSystem)fileSystem);
        try {
            this.HTTP_TRANSPORT = GoogleNetHttpTransport.newTrustedTransport();
            this.DATA_STORE_FACTORY = new CustomDataStoreFactory(this.DATA_STORE_DIR);
            this.driveService = this.getDriveService();
            this.resolveFileMetadata();
        }
        catch (Exception e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    protected String[] doListChildren() throws Exception {
        String[] children = null;
        if (this.isFolder()) {
            this.id = this.id == null ? "root" : this.id;
            String fileQuery = "'" + this.id + "' in parents and trashed=false";
            FileList files = (FileList)this.driveService.files().list().setQ(fileQuery).execute();
            ArrayList<String> fileNames = new ArrayList<String>();
            for (com.google.api.services.drive.model.File file : files.getFiles()) {
                fileNames.add(file.getName());
            }
            children = fileNames.toArray(new String[0]);
        }
        return children;
    }

    protected void doCreateFolder() throws Exception {
        if (!this.getName().getBaseName().isEmpty()) {
            com.google.api.services.drive.model.File folder = new com.google.api.services.drive.model.File();
            folder.setName(this.getName().getBaseName());
            folder.setMimeType(MIME_TYPES.FOLDER.mimeType);
            folder = (com.google.api.services.drive.model.File)this.driveService.files().create(folder).execute();
            if (folder != null) {
                this.id = folder.getId();
                this.mimeType = MIME_TYPES.get(folder.getMimeType());
            }
        }
    }

    protected void doDelete() throws Exception {
        this.driveService.files().delete(this.id).execute();
        this.id = null;
        this.mimeType = null;
    }

    protected long doGetContentSize() throws Exception {
        return -1L;
    }

    protected FileType doGetType() throws Exception {
        return this.mimeType;
    }

    protected InputStream doGetInputStream() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.driveService.files().get(this.id).executeMediaAndDownloadTo((OutputStream)out);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        return in;
    }

    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        final com.google.api.services.drive.model.File parent = this.getName().getParent() != null ? this.searchFile(this.getName().getParent().getBaseName(), null) : null;
        ByteArrayOutputStream out = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                com.google.api.services.drive.model.File file = new com.google.api.services.drive.model.File();
                file.setName(GoogleDriveFileObject.this.getName().getBaseName());
                if (parent != null) {
                    file.setParents(Collections.singletonList(parent.getId()));
                }
                ByteArrayContent fileContent = new ByteArrayContent("application/octet-stream", this.toByteArray());
                if (this.count > 0) {
                    GoogleDriveFileObject.this.driveService.files().create(file, (AbstractInputStreamContent)fileContent).execute();
                    ((GoogleDriveFileSystem)GoogleDriveFileObject.this.getFileSystem()).clearFileFromCache(GoogleDriveFileObject.this.getName());
                }
            }
        };
        return out;
    }

    protected long doGetLastModifiedTime() throws Exception {
        return -1L;
    }

    private void resolveFileMetadata() throws Exception {
        String fileName;
        com.google.api.services.drive.model.File file;
        FileType mime;
        com.google.api.services.drive.model.File parent;
        String parentId = null;
        if (this.getName().getParent() != null && (parent = this.searchFile(this.getName().getParent().getBaseName(), null)) != null && (mime = MIME_TYPES.get(parent.getMimeType())).equals((Object)FileType.FOLDER)) {
            parentId = parent.getId();
        }
        if ((file = this.searchFile(fileName = this.getName().getBaseName(), parentId)) != null) {
            this.mimeType = MIME_TYPES.get(file.getMimeType());
            this.id = file.getId();
        } else if (this.getName().getURI().equals("googledrive:///")) {
            this.mimeType = FileType.FOLDER;
        }
    }

    private com.google.api.services.drive.model.File searchFile(String fileName, String parentId) throws Exception {
        FileList fileList;
        com.google.api.services.drive.model.File file = null;
        StringBuffer fileQuery = new StringBuffer();
        fileQuery.append("name = '" + fileName + "'");
        if (parentId != null) {
            fileQuery.append(" and '" + parentId + "' in parents and trashed=false");
        }
        if (!(fileList = (FileList)this.driveService.files().list().setQ(fileQuery.toString()).execute()).getFiles().isEmpty()) {
            file = (com.google.api.services.drive.model.File)fileList.getFiles().get(0);
        }
        return file;
    }

    private Credential authorize() throws IOException {
        FileInputStream in = new FileInputStream(GoogleDriveFileObject.resolveCredentialsPath() + "/" + resourceBundle.getString("client.secrets"));
        GoogleClientSecrets clientSecrets = GoogleClientSecrets.load((JsonFactory)this.JSON_FACTORY, (Reader)new InputStreamReader(in));
        GoogleAuthorizationCodeFlow flow = new GoogleAuthorizationCodeFlow.Builder(this.HTTP_TRANSPORT, this.JSON_FACTORY, clientSecrets, SCOPES).setDataStoreFactory((DataStoreFactory)this.DATA_STORE_FACTORY).setAccessType("offline").build();
        Credential credential = new CustomAuthorizationCodeInstalledApp((AuthorizationCodeFlow)flow, new CustomLocalServerReceiver()).authorize("user");
        return credential;
    }

    private Drive getDriveService() throws IOException {
        Credential credential = this.authorize();
        return new Drive.Builder(this.HTTP_TRANSPORT, this.JSON_FACTORY, (HttpRequestInitializer)credential).setApplicationName(this.APPLICATION_NAME).build();
    }

    public static String resolveCredentialsPath() {
        String path = GoogleDriveFileObject.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        path = path.substring(0, path.indexOf(PROJECT_NAME));
        path = path + PROJECT_NAME + "/" + resourceBundle.getString("credentials.folder");
        return path;
    }

    public static enum MIME_TYPES {
        FILE("application/vnd.google-apps.file", FileType.FILE),
        FOLDER("application/vnd.google-apps.folder", FileType.FOLDER);

        private final String mimeType;
        private final FileType fileType;

        private MIME_TYPES(String mimeType, FileType fileType) {
            this.mimeType = mimeType;
            this.fileType = fileType;
        }

        public static FileType get(String type) {
            FileType fileType = null;
            fileType = MIME_TYPES.FOLDER.mimeType.equals(type) ? MIME_TYPES.FOLDER.fileType : MIME_TYPES.FILE.fileType;
            return fileType;
        }
    }
}

