/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.validation;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidatorContext;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.validation.ByteUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

public class ValidatorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatorHelper.class);
    private static final MessageLoader MESSAGES_LOADER = new MessageLoader(ValidatorHelper.class);
    private static final String HTTP_SSL_SCHEMA = "https";
    private static final String HTTP_SCHEMA = "http";
    private static final String WS_SCHEMA = "ws";
    static final String WS_SSL_SCHEMA = "wss";
    static final String DISABLE_PORT = "-1";
    static final String SSL_ENABLED = "true";
    static final String BEAN_SSL_ENABLED = "sslEnabled";
    static final String BEAN_SSL_SERVER_PORT = "sslServerPort";
    static final String BEAN_SSL_KEYSTORE_PATH = "sslKeyStorePath";
    static final String BEAN_SSL_KEYSTORE_TYPE = "keyStoreType";
    static final String BEAN_WEBSOCKET_URL = "websocketURL";
    static final String BEAN_UNENCRIPTED_PORT = "httpPort";
    static final String BEAN_SPARK_MASTER = "sparkMaster";
    static final String BEAN_SPARK_DEPLOY_MODE = "sparkDeployMode";
    static final String BEAN_HADOOP_CONF_DIR = "hadoopConfDir";
    static final String BEAN_HADOOP_USER = "hadoopUser";
    static final String BEAN_SPARK_HOME = "sparkHome";
    static final String BEAN_SPARK_APP = "sparkApp";
    static final String BEAN_SPARK_CLASS = "sparkAppClass";
    static final String BEAN_ASSEMBLY_ZIP = "assemblyZip";
    static final String BEAN_DRIVER_DEBUG_PORT = "driverDebugPort";
    static final String BEAN_EXECUTOR_DEBUG_PORT = "executorDebugPort";
    static final String BEAN_SPARK_DRIVER_MEMORY = "sparkDriverMemory";
    static final String BEAN_SPARK_EXECUTOR_MEMORY = "sparkExecutorMemory";
    static final String BEAN_KEYTABLOCATION = "keytab";
    static final String BEAN_KRB_PRINCIPAL = "kerberosPrincipal";
    static final String BEAN_HTTP_SEC_KEYTAB = "httpSecurityKeytabLocation";
    static final String BEAN_HTTP_SEC_PRINCIPAL = "httpSecurityPrincipal";
    static final String BEAN_DRV_SEC_KEYTAB = "driverSecurityKeytabLocation";
    static final String BEAN_DRV_SEC_PRINCIPAL = "driverSecurityPrincipal";
    static final String BEAN_DRV_SESSION_TIMEOUT = "driverSessionTimeout";
    static final String BEAN_DRV_SESSION_MAXLV_TIMEOUT = "driverSessionMaxLiving";
    static final String BEAN_DRV_SESSION_MAXIDLE_TIMEOUT = "driverSessionMaxIdle";
    static final String PRPTY_SSL_SERVER_PORT = "sslServerPort";
    static final String PRPTY_SSL_KEYSTORE_PATH = "ael.ssl.key-store";
    static final String PRPTY_SSL_KEYSTORE_TYPE = "ael.ssl.key-store-type";
    static final String PRPTY_SPARK_MASTER = "sparkMaster";
    static final String PRPTY_SPARK_DEPLOY_MODE = "sparkDeployMode";
    static final String PRPTY_WEBSOCKET_URL = "websocketURL";
    static final String PRPTY_HADOOP_CONF_DIR = "hadoopConfDir";
    static final String PRPTY_HADOOP_USER = "hadoopUser";
    static final String PRPTY_SPARK_HOME = "sparkHome";
    static final String PRPTY_SPARK_APP = "sparkApp";
    static final String PRPTY_SPARK_CLASS = "sparkAppClass";
    static final String PRPTY_ASSEMBLY_ZIP = "assemblyZip";
    static final String PRPTY_DRIVER_DEBUG_PORT = "driverDebugPort";
    static final String PRPTY_EXECUTOR_DEBUG_PORT = "executorDebugPort";
    static final String PRPTY_SPARK_DRIVER_MEMORY = "sparkDriverMemory";
    static final String PRPTY_SPARK_EXECUTOR_MEMORY = "sparkExecutorMemory";
    static final String PRPTY_UNENCRIPTED_PORT = "ael.unencrypted.port";
    static final String PRPTY_KEYTABLOCATION = "keytabLocation";
    static final String PRPTY_KRB_PRINCIPAL = "kerberosPrincipal";
    static final String PRPTY_HTTP_SEC_KEYTAB = "http.security.keytabLocation";
    static final String PRPTY_HTTP_SEC_PRINCIPAL = "http.security.principal";
    static final String PRPTY_DRV_SEC_KEYTAB = "driver.security.keytabLocation";
    static final String PRPTY_DRV_SEC_PRINCIPAL = "driver.security.principal";
    static final String PRPTY_DRV_SESSION_TIMEOUT = "driver.session.timeout";
    static final String PRPTY_DRV_SESSION_MXLV_TIMEOUT = "driver.session.maxLiving.timeout";
    static final String PRPTY_DRV_SESSION_MXIDL_TIMEOUT = "driver.session.maxIdle.timeout";
    static final String VLD_START_DBG_MSG = "validator.debug.startmessage";
    static final String VLD_END_DGB_MSG = "validator.debug.endmessage";
    static final String TST_RSLT_DBG_MSG = "validator.debug.testmessage";
    static final String UNEXPECTED_ERROR = "validator.error.unexpected";
    private static final int MAX_PORT_NUMBER = 65536;
    private static final String TEST_FAILED = "Failed";
    private static final String TEST_SUCCESS = "Success";
    private static final ImmutableMap<String, ByteUnit> byteSuffixes = ImmutableMap.builder().put((Object)"b", (Object)ByteUnit.BYTE).put((Object)"k", (Object)ByteUnit.KiB).put((Object)"kb", (Object)ByteUnit.KiB).put((Object)"m", (Object)ByteUnit.MiB).put((Object)"mb", (Object)ByteUnit.MiB).put((Object)"g", (Object)ByteUnit.GiB).put((Object)"gb", (Object)ByteUnit.GiB).put((Object)"t", (Object)ByteUnit.TiB).put((Object)"tb", (Object)ByteUnit.TiB).put((Object)"p", (Object)ByteUnit.PiB).put((Object)"pb", (Object)ByteUnit.PiB).build();
    private static final ImmutableMap<String, TimeUnit> timeSuffixes = ImmutableMap.builder().put((Object)"d", (Object)TimeUnit.DAYS).put((Object)"h", (Object)TimeUnit.HOURS).put((Object)"m", (Object)TimeUnit.MINUTES).put((Object)"s", (Object)TimeUnit.SECONDS).put((Object)"ms", (Object)TimeUnit.MILLISECONDS).put((Object)"ns", (Object)TimeUnit.NANOSECONDS).build();
    private static final long DRIVER_SESSION_TIMEOUT_MS_DEFAULT = 30000L;
    private static final String NUMERIC_SUFFIX_PATTERN = "([0-9]+)([a-z]+)?";
    private static final String NUMERIC_DECIMAL_SUFFIX_PATTERN = "([0-9]+\\.[0-9]+)([a-z]+)?";

    private static boolean pathExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    static boolean verifyIfPathExists(String path, String errorMessage, ConstraintValidatorContext constraintValidatorContext) {
        boolean valid = true;
        if (path != null && !path.isEmpty() && !ValidatorHelper.pathExists(path)) {
            constraintValidatorContext.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            valid = false;
        }
        return valid;
    }

    static boolean relatedValues(String value1, String value2, String messageValue1Empty, String messageValue2Empty, ConstraintValidatorContext constraintValidatorContext) {
        boolean valid = true;
        if (value1 != null && !value1.isEmpty()) {
            valid = ValidatorHelper.verifyMandatory(value2, messageValue2Empty, constraintValidatorContext);
        } else if (value2 != null && !value2.isEmpty()) {
            constraintValidatorContext.buildConstraintViolationWithTemplate(messageValue1Empty).addConstraintViolation();
            valid = false;
        }
        return valid;
    }

    static boolean verifyMandatory(String value, String errorMessage, ConstraintValidatorContext constraintValidatorContext) {
        boolean valid = true;
        if (value == null || value.isEmpty()) {
            constraintValidatorContext.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            valid = false;
        }
        return valid;
    }

    static boolean verifyPort(String value, String errorMessage, ConstraintValidatorContext constraintValidatorContext) {
        boolean valid = true;
        if (value != null && !value.isEmpty()) {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < -1 || intValue >= 65536) {
                    constraintValidatorContext.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
                    valid = false;
                }
            }
            catch (NumberFormatException e) {
                constraintValidatorContext.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
                valid = false;
            }
        }
        return valid;
    }

    static boolean verifyWebsocketURL(String value, String errorMessage, ConstraintValidatorContext constraintValidatorContext) {
        boolean valid = true;
        if (value != null && !value.isEmpty() && !ValidatorHelper.isValidWebsocketURL(value)) {
            constraintValidatorContext.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
            valid = false;
        }
        return valid;
    }

    static boolean verifyMemSize(String value, String errorMessage, ConstraintValidatorContext constraintValidatorContext) {
        return ValidatorHelper.verifySuffixes(value, errorMessage, byteSuffixes, constraintValidatorContext);
    }

    static boolean verifyTimeUnits(String value, String errorMessage, ConstraintValidatorContext constraintValidatorContext) {
        return ValidatorHelper.verifySuffixes(value, errorMessage, timeSuffixes, constraintValidatorContext);
    }

    private static boolean verifySuffixes(String value, String errorMessage, ImmutableMap suffixes, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null || value.isEmpty()) {
            return true;
        }
        boolean valid = true;
        try {
            String lower = value.toLowerCase().trim();
            Matcher m = Pattern.compile(NUMERIC_SUFFIX_PATTERN).matcher(lower);
            Matcher fractionMatcher = Pattern.compile(NUMERIC_DECIMAL_SUFFIX_PATTERN).matcher(lower);
            if (m.matches()) {
                String suffix = m.group(2);
                if (suffix != null && !suffixes.containsKey((Object)suffix)) {
                    valid = false;
                }
            } else {
                valid = fractionMatcher.matches() ? false : false;
            }
        }
        catch (NumberFormatException e) {
            valid = true;
        }
        if (!valid) {
            constraintValidatorContext.buildConstraintViolationWithTemplate(errorMessage).addConstraintViolation();
        }
        return valid;
    }

    public static long getTimeAsMs(String value) {
        String lower = value.toLowerCase().trim();
        long timeAsMs = 30000L;
        try {
            Matcher m = Pattern.compile(NUMERIC_SUFFIX_PATTERN).matcher(lower);
            if (m.matches()) {
                long valueL = Long.parseLong(m.group(1));
                String suffix = m.group(2);
                timeAsMs = TimeUnit.MILLISECONDS.convert(valueL, suffix != null ? (TimeUnit)((Object)timeSuffixes.get((Object)suffix)) : TimeUnit.MILLISECONDS);
            }
        }
        catch (NumberFormatException e) {
            LOG.error(MESSAGES_LOADER.get(UNEXPECTED_ERROR), (Throwable)e);
        }
        return timeAsMs;
    }

    public static long getMemAsBytes(String value) {
        String lower = value.toLowerCase().trim();
        long timeAsMs = 30000L;
        try {
            Matcher m = Pattern.compile(NUMERIC_SUFFIX_PATTERN).matcher(lower);
            if (m.matches()) {
                long valueL = Long.parseLong(m.group(1));
                String suffix = m.group(2);
                timeAsMs = ByteUnit.BYTE.convertFrom(valueL, suffix != null ? (ByteUnit)((Object)byteSuffixes.get((Object)suffix)) : ByteUnit.GiB);
            }
        }
        catch (NumberFormatException e) {
            LOG.error(MESSAGES_LOADER.get(UNEXPECTED_ERROR), (Throwable)e);
        }
        return timeAsMs;
    }

    public static boolean isValidWebsocketURL(String urlStr) {
        String auxStr;
        boolean isValid = false;
        String string = auxStr = urlStr != null ? urlStr.toLowerCase() : "";
        if (auxStr.toLowerCase().contains(WS_SCHEMA) || auxStr.toLowerCase().contains(WS_SSL_SCHEMA)) {
            isValid = ResourceUtils.isUrl((String)auxStr.replaceAll(WS_SSL_SCHEMA, HTTP_SSL_SCHEMA).replaceAll(WS_SCHEMA, HTTP_SCHEMA));
        }
        return isValid;
    }

    static String getTestResult(boolean testResult) {
        return testResult ? TEST_SUCCESS : TEST_FAILED;
    }
}

