/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.validation;

import java.lang.reflect.InvocationTargetException;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.validation.ValidatorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeUnitValidator {
    private static final Logger LOG = LoggerFactory.getLogger(TimeUnitValidator.class);
    private static final String TEST_MODULE = "validation.module.timeUnit";
    private static final String SPARK_DRIVER_ERROR_INVLD_VAL = "driver.session.timeout.error.invalidValue";
    private static final String SPARK_DRIVER_MXLV_ERROR_INVLD_VAL = "driver.session.maxLiving.timeout.error.invalidValue";
    private static final String SPARK_DRIVER_MXIDL_ERROR_INVLD_VAL = "driver.session.maxIdle.timeout.error.invalidValue";

    public static boolean isValid(Object obj, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) {
        boolean valid = true;
        try {
            LOG.debug(messages.get("validator.debug.startmessage", messages.get(TEST_MODULE)));
            constraintValidatorContext.disableDefaultConstraintViolation();
            valid = TimeUnitValidator.isValid(obj, "driverSessionTimeout", SPARK_DRIVER_ERROR_INVLD_VAL, "driver.session.timeout", valid, constraintValidatorContext, messages);
            valid = TimeUnitValidator.isValid(obj, "driverSessionMaxLiving", SPARK_DRIVER_MXLV_ERROR_INVLD_VAL, "driver.session.maxLiving.timeout", valid, constraintValidatorContext, messages);
            valid = TimeUnitValidator.isValid(obj, "driverSessionMaxIdle", SPARK_DRIVER_MXIDL_ERROR_INVLD_VAL, "driver.session.maxIdle.timeout", valid, constraintValidatorContext, messages);
            LOG.debug(messages.get("validator.debug.endmessage", messages.get(TEST_MODULE), ValidatorHelper.getTestResult(valid)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error(messages.get("validator.error.unexpected"), (Throwable)ex);
            constraintValidatorContext.buildConstraintViolationWithTemplate(ex.getMessage()).addConstraintViolation();
            valid = false;
        }
        return valid;
    }

    private static boolean isValid(Object obj, String beanField, String errorMsg, String propertyField, boolean valid, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String value = BeanUtils.getProperty((Object)obj, (String)beanField);
        boolean testValidation = ValidatorHelper.verifyTimeUnits(value, messages.get(errorMsg), constraintValidatorContext);
        LOG.debug(messages.get("validator.debug.testmessage", propertyField, ValidatorHelper.getTestResult(testValidation)));
        return testValidation ? valid : testValidation;
    }
}

