/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.validation;

import java.lang.reflect.InvocationTargetException;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.validation.ValidatorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortValidator {
    private static final Logger LOG = LoggerFactory.getLogger(PortValidator.class);
    private static final String TEST_MODULE = "validation.module.port";
    private static final String HTTP_PORT_INVALID = "ael.unencrypted.port.error.invalidPort";
    private static final String DRIVER_DBG_PORT_INVALID = "driverDebugPort.error.invalidPort";
    private static final String EXECUTOR_DBG_PORT_INVALID = "executorDebugPort.error.invalidPort";

    public static boolean isValid(Object obj, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) {
        boolean valid = true;
        try {
            LOG.debug(messages.get("validator.debug.startmessage", messages.get(TEST_MODULE)));
            constraintValidatorContext.disableDefaultConstraintViolation();
            valid = PortValidator.isValid(obj, "httpPort", HTTP_PORT_INVALID, "ael.unencrypted.port", valid, constraintValidatorContext, messages);
            valid = PortValidator.isValid(obj, "driverDebugPort", DRIVER_DBG_PORT_INVALID, "driverDebugPort", valid, constraintValidatorContext, messages);
            valid = PortValidator.isValid(obj, "executorDebugPort", EXECUTOR_DBG_PORT_INVALID, "executorDebugPort", valid, constraintValidatorContext, messages);
            LOG.debug(messages.get("validator.debug.endmessage", messages.get(TEST_MODULE), ValidatorHelper.getTestResult(valid)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error(messages.get("validator.error.unexpected"), (Throwable)ex);
            constraintValidatorContext.buildConstraintViolationWithTemplate(ex.getMessage()).addConstraintViolation();
            valid = false;
        }
        return valid;
    }

    private static boolean isValid(Object obj, String beanField, String errorMsg, String propertyField, boolean valid, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String value = BeanUtils.getProperty((Object)obj, (String)beanField);
        boolean testValidation = ValidatorHelper.verifyPort(value, messages.get(errorMsg), constraintValidatorContext);
        LOG.debug(messages.get("validator.debug.testmessage", propertyField, ValidatorHelper.getTestResult(testValidation)));
        return testValidation ? valid : testValidation;
    }
}

