/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.validation;

import java.lang.reflect.InvocationTargetException;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.validation.ValidatorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MandatoryValidator {
    private static final Logger LOG = LoggerFactory.getLogger(MandatoryValidator.class);
    private static final String TEST_MODULE = "validation.module.mandatory";
    private static final String WEBSOCKET_URL_ERROR_MNDT = "websocketURL.error.mandatory";
    private static final String HADOOOP_USER_ERROR_MNDT = "hadoopUser.error.mandatory";
    private static final String SPARK_HOME_ERROR_MNDT = "sparkHome.error.mandatory";
    private static final String SPARK_MASTER_ERROR_MNDT = "sparkMaster.error.mandatory";
    private static final String SPARK_DEPLOY_MODE_ERROR_MNDT = "sparkDeployMode.error.mandatory";
    private static final String SPARK_APP_ERROR_MNDT = "sparkApp.error.mandatory";
    private static final String SPARK_APP_CLASS_ERROR_MNDT = "sparkAppClass.error.mandatory";
    private static final String ASSEMBLY_ZIP_ERROR_MNDT = "assemblyZip.error.mandatory";
    private static final String SPARK_DRIVER_MEMORY_ERROR_MNDT = "sparkDriverMemory.error.mandatory";
    private static final String SPARK_EXECUTOR_MEMORY_ERROR_MNDT = "sparkExecutorMemory.error.mandatory";

    public static boolean isValid(Object obj, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) {
        boolean valid;
        try {
            LOG.debug(messages.get("validator.debug.startmessage", messages.get(TEST_MODULE)));
            constraintValidatorContext.disableDefaultConstraintViolation();
            valid = MandatoryValidator.isValid(obj, "websocketURL", WEBSOCKET_URL_ERROR_MNDT, "websocketURL", true, constraintValidatorContext, messages);
            valid = MandatoryValidator.isValid(obj, "hadoopUser", HADOOOP_USER_ERROR_MNDT, "hadoopUser", valid, constraintValidatorContext, messages);
            valid = MandatoryValidator.isValid(obj, "sparkHome", SPARK_HOME_ERROR_MNDT, "sparkHome", valid, constraintValidatorContext, messages);
            valid = MandatoryValidator.isValid(obj, "sparkMaster", SPARK_MASTER_ERROR_MNDT, "sparkMaster", valid, constraintValidatorContext, messages);
            valid = MandatoryValidator.isValid(obj, "sparkDeployMode", SPARK_DEPLOY_MODE_ERROR_MNDT, "sparkDeployMode", valid, constraintValidatorContext, messages);
            valid = MandatoryValidator.isValid(obj, "sparkApp", SPARK_APP_ERROR_MNDT, "sparkApp", valid, constraintValidatorContext, messages);
            valid = MandatoryValidator.isValid(obj, "sparkAppClass", SPARK_APP_CLASS_ERROR_MNDT, "sparkAppClass", valid, constraintValidatorContext, messages);
            valid = MandatoryValidator.isValid(obj, "assemblyZip", ASSEMBLY_ZIP_ERROR_MNDT, "assemblyZip", valid, constraintValidatorContext, messages);
            valid = MandatoryValidator.isValid(obj, "sparkDriverMemory", SPARK_DRIVER_MEMORY_ERROR_MNDT, "sparkDriverMemory", valid, constraintValidatorContext, messages);
            valid = MandatoryValidator.isValid(obj, "sparkExecutorMemory", SPARK_EXECUTOR_MEMORY_ERROR_MNDT, "sparkExecutorMemory", valid, constraintValidatorContext, messages);
            LOG.debug(messages.get("validator.debug.endmessage", messages.get(TEST_MODULE), ValidatorHelper.getTestResult(valid)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error(messages.get("validator.error.unexpected"), (Throwable)ex);
            constraintValidatorContext.buildConstraintViolationWithTemplate(ex.getMessage()).addConstraintViolation();
            valid = false;
        }
        return valid;
    }

    private static boolean isValid(Object obj, String beanField, String errorMsg, String propertyField, boolean valid, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String value = BeanUtils.getProperty((Object)obj, (String)beanField);
        boolean testValidation = ValidatorHelper.verifyMandatory(value, messages.get(errorMsg), constraintValidatorContext);
        LOG.debug(messages.get("validator.debug.testmessage", propertyField, ValidatorHelper.getTestResult(testValidation)));
        return testValidation && valid;
    }
}

