/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.validation;

import java.lang.reflect.InvocationTargetException;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.beanutils.BeanUtils;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.validation.ValidatorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListValuesValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ListValuesValidator.class);
    private static final String LOCAL_REGEX = "^local(\\[[0-9]+\\]|\\[\\*\\])?$";
    private static final String TEST_MODULE = "validation.module.listValues";
    private static final String SPARK_MASTER_ERROR_INCORRECTVALUES = "sparkMaster.error.incorrectValue";
    private static final String SPARK_DEPLOY_MODE_ERROR_INCORRECTVALUES = "sparkDeployMode.error.incorrectValue";
    private static final String YARN_MODE = "yarn";
    private static final String CLIENT_MODE = "client";
    private static final String CLUSTER_MODE = "cluster";

    public static boolean isValid(Object obj, ConstraintValidatorContext constraintValidatorContext, MessageLoader messages) {
        boolean valid = true;
        try {
            LOG.debug(messages.get("validator.debug.startmessage", messages.get(TEST_MODULE)));
            constraintValidatorContext.disableDefaultConstraintViolation();
            String value = BeanUtils.getProperty((Object)obj, (String)"sparkMaster");
            if (value == null || !value.matches(LOCAL_REGEX) && !YARN_MODE.equals(value)) {
                constraintValidatorContext.buildConstraintViolationWithTemplate(messages.get(SPARK_MASTER_ERROR_INCORRECTVALUES)).addConstraintViolation();
                valid = false;
            }
            LOG.debug(messages.get("validator.debug.testmessage", "sparkMaster", ValidatorHelper.getTestResult(valid)));
            value = BeanUtils.getProperty((Object)obj, (String)"sparkDeployMode");
            if (!CLIENT_MODE.equals(value) && !CLUSTER_MODE.equals(value)) {
                constraintValidatorContext.buildConstraintViolationWithTemplate(messages.get(SPARK_DEPLOY_MODE_ERROR_INCORRECTVALUES)).addConstraintViolation();
                valid = false;
                LOG.debug(messages.get("validator.debug.testmessage", "sparkDeployMode", ValidatorHelper.getTestResult(false)));
            } else {
                LOG.debug(messages.get("validator.debug.testmessage", "sparkDeployMode", ValidatorHelper.getTestResult(true)));
            }
            LOG.debug(messages.get("validator.debug.endmessage", messages.get(TEST_MODULE), ValidatorHelper.getTestResult(valid)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            LOG.error(messages.get("validator.error.unexpected"), (Throwable)ex);
            constraintValidatorContext.buildConstraintViolationWithTemplate(ex.getMessage()).addConstraintViolation();
            valid = false;
        }
        return valid;
    }
}

