/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.validation;

import org.pentaho.adaptive.daemon.config.MessageLoader;

public enum ByteUnit {
    BYTE(1L),
    KiB(1024L),
    MiB((long)Math.pow(1024.0, 2.0)),
    GiB((long)Math.pow(1024.0, 3.0)),
    TiB((long)Math.pow(1024.0, 4.0)),
    PiB((long)Math.pow(1024.0, 5.0));

    private MessageLoader MESSAGES_LOADER = new MessageLoader(ByteUnit.class);
    private static final String MSG_CONVERSION_EXCEEDS_LONG = "ByteUnit.Conversion_Exceeds_LongMaxValue";
    private final long multiplier;

    private ByteUnit(long multiplier) {
        this.multiplier = multiplier;
    }

    public long convertFrom(long d, ByteUnit u) {
        return u.convertTo(d, this);
    }

    public long convertTo(long d, ByteUnit u) {
        if (this.multiplier > u.multiplier) {
            long ratio = this.multiplier / u.multiplier;
            if (Long.MAX_VALUE / ratio < d) {
                throw new IllegalArgumentException(this.MESSAGES_LOADER.get(MSG_CONVERSION_EXCEEDS_LONG, d, this.name()));
            }
            return d * ratio;
        }
        return d / (u.multiplier / this.multiplier);
    }
}

