/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.spark;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.launcher.SparkLauncher;
import org.pentaho.adaptive.daemon.ApplicationProperties;
import org.pentaho.adaptive.daemon.config.MessageLoader;
import org.pentaho.adaptive.daemon.spark.SparkConfigGenerator;
import org.pentaho.adaptive.daemon.validation.ValidatorHelper;
import org.pentaho.di.engine.api.remote.ExecutionRequest;
import org.pentaho.di.engine.model.ActingPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SparkRunner {
    private static final Logger LOG = LoggerFactory.getLogger(SparkRunner.class);
    private static final String ENDPOINT_SRV = "/execution";
    private static final String ENV_PROPERTY_TRANSFORMATION_NAME = "Internal.Transformation.Name";
    private static final String ADAPTIVE_EXECUTION_DIR = "/adaptive-execution";
    private static final String SPARK_CONF_DIR_NAME = "sparkConf";
    private static final String YARN = "yarn";
    private static final String SPARK_HOME = "SPARK_HOME";
    private static final String SPARK_CONF_DIR = "SPARK_CONF_DIR";
    private static final String HADOOP_CONF_DIR = "HADOOP_CONF_DIR";
    private static final String HADOOP_USER_NAME = "HADOOP_USER_NAME";
    private static final String SPARK_EVLOG_ENBL = "spark.eventLog.enabled";
    private static final String SPARK_EVLOG_DIR = "spark.eventLog.dir";
    private static final String LIB = "lib";
    private static final String PDI_SPK_DRV = "pdi-spark-driver";
    private static final String JAR_EXT = ".jar";
    private static final String KTAB_LOC = "keytabLocation=%s";
    private static final String KRB_PRINC = "kerberosPrincipal=%s";
    private static final String DRV_SEC_KTAB = "driver.security.keytabLocation=%s";
    private static final String DRV_SEC_PRINC = "driver.security.principal=%s";
    private static final String DSB_PRXY_USER = "disableProxyUser=%s";
    private static final String DRV_WSCK_MAX_BUF_SIZE = "driverWebsocketMaxMessageBufferSize=%s";
    private static final String DRV_MAX_LVNG_TOUT = "driverMaxLivingTimeout=%d";
    private static final String DRV_MAX_IDLE_TOUT = "driverMaxIdleTimeout=%d";
    private static final String MX_REQ_THREADS = "maxRequestThreads=%d";
    private static final String SPK_RUN_NOMAIN_JAR_ERROR = "SparkRunner.NoMainJarError";
    private static final String SPARK_RUNNER_ERROR = "SparkRunner.UnexpectedError";
    private static final String SPARK_RUNNER_PRXY_USER_NOT_SPECIFIED = "SparkRunner.ProxyUserNotSpecifiedError";
    private static final String SPARK_RUNNER_PROXY_USER_NO_PRINC_WARN = "SparkRunner.ProxyUserNoPrincipalWarning";
    private static final String SPARK_RUNNER_NO_KEYTAB_WARN = "SparkRunner.NoKeyTabWarning";
    private static final String ARG_PRINCIPAL = "--principal";
    private static final String ARG_KTAB = "--keytab";
    private static final String ARG_PRX_USER = "--proxy-user";
    private ApplicationProperties config;
    private SparkConfigGenerator sparkConfigGenerator;
    private static final MessageLoader MESSAGE_LOADER = new MessageLoader(SparkRunner.class);

    @Autowired
    public SparkRunner(ApplicationProperties applicationProperties, SparkConfigGenerator sparkConfigGenerator) {
        this.config = applicationProperties;
        this.sparkConfigGenerator = sparkConfigGenerator;
    }

    public SparkAppHandle execute(ExecutionRequest executionRequest) {
        try {
            String requestId = executionRequest.getRequestId();
            Principal principal = executionRequest.getActingPrincipal();
            boolean isYarn = this.config.getSparkMaster().equalsIgnoreCase(YARN);
            String transformationName = (String)executionRequest.getEnvironment().get(ENV_PROPERTY_TRANSFORMATION_NAME);
            File confDir = new File(this.config.getSparkApp() + ADAPTIVE_EXECUTION_DIR, SPARK_CONF_DIR_NAME);
            File dataIntegrationHome = new File(this.config.getSparkApp());
            HashMap<String, String> env = new HashMap<String, String>();
            env.put(SPARK_HOME, this.config.getSparkHome());
            env.put(SPARK_CONF_DIR, confDir.toString());
            env.put(HADOOP_CONF_DIR, this.config.getHadoopConfDir());
            env.put(HADOOP_USER_NAME, this.config.getHadoopUser());
            SparkLauncher sparkLauncher = isYarn ? this.yarnSparkLauncher(env) : this.localSparkLauncher(env);
            sparkLauncher.setMaster(this.config.getSparkMaster());
            sparkLauncher.directory(dataIntegrationHome);
            sparkLauncher.setVerbose(true);
            sparkLauncher.setAppName(transformationName);
            sparkLauncher.setConf(SPARK_EVLOG_ENBL, String.valueOf(this.config.isSparkEventLogEnabled()));
            if (this.config.isSparkEventLogEnabled() && this.config.getSparkEventLogDir() != null) {
                sparkLauncher.setConf(SPARK_EVLOG_DIR, this.config.getSparkEventLogDir());
            }
            Path lib = FileSystems.getDefault().getPath(this.config.getSparkApp(), LIB);
            Path engineJarPath = Files.find(lib, 1, (path, basicFileAttributes) -> path.toString().contains(PDI_SPK_DRV) && path.toString().endsWith(JAR_EXT), new FileVisitOption[0]).findFirst().orElseThrow(() -> new IllegalStateException(MESSAGE_LOADER.get(SPK_RUN_NOMAIN_JAR_ERROR)));
            List<String> jars = Files.find(lib, 1, (path, basicFileAttributes) -> path.toString().endsWith(JAR_EXT), new FileVisitOption[0]).map(p -> p.toFile().getAbsoluteFile().toURI().toString()).collect(Collectors.toList());
            this.sparkConfigGenerator.createSparkDefaults(confDir, jars, executionRequest.getParameters(), executionRequest.getEnvironment());
            sparkLauncher.setAppResource(engineJarPath.toAbsolutePath().toString());
            sparkLauncher.setMainClass(this.config.getSparkAppClass());
            Stream.of(requestId, this.config.getWebsocketURL() + ENDPOINT_SRV, String.format(KTAB_LOC, this.config.getKeytab()), String.format(KRB_PRINC, this.config.getKerberosPrincipal()), String.format(DRV_SEC_KTAB, this.config.getDriverSecurityKeytabLocation()), String.format(DRV_SEC_PRINC, this.config.getDriverSecurityPrincipal()), String.format(DSB_PRXY_USER, this.config.isDisableProxyUser()), String.format(DRV_WSCK_MAX_BUF_SIZE, this.config.getDriverWebsocketMaxMessageBufferSize())).forEach(xva$0 -> sparkLauncher.addAppArgs(new String[]{xva$0}));
            sparkLauncher.addAppArgs(new String[]{String.format(DRV_MAX_LVNG_TOUT, ValidatorHelper.getTimeAsMs(this.config.getDriverSessionMaxLiving()))});
            sparkLauncher.addAppArgs(new String[]{String.format(DRV_MAX_IDLE_TOUT, ValidatorHelper.getTimeAsMs(this.config.getDriverSessionMaxIdle()))});
            sparkLauncher.addAppArgs(new String[]{String.format(MX_REQ_THREADS, this.config.getMaxRequestThreads())});
            this.addSparkSecurityArgs(principal, sparkLauncher);
            sparkLauncher.setVerbose(true);
            return sparkLauncher.startApplication(new SparkAppHandle.Listener[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(MESSAGE_LOADER.get(SPARK_RUNNER_ERROR), e);
        }
    }

    void addSparkSecurityArgs(Principal actingPrincipal, SparkLauncher sparkLauncher) {
        if (!this.hasSecurityProperties()) {
            return;
        }
        String keytab = this.config.getKeytab();
        if (new File(keytab).exists()) {
            if (this.config.isDisableProxyUser()) {
                sparkLauncher.addSparkArg(ARG_PRINCIPAL, this.config.getKerberosPrincipal());
                sparkLauncher.addSparkArg(ARG_KTAB, keytab);
            } else {
                if (ActingPrincipal.ANONYMOUS.equals((Object)actingPrincipal)) {
                    throw new RuntimeException(MESSAGE_LOADER.get(SPARK_RUNNER_PRXY_USER_NOT_SPECIFIED));
                }
                sparkLauncher.addSparkArg(ARG_PRX_USER, actingPrincipal.getName());
            }
        }
    }

    boolean hasSecurityProperties() {
        if (this.config.isDisableProxyUser() && this.config.getKerberosPrincipal() == null) {
            LOG.warn(MESSAGE_LOADER.get(SPARK_RUNNER_PROXY_USER_NO_PRINC_WARN));
            return false;
        }
        if (this.config.getKeytab() == null) {
            LOG.warn(MESSAGE_LOADER.get(SPARK_RUNNER_NO_KEYTAB_WARN));
            return false;
        }
        return true;
    }

    private SparkLauncher localSparkLauncher(Map<String, String> env) {
        return new SparkLauncher(env);
    }

    private SparkLauncher yarnSparkLauncher(Map<String, String> env) {
        SparkLauncher yarnSpark = new SparkLauncher(env);
        yarnSpark.setDeployMode(this.config.getSparkDeployMode());
        return yarnSpark;
    }
}

