/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.adaptive.daemon.spark;

public enum SparkPropertyBlacklistEnum {
    SPARK_MASTER_PROP("spark.master"),
    SPARK_YARN_DIST_ARCHIVE_PROP("spark.yarn.dist.archives"),
    SPARK_JARS_PROP("spark.jars"),
    SPARK_APP_NAME("spark.app.name");

    private String sparkPropertyName;

    private SparkPropertyBlacklistEnum(String sparkPropertyName) {
        this.sparkPropertyName = sparkPropertyName;
    }

    public static boolean isSparkPropertyBlacklisted(String sparkPropertyName) {
        return SparkPropertyBlacklistEnum.getSparkPropBlacklistEnum(sparkPropertyName) != null;
    }

    public static SparkPropertyBlacklistEnum getSparkPropBlacklistEnum(String sparkPropertyName) {
        SparkPropertyBlacklistEnum[] enumValues = SparkPropertyBlacklistEnum.values();
        if (sparkPropertyName == null || sparkPropertyName.trim().isEmpty()) {
            return null;
        }
        for (SparkPropertyBlacklistEnum blacklistProp : enumValues) {
            if (!blacklistProp.getSparkPropertyName().equalsIgnoreCase(sparkPropertyName)) continue;
            return blacklistProp;
        }
        return null;
    }

    public String getSparkPropertyName() {
        return this.sparkPropertyName;
    }
}

